#include <stdio.h>
#include <allegro.h>


static char *scancode_names[128] = {
"Doesn't exist (0)",        // 0
"KEY_ESC",        // 1
"KEY_1",        // 2 
"KEY_2",        // 3 
"KEY_3",        // 4
"KEY_4",        // 5
"KEY_5",        // 6
"KEY_6",        // 7
"KEY_7",        // 8
"KEY_8",        // 9
"KEY_9",        // 10
"KEY_0",        // 11
"KEY_MINUS",        // 12
"KEY_EQUALS",        // 13
"KEY_BACKSPACE",        // 14
"KEY_TAB",        // 15 
"KEY_Q",        // 16
"KEY_W",        // 17
"KEY_E",        // 18
"KEY_R",        // 19
"KEY_T",        // 20
"KEY_Y",        // 21
"KEY_U",        // 22
"KEY_I",        // 23
"KEY_O",        // 24
"KEY_P",        // 25
"KEY_OPENBRACE",        // 26
"KEY_CLOSEBRACE",        // 27
"KEY_ENTER",        // 28
"KEY_CONTROL",        // 29
"KEY_A",        // 30
"KEY_S",        // 31
"KEY_D",        // 32
"KEY_F",        // 33
"KEY_G",        // 34
"KEY_H",        // 35
"KEY_J",        // 36
"KEY_K",        // 37
"KEY_L",        // 38
"KEY_COLON",        // 39
"KEY_QUOTE",        // 40
"KEY_TILDE",        // 41
"KEY_LSHIFT",        // 42
"KEY_BACKSLASH",        // 43
"KEY_Z",        // 44
"KEY_X",        // 45
"KEY_C",        // 46
"KEY_V",        // 47
"KEY_B",        // 48
"KEY_N",        // 49
"KEY_M",        // 50
"KEY_COMMA",        // 51
"KEY_STOP",        // 52
"KEY_SLASH",        // 53
"KEY_RSHIFT",        // 54
"KEY_ASTERISK",        // 55
"KEY_ALT",        // 56
"KEY_SPACE",        // 57
"KEY_CAPSLOCK",        // 58
"KEY_F1",        // 59
"KEY_F2",        // 60
"KEY_F3",        // 61
"KEY_F4",        // 62
"KEY_F5",        // 63
"KEY_F6",        // 64
"KEY_F7",        // 65
"KEY_F8",        // 66
"KEY_F9",        // 67
"KEY_F10",        // 68
"KEY_NUMLOCK",        // 69
"KEY_SCRLOCK",        // 70
"KEY_HOME",        // 71
"KEY_UP",        // 72
"KEY_PGUP",        // 73
"KEY_MINUS_PAD",        // 74
"KEY_LEFT",        // 75
"KEY_5_PAD",        // 76
"KEY_RIGHT",        // 77
"KEY_PLUS_PAD",        // 78
"KEY_END",        // 79
"KEY_DOWN",        // 80
"KEY_PGDN",        // 81
"KEY_INSERT",        // 82
"KEY_DEL",        // 83
"Doesn't exist (84)",
"Doesn't exist (85)",
"Doesn't exist (86)",
"KEY_F11",        // 87
"KEY_F12",        // 88
"Doesn't exist (89)",
"Doesn't exist (90)",
"Doesn't exist (91)",
"Doesn't exist (92)",
"Doesn't exist (93)",
"Doesn't exist (94)",
"Doesn't exist (95)",
"Doesn't exist (96)",
"Doesn't exist (97)",
"Doesn't exist (98)",
"Doesn't exist (99)",
"KEY_PAD",        // 100
"Doesn't exist (101)",
"Doesn't exist (102)",
"Doesn't exist (103)",
"Doesn't exist (104)",
"Doesn't exist (105)",
"Doesn't exist (106)",
"Doesn't exist (107)",
"Doesn't exist (108)",
"Doesn't exist (109)",
"Doesn't exist (110)",
"Doesn't exist (111)",
"Doesn't exist (112)",
"Doesn't exist (113)",
"Doesn't exist (114)",
"Doesn't exist (115)",
"Doesn't exist (116)",
"Doesn't exist (117)",
"Doesn't exist (118)",
"Doesn't exist (119)",
"Doesn't exist (120)",
"Doesn't exist (121)",
"Doesn't exist (122)",
"Doesn't exist (123)",
"Doesn't exist (124)",
"Doesn't exist (125)",
"Doesn't exist (126)",
"Doesn't exist (127)"
};


int main(void)
{
    int result = 0;
    unsigned char high_byte = 0, low_byte = 0;



    allegro_init();
    install_keyboard();

    while(low_byte != 27)
    {
        result    = readkey();
        high_byte = (result & 0xFF00) >> 8;
        low_byte  = result & 0x00FF;
        fprintf(stderr, "\nresult=0x%04X, high_byte=%03d (%s), low_byte=%03d",
               result,
               high_byte,
               scancode_names[high_byte],
               low_byte);
    }

    return(0);
}
