indexing
    description    : "Allegro con Eiffel: palette objects"
    status         : "Initial development"
    author         : "Peter Monks (pmonks@iname.com)"
    allegro_author : "Shawn Hargreaves (shawn@talula.demon.co.uk)"
    names          : palette
    date_started   : "1st December, 1996"
    version        : "0.1 beta"
    platforms      : "MS-DOS"
    dependencies   : "Allegro v2.2, DJGPP v2.01"


class PALETTE


inherit
    ACE_INFORMATION_SINGLETON  -- implementation inheritance
    end                        -- inherit ACE_INFORMATION_SINGLETON

    ANY
        redefine copy, is_equal
    end  -- inherit ANY


creation { ANY }
    make

creation { DATAFILE }
    make_from_external


------------------------------------------------------ Creation features
feature { ANY }

    make is
    -- Allocate memory for a palette
    require
        ace_initialised   : info.ace_initialised
    do
        if is_valid then
            discard
        end  -- if

        c_inline_c("C->_data=malloc(sizeof(PALETTE));if(C->_data)memset(C->_data,0,sizeof(PALETTE));")
    ensure
        is_valid : is_valid
    end  -- feature make


------------------------------------------------------ Creation features (DATAFILE)
feature { DATAFILE }

    make_from_external(p : POINTER) is
    -- Create a palette from a C pointer
    require
        ace_initialised : info.ace_initialised
        p_is_valid      : p.is_not_void
    do
        if is_valid then
            discard
        end  -- if

        data := p
    ensure
        is_valid : is_valid
    end  -- feature make_from_external


------------------------------------------------------ Internal features
feature { PALETTE, BITMAP }

    data : POINTER


------------------------------------------------------ Palette features
feature { ANY }

    is_valid : BOOLEAN is
    -- Indicates whether this palette is valid or not
    do
        Result := data.is_not_void
    end  -- feature is_valid


    discard is
    -- Discard this palette
    require
        ace_initialised : info.ace_initialised
        is_valid        : is_valid
    do
        c_inline_c("free(C->_data);C->_data=NULL;")
    ensure
        not_valid : not is_valid
    end  -- feature discard


    get_palette_colour(index : INTEGER) : RGB18BIT is
    -- Retrieve the specified colour
    require
        ace_initialised : info.ace_initialised
        is_valid        : is_valid
        index_is_valid  : index >= 0 and index <= 255
    local
        r : INTEGER
        g : INTEGER
        b : INTEGER
    do
        c_inline_c("_r=C->_data[a1].r;_g=C->_data[a1].g;_b=C->_data[a1].b;")
        !!Result.make(r,g,b)
    ensure
        result_is_valid : Result /= Void
    end  -- feature get_palette_colour


    set_palette_colour(index : INTEGER; colour : RGB18BIT) is
    -- Set the specified index to the specified colour
    require
        ace_initialised : info.ace_initialised
        is_valid        : is_valid
        index_is_valid  : index  >= 0 and index <= 255
        colour_is_valid : colour /= Void
    local
        r : INTEGER
        g : INTEGER
        b : INTEGER
    do
        r := colour.red
        g := colour.green
        b := colour.blue
        c_inline_c("C->_data[a1].r=_r;C->_data[a1].g=_g;C->_data[a1].b=_b;")
    end  -- feature set_palette_colour


    get is
    -- Retrieve the current hardware palette into this palette object
    require
        ace_initialised : info.ace_initialised
        is_valid        : is_valid
    do
        c_inline_c("get_palette(C->_data);")
    end  -- feature get


    put is
    -- Put this palette (set it as the current hardware palette)
    require
        ace_initialised : info.ace_initialised
        is_valid        : is_valid
    do
        c_inline_c("set_palette(C->_data);")
    end  -- feature put


    get_range(from_index, to_index : INTEGER) is
    -- Get the specified range of the current hardware palette
    require
        ace_initialised     : info.ace_initialised
        is_valid            : is_valid
        from_index_is_valid : from_index >= 0 and from_index <= 255
        to_index_is_valid   : to_index >= 0 and to_index <= 255 and to_index >= from_index
    do
        c_inline_c("get_palette_range(C->_data,a1,a2);")
    end  -- feature get_range


    put_range(from_index, to_index : INTEGER) is
    -- Put the specified range of this palette
    -- (set it as the current hardware palette)
    require
        ace_initialised     : info.ace_initialised
        is_valid            : is_valid
        from_index_is_valid : from_index >= 0 and from_index <= 255
        to_index_is_valid   : to_index >= 0 and to_index <= 255 and to_index >= from_index
    do
        c_inline_c("set_palette_range(C->_data,a1,a2,1);")
    end  -- feature get_range


    interpolate(source, destination : PALETTE;
                position, from_index, to_index : INTEGER) is
    -- Set Current to the palette between the source and destination
    -- palettes.
    require
        ace_initialised      : info.ace_initialised
        is_valid             : is_valid
        source_is_valid      : source /= Void and then
                               source.valid
        destination_is_valid : destination /= Void and then
                               destination.valid
        position_is_valid    : position >= 0 and position <= 64
        from_index_is_valid  : from_index >= 0 and from_index <= 255
        to_index_is_valid    : to_index >= 0 and to_index <= 255 and to_index >= from_index
    do
        c_inline_c("fade_interpolate(a1._data,a2._data,C->_data,a3,a4,a5);")
    end  -- feature interpolate


    fade_out(speed : INTEGER) is
    -- Fade Current and the current hardware palette to black
    require
        ace_initialised : info.ace_initialised
        is_valid        : is_valid
        speed_is_valid  : speed >= 1 and speed <= 64
    do
        c_inline_c("fade_out(a1);")
        set_to_black
    end  -- feature fade_out


    fade_in(speed : INTEGER) is
    -- Fade the current hardware palette from black to the current palette
    require
        ace_initialised : info.ace_initialised
        is_valid        : is_valid
        speed_is_valid  : speed >= 1 and speed <= 64
    do
        c_inline_c("fade_in(C->_data,a1);")
    end  -- feature fade_in


    fade_to(destination : PALETTE; speed : INTEGER) is
    -- Fade the current hardware palette from the current palette to
    -- the destination palette
    require
        ace_initialised      : info.ace_initialised
        is_valid             : is_valid
        destination_is_valid : destination /= Void and then
                               destination.valid
        speed_is_valid       : speed >= 1 and speed <= 64
    do
        c_inline_c("fade_from(C->_data,a1._data,a2);")
        clone(destination)
    end  -- feature fade_to


    fade_out_range(speed, from_index, to_index : INTEGER) is
    -- Fade the specified part of the current hardware palette to black
    require
        ace_initialised     : info.ace_initialised
        is_valid            : is_valid
        speed_is_valid      : speed >= 1 and speed <= 64
        from_index_is_valid : from_index >= 0 and from_index <= 255
        to_index_is_valid   : to_index >= 0 and to_index <= 255 and to_index >= from_index
    do
        c_inline_c("fade_out_range(a1,a2,a3);memset(C->_data+(a2*3),0,(a3-a2+1)*3);")
    end  -- feature fade_out_range


    fade_in_range(speed, from_index, to_index : INTEGER) is
    -- Fade the specified part of the current hardware palette from black to the current palette
    require
        ace_initialised     : info.ace_initialised
        is_valid            : is_valid
        speed_is_valid      : speed >= 1 and speed <= 64
        from_index_is_valid : from_index >= 0 and from_index <= 255
        to_index_is_valid   : to_index >= 0 and to_index <= 255 and to_index >= from_index
    do
        c_inline_c("fade_in_range(C->_data,a1,a2,a3);")
    end  -- feature fade_in_range


    fade_to_range(destination : PALETTE;
                  speed, from_index, to_index : INTEGER) is
    -- Fade the current hardware palette from the current palette to
    -- the destination palette
    require
        ace_initialised      : info.ace_initialised
        is_valid             : is_valid
        destination_is_valid : destination /= Void and then
                               destination.valid
        speed_is_valid       : speed >= 1 and speed <= 64
        from_index_is_valid  : from_index >= 0 and from_index <= 255
        to_index_is_valid    : to_index >= 0 and to_index <= 255 and to_index >= from_index
    do
        c_inline_c("fade_from_range(C->_data,a1._data,a2,a3,a4);")
        clone(destination)
    end  -- feature fade_to_range


    set_to_black is
    -- Set this palette to black
    require
        ace_initialised : info.ace_initialised
        is_valid        : is_valid
    do
        c_inline_c("memcpy(C->_data, black_palette, sizeof(PALETTE));")
    end  -- feature set_to_black


    set_to_desktop is
    -- Set this palette to the Amiga desktop palette
    require
        ace_initialised : info.ace_initialised
        is_valid        : is_valid
    do
        c_inline_c("memcpy(C->_data, desktop_palette, sizeof(PALETTE));")
    end  -- feature set_to_desktop


    copy(other : PALETTE) is
    -- Copy other into this palette
    require else
        ace_initialised : info.ace_initialised
        is_valid        : is_valid
        other_is_valid  : other /= Void and then
                          other /= Current and then
                          other.is_valid
    local
        p : POINTER
    do
        p := other.data
        c_inline_c("memcpy(C->_data,_p,sizeof(PALETTE));")
    end  -- feature copy


    is_equal(other : PALETTE) : BOOLEAN is
    -- Is this palette equal to the 'other' palette?
    require else
        ace_initialised : info.ace_initialised
        is_valid        : is_valid
        other_is_valid  : other /= Void and then
                          other.is_valid
    local
        p : POINTER
    do
        if other = Current then
            Result := TRUE
        else
            p := other.data
            c_inline_c("R=!memcmp(C->_data,_p,sizeof(PALETTE));")
        end  -- if
    end  -- feature is_equal


------------------------------------------------------ Class invariant
invariant

    consistency : is_valid implies data.is_not_void and
                  not is_valid implies data.is_void


end  -- class PALETTE

