#! /bin/sh

# Unfortunately some .po files from shar utils 4.2.2 are broken.
# This script will fix them.

PATH_SEPARATOR=:
PATH=$PATH:.

# A sane default for XSRC.
if [ "x$XSRC" = x ]; then
  XSRC=.
fi
 
# Find the .po files.
if [ -d "$XSRC"/po ]; then
  po_directory=po
elif [ -d "$XSRC"/i18n ]; then
  po_directory=i18n
else
  exit 0             # No .po files at all.
fi

# Ckeck if .po files have already been fixed
if [ -f "$XSRC"/${po_directory}/stamp-fix ]; then
  exit 0
fi

sed '/^"Content-Type:/ s/8859-1/ISO-8859-1/' "$XSRC"/${po_directory}/fr.po > po_file.fixed
dtou po_file.fixed
mv -f po_file.fixed "$XSRC"/${po_directory}/fr.po
rm -f script.sed

touch "$XSRC"/${po_directory}/stamp-fix
