"======================================================================
|
|   C function definitions
|
|   $Revision: 1.7.5$
|   $Date: 2000/05/28 16:56:52$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LESSER.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"


IPAddress class
	defineCFunc: 'TCPlookupAllHostAddr'
	withSelectorArgs: 'lookupAllHostAddr: name'
	returning: #cObject
	args: #(string).

IPAddress class
	defineCFunc: 'TCPgetHostByAddr'
	withSelectorArgs: 'primName: address'
	returning: #stringOut
	args: #(byteArray).
!

IPAddress class
	defineCFunc: 'TCPgetLocalName'
	withSelectorArgs: 'primLocalName'
	returning: #stringOut
	args: #().
!

IPAddress class
	defineCFunc: 'TCPgetAnyLocalAddress'
	withSelectorArgs: 'primAnyLocalAddress: hostName in: byteArray'
	returning: #void
	args: #(string byteArrayOut).
!


#(('TCPgetAF' 		  'afInet'		IPAddress)
  ('TCPgetPF'		  'pfInet' 		IPAddress)
  ('TCPsolSocket'	  'solSocket'     	AbstractSocketImpl)
  ('TCPipprotoIp'    	  'ipprotoIp'    	AbstractSocketImpl)
  ('TCPipprotoTcp'    	  'ipprotoTcp'    	AbstractSocketImpl)
  ('TCPipMulticastTtl'	  'ipMulticastTtl'	DatagramSocketImpl)
  ('TCPipMulticastIf'	  'ipMulticastIf'	DatagramSocketImpl)
  ('TCPipAddMembership'	  'ipAddMembership'	DatagramSocketImpl)
  ('TCPipDropMembership'  'ipDropMembership'	DatagramSocketImpl))

do: [ :each |
    (Namespace current classAt: (each at: 3)) class
    	defineCFunc: (each at: 1)
	withSelectorArgs: (each at: 2)
	returning: #long
	args: #().
].


#(('TCPaccept'  'accept: socket  peer: peer addrLen: len' int (int byteArrayOut byteArray))
  ('TCPbind'    'bind: socket    to: addr   addrLen: len' int (int byteArray    int))
  ('TCPconnect' 'connect: socket to: addr   addrLen: len' int (int byteArray    int))
  ('TCPlisten'  'listen: socket  log: len'		int (int int))

  ('TCPgetpeername' 'getPeerName: socket addr: addr addrLen: len' int (int byteArrayOut byteArray))
  ('TCPgetsockname' 'getSockName: socket addr: addr addrLen: len' int (int byteArrayOut byteArray))

  ('TCPrecvfrom' 'receive: socket buffer: buf size: len flags: flags from: addr size: addrLen' int (int byteArrayOut int int byteArray int))
  ('TCPsendto'   'send:    socket buffer: buf size: len flags: flags to: addr   size: addrLen' int (int byteArray    int int unknown   int))

  ('TCPsetsockopt'  'option: socket level: level at: name put: value size: len' int (int int int byteArray    int))
  ('TCPgetsockopt'  'option: socket level: level at: name get: value size: len' int (int int int byteArrayOut int))

  ('TCPsocket'      'create: family type: type protocol: protocol' int (int int int))
)

do: [ :each |
    TCPSocketImpl
	perform: #defineCFunc:withSelectorArgs:returning:args:
	withArguments: each.

    UDPSocketImpl
	perform: #defineCFunc:withSelectorArgs:returning:args:
	withArguments: each.
]!
