#! /bin/sh

top=`pwd`
archive=${1-gcc-4.4.2.tar.bz2}
contact="Andris Pavenis <andris.pavenis@iki.fi>";

export SHELL=$DJDIR/bin/sh.exe

##################################################################
#  Edit the following lines to specify location of autoconf      #
#  Both versions (2.13 and 2.59 are required)                    #
#----------------------------------------------------------------#
#  Following 2 lines specify location of autoconf-2.13           #
#----------------------------------------------------------------#
# You must edit these lines according location of them on        #
# Your system (I build and installed them at prefix              #
#    /dev/env/DJDIR/old)                                         # 
#----------------------------------------------------------------#
AUTOCONF_OLD=/usr/bin/autoconf-2.13
AUTOHEADER_OLD=/usr/bin/autoheader-2.13
#AUTOCONF_OLD=/disk2/usr/bin/autoconf
#AUTOHEADER_OLD=/disk2/usr/bin/autoheader
#----------------------------------------------------------------#
#  Following 2 lines specify location of autoconf-2.57           #
#----------------------------------------------------------------#
AUTOCONF=autoconf
AUTOHEADER=autoheader
##################################################################

#exec >unpack-`date +%y%m%d` 2>&1

rm -f $top/s-sources
rm -f $top/s-patch

rm -rf gnu
mkdir gnu
case $archive in 
      *.tgz | *.tar.gz )
         ( cd gnu && tar xzf $top/$archive && echo $archive >$top/s-sources )
         ;;
      *.tar.bz2 )
         ( cd gnu && tar xf $top/$archive --use=bzip2 && echo $archive >$top/s-sources )
         ;;
      *)
         echo Unknown archive format
	 exit 1	
         ;; 
esac

if ! [ -f s-sources ] ; then
    echo "Cannot unpack GCC sources"
    exit 1
fi

dir_name=`(cd gnu && ls -d gcc* | sed 1q; )`

short_version=`cat gnu/$dir_name/gcc/BASE-VER`
short_version_2=`echo $short_version | sed -e 's:\.::2g'`
short_version_3=`echo $short_version | sed -e 's:\.::g'`
datestamp=`cat gnu/$dir_name/gcc/DATESTAMP`
devphase=`cat gnu/$dir_name/gcc/DEV-PHASE`
version="$short_version $datestamp ($devphase)"

if ! [ -z "$devphase" ] ; then
    version_status="-$devphase"
fi

arcprefix=gcc$short_version_3
srcname=gcc-$short_version_2 

if ! [ -z "$version_status" ] ; then
    version_status="-${datestamp}-${devphase}"
fi 

dir_name0=$dir_name
case $dir_name in
    gcc-[3-9].[0-9]-*)
        ;;
    gcc-[3-9].[0-9])
        ;;
    gcc-[3-9].[0-9].[0-9]*)
        dir_name=`echo $dir_name | sed -e 's,\.,,2g'`
        ;;
    gcc-[3-9].[0-9]-[0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]|\
    gcc-[3-9].[0-9].[0-9]-[0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9])
        ;;
    gcc)
        dir_name=$srcname$version_status
        ;;
esac

if ! test "$dir_name" = "$dir_name0" ; then
    mv -f gnu/$dir_name0 gnu/$dir_name || exit 1
fi

if [ -d $top/gnu/$dir_name ] ; then
    gcc_dir=$top/gnu/$dir_name
else
    echo "Error: directory $top/gnu/$dir_name is not found"
    exit 1
fi

rm -rf manifest

#
#  Remove parts we don't need for DJGPP
#

rm -rf $gcc_dir/boehm-gc
rm -rf $gcc_dir/fastjar
rm -rf $gcc_dir/libffi
rm -rf $gcc_dir/libjava
rm -rf $gcc_dir/libchill
rm -rf $gcc_dir/zlib
#rm -rf $gcc_dir/libssp
rm -rf $gcc_dir/libgomp
rm -rf $gcc_dir/gcc/java
rm -rf $gcc_dir/gcc/testsuite
rm -rf $gcc_dir/gcc/treelang
rm -rf $gcc_dir/libmudflap

#
#  List of directories in which we should run autoconf or/and automake
#

automake_list=
aclocal_list=

#
#  Apply DJGPP related diffs and copy files 
#

patching_ok=true
for x in `(cd diffs/source && find . -type f | sed -e 's/\.\///g')`; do
    case $x in 
       *.diff | *.diff.in)
           cd $top
           diff=`pwd`/$x;
           fname=`echo $x | sed -e 's/\.diff//g'`
           echo "Applying patch to gcc/$fname ..."
           if [ -f $gcc_dir/$fname ] ; then
              cp -f $gcc_dir/$fname $gcc_dir/${fname}~1 
              if ! patch --verbose $gcc_dir/$fname <diffs/source/$x ; then
                  echo "Failed to apply patch for $gcc_dir/$fname"
		  patching_ok=false
              fi
              case $fname in 
                  */acinclude.m4)
                     dir=`echo $gcc_dir/$fname | sed -e 's/\/acinclude.m4//g'`
                      aclocal_list="$aclocal_list $dir"
                      ;;
                  */Makefile.am)
                      dir=`echo $gcc_dir/$fname | sed -e 's/\/Makefile.am//g'`
                      automake_list="$automake_list $dir"
                      ;;
              esac
           else
              echo "File $gcc_dir/$fname is not found"
           fi
           ;;
       readme.DJGPP)
           cat diffs/source/$x |\
           sed -e "s:@GCCVER@:$short_version:g" \
	       -e "s:@GCCVER2@:$short_version_2:g" \
	       -e "s:@GCCVER3@:$short_version_3:g" \
	       -e "s:@CONTACT@:$contact:g" \
	    	    >$gcc_dir/$x
	   ;;
       *~*)
           ;;
       *)
           echo Copying $x
	   mkdir -p `dirname $gcc_dir/$x`		   	
           if ! cp -fv diffs/source/$x $gcc_dir/$x ; then
              echo "Failed to copy diffs/source/$x to $gcc_dir/$x"
   	      patching_ok=false
           fi
           ;;
       esac
done

$patching_ok || exit 1

for dir in build.gcc install.gcc; do
    for x in `(cd diffs/$dir && find . -type f | sed -e 's/\.\///g')`; do
        mkdir -p `dirname gnu/$dir/$x`
	echo "Writting $dir/$x"
	cat diffs/$dir/$x |\
	sed -e "s:@SRCDIR@:$dir_name:g" -e "s:@GCCVER@:$short_version:g" >gnu/$dir/$x
    done
done

#
#  Run aclocal where needed
#
( cd $gcc_dir/libgfortran && aclocal -I .. -I ../config || exit 1)
( cd $gcc_dir/libstdc++-v3 && aclocal -I . -I .. -I ../config || exit 1)
( cd $gcc_dir/libssp && aclocal -I . -I .. -I ../config || exit 1)

#
#  Run automake where needed
#

for dir in $automake_list; do
   if cd $dir ; then
      echo "Directory $dir: must run automake ...";
      if ! [ -f configure.in ] ; then
         if ! [ -f configure.ac ] ; then
            cd ..;
            if ! [ -f configure.in ] ; then
               if ! [ -f configure.ac ] ; then
                  cd ..
               fi
            fi
         fi
      fi
      echo "Running automake..."
      if ! automake; then
         echo "automake failed in directory `pwd`"
         cd $top
         exit 1
      fi
   fi
   cd $top
done

( cd $gcc_dir/libada && aclocal -I ../config )

#
#  Run autoconf where needed
#

set -x
for c in `find $gcc_dir -name 'configure.in' -o -name 'configure.ac'`; do
   d=`dirname $c`
   n=`basename $c`
   if cd $d ; then
      AC_PREREQ=`grep 'AC_PREREQ(' $n | sed 's#.*(##' | sed 's#)##'`;

      case $AC_PREREQ in 
          *2.5*) echo Running autoconf-2.59 in `pwd` ...;
                if ! $AUTOCONF -I $gcc_dir/config; then 
                   echo "autoconf failed in directory `pwd`"
                   cd $top
                   exit 1
                fi
                ;;
          *)    echo Unknown autoconf version $AC_PREREQ required
                exit 1
                ;;
      esac 
   fi
   cd $top
done
set +x

#
#  Run autoheader where needed
#

if cd $gcc_dir/gcc ; then
   echo Running autoheader in `pwd` ...;
   if [ -f configure.ac ] ; then
      if ! $AUTOHEADER ; then
         echo "autoheader failed in directory `pwd`"
         cd $top
         exit 1
      fi
   elif ! $AUTOHEADER_OLD ; then
      echo "autoheader failed in directory `pwd`"
      cd $top
      exit 1
   fi
   rm -f cstamp-h.in
   echo timestamp >cstamp-h.in
fi

if [ -f $gcc_dir/contrib/gcc_update ] ; then
   echo Running contrib/gcc_update --touch
   cd $gcc_dir;
   ./contrib/gcc_update --touch
   cd $top
fi

for x in `find . -type d -a -name 'autom4te.cache'`; do
   rm -rf $x
done

cd $top

mkdir manifest
echo ${arcprefix}s${version_status}.zip - GCC $version source archive for DJGPP >$top/manifest/${arcprefix}s${version_status}.ver
touch $top/manifest/${arcprefix}s${version_status}.mft

( find gnu -type f \
          -and -not -name '.cvsignore' \
          -and -not -name '*~*' \
          -and -not -name '*.orig' \
          -and -not -name '.brik' ;
  find manifest -type f; ) |\
  grep -v 'autom4te\.cache' |\
  sort >$top/manifest/${arcprefix}s${version_status}.mft

cat $top/manifest/${arcprefix}s${version_status}.mft | zip -9q@ $top/${arcprefix}s${version_status}.zip
