#! @SHELL@
# autoreconf - remake all Autoconf configure scripts in a directory tree
# Copyright 1994, 1999, 2000 Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

me=`echo "$0" | sed -e 's,.*[\\/],,'`

usage="\
Usage: $0 [OPTION] ... [TEMPLATE-FILE]

Run \`autoconf' (and \`autoheader', \`aclocal' and \`automake', where
appropriate) repeatedly to remake the Autoconf \`configure' scripts
and configuration header templates in the directory tree rooted at the
current directory.  By default, it only remakes those files that are
older than their predecessors.  If you install a new version of
Autoconf, running \`autoreconf' remakes all of the files by giving it
the \`--force' option.

Operation modes:
  -h, --help      print this help, then exit
  -V, --version   print version number, then exit
  -v, --verbose   verbosely report processing
  -d, --debug     don't remove temporary files
  -f, --force     consider every files are obsolete
  -i, --install   copy missing auxiliary files
  -s, --symlink   instead of copying, install symbolic links

The option \`--install' is similar to the option \`--add-missing' in
other tools.

Library directories:
  -A, --autoconf-dir=ACDIR  Autoconf's macro files location (rarely needed)
  -l, --localdir=DIR        location of \`aclocal.m4' and \`acconfig.h'
  -M, --m4dir=M4DIR         this package's Autoconf extensions

Unless specified, heuristics try to compute \`M4DIR' from the \`Makefile.am',
or defaults to \`m4' if it exists.

The following options are passed to \`automake':
     --cygnus          assume program is part of Cygnus-style tree
     --foreign         set strictness to foreign
     --gnits           set strictness to gnits
     --gnu             set strictness to gnu
     --include-deps    include generated dependencies in Makefile.in

The environment variables AUTOCONF, AUTOHEADER, AUTOMAKE, and ACLOCAL
are honored.

Report bugs to <bug-autoconf@gnu.org>."

version="\
autoreconf (@PACKAGE_NAME@) @VERSION@
Written by David J. MacKenzie.

Copyright 1994, 1999, 2000 Free Software Foundation, Inc.
This is free software; see the source for copying conditions.  There is NO
warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE."

help="\
Try \`$me --help' for more information."

exit_missing_arg="\
echo \"$me: option \\\`\$1' requires an argument\" >&2
echo \"\$help\" >&2
exit 1"

# NLS nuisances.
# Only set these to C if already set.  These must not be set unconditionally
# because not all systems understand e.g. LANG=C (notably SCO).
# Fixing LC_MESSAGES prevents Solaris sh from translating var values in `set'!
# Non-C LC_CTYPE values break the ctype check.
if test "${LANG+set}"   = set; then LANG=C;   export LANG;   fi
if test "${LC_ALL+set}" = set; then LC_ALL=C; export LC_ALL; fi
if test "${LC_MESSAGES+set}" = set; then LC_MESSAGES=C; export LC_MESSAGES; fi
if test "${LC_CTYPE+set}"    = set; then LC_CTYPE=C;    export LC_CTYPE;    fi

# Variables.
: ${autoconf_dir=${AC_MACRODIR=@datadir@}}
debug=false
dir=`echo "$0" | sed -e 's,[^\\/]*$,,'`
force=false
# --install -- as --add-missing in other tools.
install=false
localdir=.
# m4dir -- local Autoconf extensions.  Typically `m4'.
m4dir=
status=0
# symlink -- when --install, use symlinks instead.
symlink=false
verbose=:

# Looking for autoconf.
# We test "$dir/autoconf" in case we are in the build tree, in which case
# the names are not transformed yet.
for autoconf in "$AUTOCONF" \
                "$dir/@autoconf-name@" \
                "$dir/autoconf" \
                "@bindir@/@autoconf-name@"; do
  test -f "$autoconf" && break
done

# Looking for autoheader.
for autoheader in "$AUTOHEADER" \
                  "$dir/@autoheader-name@" \
                  "$dir/autoheader" \
                  "@bindir@/@autoheader-name@"; do
  test -f "$autoheader" && break
done
# Looking for automake.
: ${automake=${AUTOMAKE=automake}}
# Looking for aclocal.
: ${aclocal=${ACLOCAL=aclocal}}

# Parse command line.
while test $# -gt 0; do
  optarg=`expr "x$1" : 'x--[^=]*=\(.*\)' \| \
               "x$1" : 'x-.\(.*\)'`
  case "$1" in
    --version | -V )
       echo "$version" ; exit 0 ;;
    --help | -h )
       echo "$usage"; exit 0 ;;

    --verbose | -v )
       verbose=echo
       shift;;
    --debug | -d )
       debug=:; shift ;;

    --localdir=* | -l?* )
       localdir=$optarg
       shift ;;
    --localdir | -l )
       test $# = 1 && eval "$exit_missing_arg"
       shift
       localdir=$1
       shift ;;

    --autoconf-dir=* | -A?* )
      autoconf_dir=$optarg
       shift ;;
    --autoconf-dir | -A )
       test $# = 1 && eval "$exit_missing_arg"
       shift
       autoconf_dir=$1
       shift ;;
    --macrodir=* | -m?* )
       echo "$me: warning: --macrodir is obsolete, use --autoconf-dir" >&2
       autoconf_dir=$optarg
       shift ;;
    --macrodir | -m )
       echo "$me: warning: --macrodir is obsolete, use --autoconf-dir" >&2
       test $# = 1 && eval "$exit_missing_arg"
       shift
       autoconf_dir=$1
       shift ;;

    --m4dir=* | -M?* )
       m4dir=$optarg
       shift ;;
    --m4dir | -M )
       test $# = 1 && eval "$exit_missing_arg"
       shift
       m4dir=$1
       shift ;;

     --force | -f )
       force=:; shift ;;

     --install | -i )
       install=:; shift ;;
     --symlink | -s )
       symlink=:; shift ;;

     # Options of Automake.
     --cygnus | --foreign | --gnits | --gnu | --include-deps | -i )
       automake="$automake $1"; shift ;;

     -- )     # Stop option processing.
       shift; break ;;
     -* )
       exec >&2
       echo "$me: invalid option $1"
       echo "$help"
       exit 1 ;;
     * )
       break ;;
  esac
done

# Find the input file.
if test $# -ne 0; then
  exec >&2
  echo "$me: invalid number of arguments"
  echo "$help"
  exit 1
fi

# If verbose, say what you are going to use.
if test $verbose = echo; then
  $autoconf --version |
    sed "s,.*)\(.*\)$,$me: using autoconf\1: $autoconf,;1q" >&2
  $autoheader --version |
    sed "s,.*)\(.*\)$,$me: using autoheader\1: $autoheader,;1q" >&2
  $automake --version |
    sed "s,.*)\(.*\)$,$me: using automake\1: $automake,;1q" >&2
  $aclocal --version |
    sed "s,.*)\(.*\)$,$me: using aclocal\1: $aclocal,;1q" >&2
fi

# Dispatch autoreconf's option to the tools.
# --localdir
autoconf="$autoconf -l $localdir"
autoheader="$autoheader -l $localdir"
# --force
$force || automake="$automake --no-force"
# --verbose
autoconf="$autoconf `$verbose --verbose`"
autoheader="$autoheader `$verbose --verbose`"
automake="$automake `$verbose --verbose`"
aclocal="$aclocal `$verbose --verbose`"
# --debug
$debug &&
{
  autoconf="$autoconf --debug"
  autoheader="$autoheader --debug"
}
# --macrodir
export autoconf_dir
# --install and --symlink
if $install; then
  automake="$automake --add-missing `$symlink || echo --copy`"
fi

# Trap on 0 to stop playing with `rm'.
$debug ||
{
  trap 'status=$?; rm -rf $tmp && exit $status' 0
  trap '(exit $?); exit' 1 2 13 15
}

# Create a (secure) tmp directory for tmp files.
: ${TMPDIR=/tmp}
{
  tmp=`(umask 077 && mktemp -d -q "$TMPDIR/arXXXXXX") 2>/dev/null` &&
  test -n "$tmp" && test -d "$tmp"
}  ||
{
  tmp=$TMPDIR/ar$$
  (umask 077 && mkdir $tmp)
} ||
{
   echo "$me: cannot create a temporary directory in $TMPDIR" >&2
   (exit 1); exit
}

# When debugging, it is convenient that all the related temporary
# files be at the same place.
TMPDIR=$tmp
export TMPDIR

# alflags.sed -- Fetch the aclocal flags.
cat >$tmp/alflags.sed <<EOF
#n
/^ACLOCAL_[A-Z_]*FLAGS/{
  s/.*=//
  p
  q
}
EOF

# update.sh --
# Exit 0 if the first argument is not the most recent of all or is missing.
cat >$tmp/update.sh <<\EOF
test -f "$1" || { :; exit; }
test x`ls -1dt "$@" 2>/dev/null | sed 1q` != x"$1"
EOF
update="@SHELL@ $tmp/update.sh"


# ----------------------- #
# Real work starts here.  #
# ----------------------- #

# Make a list of directories to process.
# The xargs grep filters out Cygnus configure.in files.
find . '(' -name configure.ac -o -name configure.in ')' -print |
xargs grep -l AC_INIT |
sed 's,/configure\.ac$,,;s,/configure\.in$,,;s,^./,,' |
while read dir; do
  (
  cd $dir || continue


  # ----------------- #
  # Running aclocal.  #
  # ----------------- #

  # uses_aclocal -- is this package using aclocal?
  uses_aclocal=false
  grep 'generated .* by aclocal' $localdir/aclocal.m4 >/dev/null 2>&1 &&
     uses_aclocal=:
  test -f "$localdir/aclocal.m4" ||
     uses_aclocal=:
  if $uses_aclocal &&
     { $force ||
       $update $localdir/aclocal.m4 $localdir/acinclude.m4; } then
     # If there are flags for aclocal in Makefile.am, use them.
     aclocal_flags=`sed -f $tmp/alflags.sed Makefile.am 2>/dev/null`

     # If m4dir no specified and these flags do not specify the
     # location of the local Autoconf extensions, default to `m4'.
     case $m4dir,$aclocal_flags in
       ,*"-I "* ) ;; # Not overriden and specified.
       ,*) # Not specified at all.
           test -d "m4" && aclocal_flags="$aclocal_flags -I m4";;
       * ) # Specified by the user.
           aclocal_flags="$aclocal_flags -I $m4dir";;
     esac

     $verbose $me: running $aclocal $aclocal_flags --output=$localdir/aclocal.m4 in $dir >&2
     $aclocal $aclocal_flags --output=$localdir/aclocal.m4
  fi


  # ------------------ #
  # Running automake.  #
  # ------------------ #

  # Assumes that there is a Makefile.am in the topmost directory.
  uses_automake=false
  test -f "Makefile.am" &&
    uses_automake=:
  # We should always run automake, and let it decide whether it shall
  # update the file or not.  In fact, the effect of `$force' is already
  # included in `$automake' via `--no-force'.
  if $uses_automake; then
    $verbose $me: running $automake in $dir >&2
    $automake
  fi


  # ------------------ #
  # Running autoconf.  #
  # ------------------ #

  if $force ||
     $update configure configure.ac $localdir/aclocal.m4 ||
     $update configure configure.in $localdir/aclocal.m4; then
    $verbose $me: running $autoconf in $dir >&2
    $autoconf
  fi


  # -------------------- #
  # Running autoheader.  #
  # -------------------- #

  # templates -- arguments of AC_CONFIG_HEADERS.
  $verbose $me: running $autoconf -t 'AC_CONFIG_HEADERS:$1' >&2
  templates=`$autoconf -t 'AC_CONFIG_HEADERS:$1'`
  if test -n "$templates"; then
    tcount=`set -- $templates; echo $#`
    # FIXME: This may need some patching for DOS paths
    template=`set -- $templates; echo $1 | sed '
        s/.*://
        t colon
        s/$/.in/
        : colon
        s/:.*//
      '`
    template_dir=`echo $template | sed -e 's,[\\/]*[^\\/]*$,,;s,^$,.,'`
    stamp_num=`test "$tcount" -gt 1 && echo "$tcount"`
    stamp=$template_dir/stamp-h$stamp_num.in
    # If config.hin exists, don't override it unless it was really
    # created by autoheader (users are allowed to write them by hand!).
    uses_autoheader=false
    grep autoheader "$template" >/dev/null 2>&1 &&
       uses_autoheader=:
    test -f "$template" ||
       uses_autoheader=:
    if $uses_autoheader &&
       { $force ||
         $update $template \
            configure.ac $localdir/aclocal.m4 $localdir/acconfig.h ||
         $update $template \
            configure.in $localdir/aclocal.m4 $localdir/acconfig.h ||
         $update $stamp    \
            configure.ac $localdir/aclocal.m4 $localdir/acconfig.h ||
         $update $stamp    \
            configure.in $localdir/aclocal.m4 $localdir/acconfig.h; } then
      $verbose $me: running $autoheader in $dir >&2
      $autoheader &&
      $verbose "touching $stamp" >&2 &&
      touch $stamp
    fi
  fi
  )
done

# Local Variables:
# mode: shell-script
# sh-indentation: 2
# End:
