.\" Copyright (c) 1993-1997  Paul Vojta
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a copy
.\" of this software and associated documentation files (the "Software"), to
.\" deal in the Software without restriction, including without limitation the
.\" rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
.\" sell copies of the Software, and to permit persons to whom the Software is
.\" furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included in
.\" all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" PAUL VOJTA BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
.\" IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
.\" CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
.\"
.TH GSFTOPK 1 "7 October 1997"
.SH NAME
gsftopk \- render a ghostscript font in TeX pk format
'	# small and boldface (not all -man's provide it)
.de SB
\&\fB\s-1\&\\$1 \\$2\s0\fR
..
.SH SYNOPSIS
.B gsftopk
[\-i \fIpath\fP]
[\-q]
#ifkpathsea
[\-\-debug=\fIn\fP]
#endif
[\-\-dosnames]
[\-\-interpreter=\fIpath\fP]
[\-\-mapline=\fIline\fP]
[\-\-mapfile=\fIfile\fP]
[\-\-quiet]
[\-\-help]
[\-\-version]
.I font
.I dpi
.SH ARGUMENTS
.IP \fIfont\fP \w'\fIfont\fP'u+2m
Name of the font to be created.
.IP \fIdpi\fP
Desired resolution of the font to be created, in dots per inch.  This may
be a real number.
.SH DESCRIPTION
.B gsftopk
is a program which calls up the ghostscript program
.BR gs (1)
to render a given font at a given resolution.  It packs the resulting
characters into the
.B pk
file format and writes them to a file whose name is formed from the font
name and the resolution (rounded to the nearest integer).  The font may
be in any format acceptable to Ghostscript, including
.RI . pfa ,
.RI . pfb ,
.RI . gsf ,
and
.RI . ttf
files.
.PP
This program should normally be called by a script, such as
.BR MakeTeXPK ,
to create fonts on demand.
.PP
.B gsftopk
obtains the character widths from the
.RI . tfm
file, which must exist in the standard search path.  It also must be
able to find a file
.B psfonts.map
(formatted as in
.BR dvips (1)),
listing the available fonts.
.PP
The following
.B pk
"specials" are added at the end of the output file, to provide an internal
check on the contents of the file:
"\fBjobname=\fP\fIfont\fP",
"\fBmag=1\fP",
"\fBmode=modeless\fP", and
"\fBpixels_per_inch=\fP\fIdpi\fP".
This is in accordance with the TeX Directory Standard (TDS).
.SH OPTIONS
#ifkpathsea
.TP
.B \-\-debug=\fIn\fP
Set the
.B kpathsea
debug flags according to the integer
.IR n .
#endif
.TP
.B \-\-dosnames
Use a name of the form
.IB font .pk
instead of
.IB font . dpi pk\fR.\fP
.TP
.B \-h\fR,\fP \-\-help
Print a brief help synopsis and exit.
.TP
.B \-i \fIpath\fP\fR,\fP \-\-interpreter=\fIpath\fP
Use
.I path
as the Ghostscript interpreter.
.TP
.B \-\-mapfile=\fIfile\fP
Use
.I file
to look for the map information for
.IR font .
Default is
.BR psfonts.map .
.TP
.B \-\-mapline=\fIline\fP
Use
.I line
instead of looking for an entry in the map file (normally
.BR psfonts.map ).
The first word of
.I line
must match
.IR font .
.TP
.B \-q\fR,\fP \-\-quiet
Operate quietly; i.e., without writing any messages to the standard output.
.TP
.B \-v\fR,\fP \-\-version
Print the version number and exit.
.SH ENVIRONMENT VARIABLES
.IP \fBTEXFONTS\fP \w'\fBDVIPSHEADERS\fP'u+2m
Colon-separated list of directories to search for the
.RI . tfm
file associated with the font.  An extra colon in the list will include the
system default path at that point.  A double slash will enable recursive
subdirectory searching at that point in the path.
.IP \fBDVIPSHEADERS\fP
Colon-separated list of directories to search for the ghostscript
driver file
.B render.ps
and for any PostScript font files
.RI (. pfa ,
.RI . pfb ,
.RI . gsf ,
or
.RI . ttf
files).  An extra colon in the list behaves as with
.SB TEXFONTS.
.IP \fBTEXCONFIG\fP
Path to search for the file
.BR psfonts.map .
Only the first such file will be used.
.SH BUGS
.B gsftopk
sometimes has trouble with fonts with very complicated characters
(such as the Seal of the University of California).  This is because
.B gsftopk
uses the
.B charpath
operator to determine the bounding box of each character.  If the character
is too complicated, then old versions of
.B ghostscript
fail, causing
.B gsftopk
to terminate with an error message
.IP
.B "Call to gs stopped by signal 10"
.LP
(The number may vary from system to system; it corresponds to a bus error
or a segmentation fault.)  The best way to fix this bug is to install a
current version of
.BR ghostscript .
As an alternative,
.B gsftopk
can be instructed to use the bounding box provided with the font (if one
exists) instead of finding a bounding box for each character.  To do this,
include the string
.IP
.B /usefontbbox true def
.LP
in the
.B psfonts.map
file;
.IR e.g. ,
.IP
.B ucseal """/usefontbbox true def"""
.LP
This will not affect use of the font by
.BR dvips .
.SH SEE ALSO
.BR gs (1),
.BR gftopk (1),
.BR tex (1),
.BR xdvi (1),
.BR dvips (1)
.SH AUTHOR
Written by Paul Vojta.  This program was inspired by
.BR gsrenderfont ,
which was written by Karl Berry.
#ifkpathsea
.SH MODIFICATIONS
Modified by Yves Arrouye to use Karl Berry's kpathsea library.
#endif
