# ===================================================================
# AWK Filter for conversion of Sherlok.log files to  HTML format
#
# Source are all lines from the input with given structure
#
#          GC|NrGC=nn|TimeStamp=nnn|Objects=nnn|Space=nnn|Total=nnn
# elem[n]   1       2             3           4         5         6              
#
# ------------------------------------------------------------------
#          Command| 35.196.419 | info any text to display
# info[]         1           2                      3
# ===================================================================


BEGIN {
    
    SHERLOK_SEPAR = "|";
    TITLE         = "Garbage Collection Statistics";
    BAR_COLOR = "Navy"; 
    BAR_WIDTH = "250px";
    

    print("<html><head>");
    print("<title>",TITLE,"</title>");
    
    print("<link rel=\"STYLESHEET\" type=\"text/css\" href=\"gcstyle.css\">");
    
    print("</head><body>");     

    print("<h2>", TITLE, "</h2>");

    print("<table>");
    print("<tr>");

      print("<th>");
      print("TimeStamp");
      print("</th>");    
    
      print("<th>");
      print("GC#");
      print("</th>");    

      print("<th>");
      print("Objects");
      print("</th>");    

      print("<th>");
      print("Memory Used (bytes)");
      print("</th>");    

      print("<th>");
      print("Total Space (bytes)");      
      print("</th>");    


      print("<th colspan=\"2\">");
      print("% Usage");      
      print("</th>");

    print("<tr>");

}


/^GC/ {

    split($0,elem,SHERLOK_SEPAR);

    x_timestamp = StripInput(elem[3]);
    x_gcnr      = StripInput(elem[2]);
    x_objects   = StripInput(elem[4]);
    x_memused   = StripInput(elem[5]);
    x_memtotal  = StripInput(elem[6]);
    x_pct       = int(x_memused/x_memtotal * 100);
    
    print("<tr class=\"gc\">");

      print("<td align=\"right\">");
      print(x_timestamp);
      print("</td>");    
    
      print("<td align=\"right\">");
      print(x_gcnr);
      print("</td>");    

      print("<td align=\"right\">");
      print(x_objects);
      print("</td>");    

      print("<td align=\"right\">");
      print(x_memused);
      print("</td>");    

      print("<td align=\"right\">");
      print(x_memtotal);      
      print("</td>");    

      printf("<td style=\"width:%s\">",BAR_WIDTH);
      printf("<div style=\"width:%s%%; background-color: %s; color : %s;\">|</div>",x_pct,BAR_COLOR,BAR_COLOR)
      print("</td>");    

      print("<td align=\"right\">");
      print(x_pct);      
      print("%</td>");    

    print("<tr>");    
       
}    
    
    
/^Command[0-9.| ]*info/ {

    split($0,info,SHERLOK_SEPAR);
    x_timestamp = info[2];
    x_info      = info[3]; 

    print("<tr class=\"info\">");

      print("<td align=\"right\">");
      print(x_timestamp);
      print("</td>");    
      print("<td align=\"right\">");
      print("---");
      print("</td>");        
    
      print("<td colspan=\"5\">");
      print(x_info);
      print("</td>");        

    print("<tr>");    

}    
    
    

END {
    print("</table>");
    
    print("</body>");     
    print("</html>");         
	
}



function StripInput(s){
  result = s;
  sub(/[^=]*=/,"",result); 
  return result;
}
