# ===================================================================
# AWK Filter for conversion of Sherlok.log files to  HTML format
#
# Source are all lines from the input with given structure
#          GC|NrGC=nn|TimeStamp=nnn|Objects=nnn|Space=nnn|Total=nnn
# elem[n]   1       2             3           4         5         6              
#
# ===================================================================


BEGIN {
    
    SHERLOK_SEPAR = "|";
    TITLE         = "Garbage Collection Statistics";

    print("<html><head>");
    print("<title>",TITLE,"</title>");
    print("</head><body>");     

    print("<h2>", TITLE, "</h2>");

    print("<table border=\"1\">");
    print("<tr>");
    
      print("<th>");
      print("GC Number");
      print("</th>");    

      print("<th>");
      print("TimeStamp");
      print("</th>");    

      print("<th>");
      print("Objects");
      print("</th>");    

      print("<th>");
      print("Memory Used (bytes)");
      print("</th>");    

      print("<th>");
      print("Total Space (bytes)");      
      print("</th>");    

    print("<tr>");

}


/^GC/ {

    split($0,elem,SHERLOK_SEPAR);
    
    
    print("<tr>");
    
      print("<td align=\"right\">");
      print(StripInput(elem[2]));
      print("</td>");    

      print("<td align=\"right\">");
      print(StripInput(elem[3]));
      print("</td>");    

      print("<td align=\"right\">");
      print(StripInput(elem[4]));
      print("</td>");    

      print("<td align=\"right\">");
      print(StripInput(elem[5]));
      print("</td>");    

      print("<td align=\"right\">");
      print(StripInput(elem[6]));      
      print("</td>");    

    print("<tr>");    
       
}    
    

END {
    print("</table>");
    
    print("</body>");     
    print("</html>");         
	
}



function StripInput(s){
  result = s;
  sub(/[^=]*=/,"",result); 
  return result;
}
