#!/bin/sh
#===========================================================================
# XCodeGen laucher script for Unix platform
#
# Author:   Herve Tchepannou
# Version:  $Revision: 1.1.1.1 $
#===========================================================================

#=====================================================================
# Resolve the jdk home directory
#=====================================================================

if [ ! -z "$JAVA_PATH" -a -z "$jdkhome" ] ; then
    jdkhome=$JAVA_PATH
fi

if [ ! -z "$JDK_HOME" -a -z "$jdkhome" ] ; then
    jdkhome=$JDK_HOME
fi

if [ -z "$jdkhome" ] ; then
    echo "Cannot find JDK. Please set the JDK_HOME environment variable to point"
    echo "to your JDK installation directory"
    echo ""
    exit 1
fi


#=====================================================================
# resolve symlinks and extract the xcodegen directory
#=====================================================================

PRG=$0

while [ -h "$PRG" ]; do
    ls=`ls -ld "$PRG"`
    link=`expr "$ls" : '^.*-> \(.*\)$' 2>/dev/null`
    if expr "$link" : '^/' 2> /dev/null >/dev/null; then
	    PRG="$link"
    else
	    PRG="`dirname $PRG`/$link"
    fi
done

progdir=`dirname $PRG`


#=====================================================================
# xcodegen classpath
#=====================================================================

xcp=$progdir/../build/lib/xcodegen.jar:\
$progdir/../lib/commons-collections.jar:\
$progdir/../lib/jdom.jar:\
$progdir/../lib/log4j.jar:\
$progdir/../lib/velocity.jar

echo "CLASSPATH=$xcp"


#=====================================================================
# run xcodegen
#=====================================================================

$jdkhome/bin/java -cp $xcp xcodegen.ui.swingui.MainFrame
