/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.sqlserver.tds;

import com.microsoft.jdbc.base.BaseCharacterStreamWrapper;
import com.microsoft.jdbc.base.BaseExceptions;
import com.microsoft.jdbc.base.BaseInputStreamWrapper;
import com.microsoft.jdbc.base.BaseParameter;
import com.microsoft.jdbc.sqlserver.tds.TDSConnection;
import com.microsoft.jdbc.sqlserver.tds.TDSDateTime;
import com.microsoft.util.UtilByteArray;
import com.microsoft.util.UtilByteOrderedDataWriter;
import com.microsoft.util.UtilDebug;
import com.microsoft.util.UtilException;
import com.microsoft.util.UtilTransliterator;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;

public class TDSRPCParameter {
    private static String footprint = "$Revision:   1.35  $";
    private int MAX_IMAGE_BYTES = Integer.MAX_VALUE;
    private int MAX_TEXT_BYTES = Integer.MAX_VALUE;
    private int MAX_NTEXT_BYTES = Integer.MAX_VALUE;
    private int MAX_NTEXT_CHARS = 0x3FFFFFFF;
    private BaseExceptions exceptions;
    private int tdsVersion;
    public String paramName;
    private byte tdsType;
    public String nativeTypeName;
    private boolean isInput;
    public boolean isOutput;
    private int maxLength;
    private int actualLength;
    private int precision;
    private int scale;
    public Object value;
    public int baseDataType;

    public TDSRPCParameter(int n, int n2, BaseExceptions baseExceptions) {
        this.tdsVersion = n;
        this.precision = n2;
        this.exceptions = baseExceptions;
    }

    public void initializeInternalParam(byte by, boolean bl, boolean bl2, int n, int n2, int n3, Object object) {
        this.tdsType = by;
        this.isInput = bl;
        this.isOutput = bl2;
        this.maxLength = n;
        this.actualLength = n2;
        this.scale = n3;
        this.value = object;
        this.nativeTypeName = null;
        this.paramName = null;
    }

    public void initializeUserParam(String string, BaseParameter baseParameter, BaseParameter baseParameter2, boolean bl) throws SQLException {
        this.isInput = baseParameter != null;
        this.isOutput = baseParameter2 != null;
        this.paramName = string;
        int n = this.isOutput ? baseParameter2.sqlType : baseParameter.sqlType;
        block0 : switch (n) {
            case -7: {
                if (this.isInput && baseParameter.data != null) {
                    baseParameter.data = new Boolean(baseParameter.getBoolean(this.exceptions));
                    baseParameter.type = 1009;
                    this.actualLength = 1;
                } else {
                    this.actualLength = 0;
                }
                this.nativeTypeName = "bit";
                this.maxLength = 1;
                this.tdsType = (byte)104;
                break;
            }
            case -6: {
                if (this.isInput && baseParameter.data != null) {
                    baseParameter.data = new Byte(baseParameter.getByte(this.exceptions));
                    baseParameter.type = 1001;
                    this.actualLength = 1;
                } else {
                    this.actualLength = 0;
                }
                this.nativeTypeName = "tinyint";
                this.maxLength = 1;
                this.tdsType = (byte)38;
                break;
            }
            case 5: {
                if (this.isInput && baseParameter.data != null) {
                    baseParameter.data = new Short(baseParameter.getShort(this.exceptions));
                    baseParameter.type = 1003;
                    this.actualLength = 2;
                } else {
                    this.actualLength = 0;
                }
                this.nativeTypeName = "smallint";
                this.maxLength = 2;
                this.tdsType = (byte)38;
                break;
            }
            case 4: {
                if (this.isInput && baseParameter.data != null) {
                    baseParameter.data = new Integer(baseParameter.getInteger(this.exceptions));
                    baseParameter.type = 1004;
                    this.actualLength = 4;
                } else {
                    this.actualLength = 0;
                }
                this.nativeTypeName = "int";
                this.maxLength = 4;
                this.tdsType = (byte)38;
                break;
            }
            case -5: {
                if (this.tdsVersion < 2) {
                    if (this.isInput && baseParameter.data != null) {
                        baseParameter.data = baseParameter.getString(-1, this.exceptions);
                        baseParameter.type = 1010;
                        this.actualLength = ((String)baseParameter.data).length();
                    } else {
                        this.actualLength = -1;
                    }
                    this.nativeTypeName = "varchar(8000)";
                    this.maxLength = 8000;
                    this.tdsType = (byte)-89;
                    break;
                }
                if (this.isInput && baseParameter.data != null) {
                    baseParameter.data = new Long(baseParameter.getLong(this.exceptions));
                    baseParameter.type = 1005;
                    this.actualLength = 8;
                } else {
                    this.actualLength = 0;
                }
                this.nativeTypeName = "bigint";
                this.tdsType = (byte)38;
                this.maxLength = 8;
                break;
            }
            case 7: {
                if (this.isInput && baseParameter.data != null) {
                    baseParameter.data = new Float(baseParameter.getFloat(this.exceptions));
                    baseParameter.type = 1006;
                    this.actualLength = 4;
                } else {
                    this.actualLength = 0;
                }
                this.nativeTypeName = "real";
                this.maxLength = 4;
                this.tdsType = (byte)109;
                break;
            }
            case 6: 
            case 8: {
                if (this.isInput && baseParameter.data != null) {
                    baseParameter.data = new Double(baseParameter.getDouble(this.exceptions));
                    baseParameter.type = 1007;
                    this.actualLength = 8;
                } else {
                    this.actualLength = 0;
                }
                this.nativeTypeName = "float";
                this.maxLength = 8;
                this.tdsType = (byte)109;
                break;
            }
            case 2: 
            case 3: {
                int n2 = 0;
                int n3 = 0;
                if (this.isInput && baseParameter.data != null) {
                    baseParameter.data = baseParameter.getBigDecimal(this.exceptions);
                    baseParameter.type = 1008;
                    n2 = ((BigDecimal)baseParameter.data).scale();
                    this.actualLength = 17;
                } else {
                    this.actualLength = 0;
                }
                n3 = this.isOutput ? baseParameter2.scale : 0;
                this.scale = Math.max(n2, n3);
                this.nativeTypeName = "decimal(" + this.precision + "," + this.scale + ")";
                this.maxLength = 17;
                this.tdsType = (byte)106;
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                if (this.isInput && baseParameter.data != null) {
                    switch (baseParameter.type) {
                        case 1015: {
                            this.actualLength = (int)((BaseInputStreamWrapper)baseParameter.data).length();
                            if (this.actualLength > 8000) {
                                this.nativeTypeName = "text";
                                this.maxLength = this.MAX_TEXT_BYTES;
                                this.tdsType = (byte)35;
                                break block0;
                            }
                            this.nativeTypeName = "varchar(8000)";
                            this.maxLength = 8000;
                            this.tdsType = (byte)-89;
                            break block0;
                        }
                        case 1018: {
                            this.actualLength = (int)((BaseCharacterStreamWrapper)baseParameter.data).length();
                            if (this.actualLength > 4000) {
                                this.nativeTypeName = "ntext";
                                this.maxLength = this.MAX_NTEXT_BYTES;
                                this.tdsType = (byte)99;
                                break block0;
                            }
                            this.nativeTypeName = "nvarchar(4000)";
                            this.maxLength = 4000;
                            this.tdsType = (byte)-25;
                            break block0;
                        }
                        case 1014: 
                        case 1016: 
                        case 1017: {
                            UtilDebug.assert((String)"Unexpected input stream.", (boolean)false);
                            break block0;
                        }
                    }
                    baseParameter.data = baseParameter.getString(-1, this.exceptions);
                    baseParameter.type = 1010;
                    this.actualLength = ((String)baseParameter.data).length();
                    if (bl) {
                        if (this.actualLength > 4000) {
                            this.nativeTypeName = "ntext";
                            this.maxLength = this.MAX_NTEXT_BYTES;
                            this.tdsType = (byte)99;
                            break;
                        }
                        this.nativeTypeName = "nvarchar(4000)";
                        this.maxLength = 4000;
                        this.tdsType = (byte)-25;
                        break;
                    }
                    if (this.actualLength > 8000) {
                        this.nativeTypeName = "text";
                        this.maxLength = this.MAX_TEXT_BYTES;
                        this.tdsType = (byte)35;
                        break;
                    }
                    this.nativeTypeName = "varchar(8000)";
                    this.maxLength = 8000;
                    this.tdsType = (byte)-89;
                    break;
                }
                if (bl) {
                    this.actualLength = -1;
                    this.nativeTypeName = "nvarchar(4000)";
                    this.maxLength = 4000;
                    this.tdsType = (byte)-25;
                    break;
                }
                this.actualLength = -1;
                this.nativeTypeName = "varchar(8000)";
                this.maxLength = 8000;
                this.tdsType = (byte)-89;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                if (this.isInput && baseParameter.data != null) {
                    switch (baseParameter.type) {
                        case 1014: 
                        case 1015: {
                            this.actualLength = (int)((BaseInputStreamWrapper)baseParameter.data).length();
                            if (this.actualLength > 8000) {
                                this.nativeTypeName = "image";
                                this.tdsType = (byte)34;
                                this.maxLength = this.MAX_IMAGE_BYTES;
                                break block0;
                            }
                            this.nativeTypeName = "varbinary(8000)";
                            this.tdsType = (byte)-91;
                            this.maxLength = 8000;
                            break block0;
                        }
                        case 1018: {
                            UtilDebug.assert((String)"Unexpected input stream.", (boolean)false);
                            break block0;
                        }
                        case 1016: 
                        case 1017: {
                            UtilDebug.assert((String)"Unexpected input stream.", (boolean)false);
                            break block0;
                        }
                    }
                    baseParameter.data = baseParameter.getBytes(-1, this.exceptions);
                    baseParameter.type = 1002;
                    this.actualLength = ((byte[])baseParameter.data).length;
                    if (this.actualLength > 8000) {
                        this.nativeTypeName = "image";
                        this.tdsType = (byte)34;
                        this.maxLength = this.MAX_IMAGE_BYTES;
                        break;
                    }
                    this.nativeTypeName = "varbinary(8000)";
                    this.tdsType = (byte)-91;
                    this.maxLength = 8000;
                    break;
                }
                this.actualLength = -1;
                this.nativeTypeName = "varbinary(8000)";
                this.tdsType = (byte)-91;
                this.maxLength = 8000;
                break;
            }
            case 2005: {
                baseParameter.data = baseParameter.getCharacterStreamReader(-1, null, this.exceptions);
                baseParameter.type = 1018;
                this.actualLength = (int)((BaseCharacterStreamWrapper)baseParameter.data).length();
                if (this.actualLength > 4000) {
                    this.nativeTypeName = "ntext";
                    this.maxLength = this.MAX_NTEXT_BYTES;
                    this.tdsType = (byte)99;
                    break;
                }
                this.nativeTypeName = "nvarchar(4000)";
                this.maxLength = 4000;
                this.tdsType = (byte)-25;
                break;
            }
            case 2004: {
                baseParameter.data = baseParameter.getBinaryStream(-1, null, this.exceptions);
                baseParameter.type = 1014;
                this.actualLength = ((byte[])baseParameter.data).length;
                if (this.actualLength > 8000) {
                    this.nativeTypeName = "image";
                    this.tdsType = (byte)34;
                    this.maxLength = this.MAX_IMAGE_BYTES;
                    break;
                }
                this.nativeTypeName = "varbinary(8000)";
                this.tdsType = (byte)-91;
                this.maxLength = 8000;
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                if (this.isInput && baseParameter.data != null) {
                    baseParameter.data = baseParameter.getTimestamp(this.exceptions);
                    baseParameter.type = 1013;
                    baseParameter.data = new TDSDateTime(this.exceptions, (Timestamp)baseParameter.data);
                    this.actualLength = 8;
                } else {
                    this.actualLength = 0;
                }
                this.nativeTypeName = "datetime";
                this.maxLength = 8;
                this.tdsType = (byte)111;
                break;
            }
            default: {
                throw this.exceptions.getException(6023);
            }
        }
        this.value = this.isInput ? baseParameter.data : null;
        if (this.isOutput) {
            this.nativeTypeName = String.valueOf(this.nativeTypeName) + " OUTPUT";
        }
    }

    public void write(TDSConnection tDSConnection, UtilByteOrderedDataWriter utilByteOrderedDataWriter) throws UtilException, SQLException {
        utilByteOrderedDataWriter.writeInt8(0);
        int n = 0;
        if (this.isOutput) {
            n |= 1;
        }
        utilByteOrderedDataWriter.writeInt8(n);
        utilByteOrderedDataWriter.writeInt8((int)this.tdsType);
        this.writeLength(tDSConnection, utilByteOrderedDataWriter, this.maxLength);
        if (this.tdsType == 106 || this.tdsType == 108) {
            utilByteOrderedDataWriter.writeInt8(this.precision);
            utilByteOrderedDataWriter.writeInt8(this.scale);
        }
        if (tDSConnection.getTDSVersion() == 2 && (this.tdsType == -81 || this.tdsType == -89 || this.tdsType == 35 || this.tdsType == -17 || this.tdsType == -25 || this.tdsType == 99)) {
            utilByteOrderedDataWriter.writeBytes(tDSConnection.getSQLCollation());
        }
        if (this.value != null) {
            switch (this.tdsType) {
                case 111: {
                    utilByteOrderedDataWriter.writeInt8(this.actualLength);
                    TDSDateTime tDSDateTime = (TDSDateTime)this.value;
                    utilByteOrderedDataWriter.writeInt32(tDSDateTime.numDaysSince_1_1_1900);
                    utilByteOrderedDataWriter.writeInt32(tDSDateTime.num300thSecondsSinceMidnight);
                    break;
                }
                case 99: {
                    if (this.value instanceof String) {
                        utilByteOrderedDataWriter.writeStringWithLength32((String)this.value);
                        break;
                    }
                    utilByteOrderedDataWriter.writeReaderWithLength32((Reader)this.value, (int)((BaseCharacterStreamWrapper)this.value).length());
                    break;
                }
                case 35: {
                    utilByteOrderedDataWriter.setTransliterator(tDSConnection.nonUnicodeTransliterator);
                    if (this.value instanceof String) {
                        utilByteOrderedDataWriter.writeStringWithLength32((String)this.value);
                    } else {
                        utilByteOrderedDataWriter.writeAsciiStreamWithLength32((InputStream)this.value, (int)((BaseInputStreamWrapper)this.value).length());
                    }
                    utilByteOrderedDataWriter.setTransliterator((UtilTransliterator)tDSConnection.unicodeTransliterator);
                    break;
                }
                case -25: {
                    if (this.value instanceof String) {
                        utilByteOrderedDataWriter.writeStringWithLength16((String)this.value);
                        break;
                    }
                    utilByteOrderedDataWriter.writeReaderWithLength16((Reader)this.value, (int)((BaseCharacterStreamWrapper)this.value).length());
                    break;
                }
                case -89: {
                    utilByteOrderedDataWriter.setTransliterator(tDSConnection.nonUnicodeTransliterator);
                    if (this.value instanceof String) {
                        utilByteOrderedDataWriter.writeStringWithLength16((String)this.value);
                    } else {
                        utilByteOrderedDataWriter.writeAsciiStreamWithLength16((InputStream)this.value, (int)((BaseInputStreamWrapper)this.value).length());
                    }
                    utilByteOrderedDataWriter.setTransliterator((UtilTransliterator)tDSConnection.unicodeTransliterator);
                    break;
                }
                case 104: {
                    utilByteOrderedDataWriter.writeInt8(1);
                    utilByteOrderedDataWriter.writeInt8((Boolean)this.value != false ? 1 : 0);
                    break;
                }
                case 48: {
                    utilByteOrderedDataWriter.writeInt8((int)((Byte)this.value).byteValue());
                    break;
                }
                case 52: {
                    utilByteOrderedDataWriter.writeInt16((int)((Short)this.value).shortValue());
                    break;
                }
                case 56: {
                    utilByteOrderedDataWriter.writeInt32(((Integer)this.value).intValue());
                    break;
                }
                case 127: {
                    utilByteOrderedDataWriter.writeInt64(((Long)this.value).longValue());
                    break;
                }
                case 38: {
                    utilByteOrderedDataWriter.writeInt8(this.actualLength);
                    if (this.actualLength == 1) {
                        utilByteOrderedDataWriter.writeInt8((int)((Byte)this.value).byteValue());
                        break;
                    }
                    if (this.actualLength == 2) {
                        utilByteOrderedDataWriter.writeInt16((int)((Short)this.value).shortValue());
                        break;
                    }
                    if (this.actualLength == 4) {
                        utilByteOrderedDataWriter.writeInt32(((Integer)this.value).intValue());
                        break;
                    }
                    if (this.actualLength == 8) {
                        utilByteOrderedDataWriter.writeInt64(((Long)this.value).longValue());
                        break;
                    }
                    UtilDebug.assert((String)"Unexpected TDS_INTN actualLength defined", (this.actualLength == 0 ? 1 : 0) != 0);
                    break;
                }
                case 34: {
                    if (this.value instanceof InputStream) {
                        utilByteOrderedDataWriter.writeStreamWithLength32((InputStream)this.value, (int)((BaseInputStreamWrapper)this.value).length());
                        break;
                    }
                    utilByteOrderedDataWriter.writeInt32(this.actualLength);
                    utilByteOrderedDataWriter.writeBytes((byte[])this.value);
                    break;
                }
                case -91: 
                case -83: {
                    if (this.value instanceof InputStream) {
                        utilByteOrderedDataWriter.writeStreamWithLength16((InputStream)this.value, (int)((BaseInputStreamWrapper)this.value).length());
                        break;
                    }
                    utilByteOrderedDataWriter.writeInt16(this.actualLength);
                    utilByteOrderedDataWriter.writeBytes((byte[])this.value);
                    break;
                }
                case 109: {
                    utilByteOrderedDataWriter.writeInt8(this.actualLength);
                    if (this.actualLength == 4) {
                        utilByteOrderedDataWriter.writeIEEE32BitFloat(((Float)this.value).floatValue());
                        break;
                    }
                    if (this.actualLength == 8) {
                        utilByteOrderedDataWriter.writeIEEE64BitDouble(((Double)this.value).doubleValue());
                        break;
                    }
                    UtilDebug.assert((String)"Unexpected TDS_FLTN actualLength defined", (boolean)false);
                    break;
                }
                case 62: {
                    utilByteOrderedDataWriter.writeIEEE64BitDouble(((Double)this.value).doubleValue());
                    break;
                }
                case 106: 
                case 108: {
                    utilByteOrderedDataWriter.writeInt8(this.actualLength);
                    utilByteOrderedDataWriter.writeInt8(((BigDecimal)this.value).signum() == -1 ? 0 : 1);
                    BigDecimal bigDecimal = ((BigDecimal)this.value).abs();
                    bigDecimal = bigDecimal.movePointRight(bigDecimal.scale());
                    byte[] byArray = bigDecimal.toBigInteger().toByteArray();
                    UtilByteArray.reverse((byte[])byArray);
                    byte[] byArray2 = UtilByteArray.allocate((int)16, (int)0);
                    System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                    utilByteOrderedDataWriter.writeBytes(byArray2);
                    break;
                }
                default: {
                    UtilDebug.assert((String)"Unexpected tdsType", (boolean)false);
                    break;
                }
            }
        } else {
            this.writeLength(tDSConnection, utilByteOrderedDataWriter, this.actualLength);
        }
    }

    private void writeLength(TDSConnection tDSConnection, UtilByteOrderedDataWriter utilByteOrderedDataWriter, int n) throws UtilException {
        switch (this.tdsType) {
            case 38: 
            case 104: 
            case 106: 
            case 108: 
            case 109: 
            case 111: {
                utilByteOrderedDataWriter.writeInt8(n);
                break;
            }
            case -25: {
                utilByteOrderedDataWriter.writeInt16(n);
                break;
            }
            case -91: 
            case -89: 
            case -83: {
                utilByteOrderedDataWriter.writeInt16(n);
                break;
            }
            case 99: {
                utilByteOrderedDataWriter.writeInt32(n);
                break;
            }
            case 34: 
            case 35: {
                utilByteOrderedDataWriter.writeInt32(n);
                break;
            }
            default: {
                UtilDebug.assert((String)"Unexpected tdsType", (boolean)false);
            }
            case 48: 
            case 50: 
            case 52: 
            case 56: 
            case 61: 
            case 62: 
            case 127: 
        }
    }
}

