/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseExceptions;
import com.microsoft.jdbc.base.BaseSQLNodeLocator;
import java.sql.SQLException;

public class BaseSQLTreeNode {
    private static final String footprint = "$Revision:   1.4  $";
    static final int NODE_ROOT = 1;
    static final int NODE_STATEMENT_ROOT = 2;
    static final int NODE_SELECT_STATEMENT = 3;
    static final int NODE_UNKNOWN_STATEMENT = 4;
    static final int NODE_PAREN_ROOT = 5;
    static final int NODE_FROM_CLAUSE = 6;
    static final int NODE_WHERE_CLAUSE = 7;
    static final int NODE_GROUPBY_CLAUSE = 8;
    static final int NODE_SETOP_ROOT = 9;
    static final int NODE_ORDERBY_CLAUSE = 10;
    static final int NODE_HAVING_CLAUSE = 11;
    static final int NODE_LIST_PART = 12;
    static final int NODE_STATEMENT_SEPARATOR = 13;
    static final int NODE_UNKNOWN = 14;
    static final int NODE_ESCAPE_ROOT = 15;
    static final int NODE_PARAMETER = 16;
    static final int NODE_COMMA = 17;
    static final int NODE_WHITESPACE = 18;
    static final int NODE_COMMENT = 19;
    static final int NODE_QUERY_EXP = 20;
    int type;
    String value;
    private BaseSQLTreeNode parent;
    private BaseSQLTreeNode rightSibling;
    private BaseSQLTreeNode leftMostChild;

    BaseSQLTreeNode(int n) {
        this.type = n;
    }

    BaseSQLTreeNode(int n, String string) {
        this.type = n;
        this.value = string;
    }

    public void addNextSibling(BaseSQLTreeNode baseSQLTreeNode) {
        if (this.rightSibling != null) {
            this.rightSibling.addNextSibling(baseSQLTreeNode);
            return;
        }
        this.rightSibling = baseSQLTreeNode;
        if (baseSQLTreeNode != null) {
            baseSQLTreeNode.parent = this.parent;
        }
    }

    private boolean existsInSubtree(BaseSQLTreeNode baseSQLTreeNode, BaseSQLTreeNode baseSQLTreeNode2, BaseExceptions baseExceptions) throws SQLException {
        if (baseSQLTreeNode == baseSQLTreeNode2) {
            return true;
        }
        BaseSQLNodeLocator baseSQLNodeLocator = new BaseSQLNodeLocator();
        return baseSQLNodeLocator.exists(baseSQLTreeNode, baseSQLTreeNode2, baseExceptions);
    }

    public BaseSQLTreeNode getParent() {
        return this.parent;
    }

    public BaseSQLTreeNode getPrevious() {
        BaseSQLTreeNode baseSQLTreeNode = null;
        if (this.parent != null) {
            BaseSQLTreeNode baseSQLTreeNode2 = this.parent.leftMostChild;
            while (baseSQLTreeNode2 != this) {
                baseSQLTreeNode = baseSQLTreeNode2;
                baseSQLTreeNode2 = baseSQLTreeNode2.rightSibling;
            }
            if (baseSQLTreeNode == null) {
                baseSQLTreeNode = this.parent;
            }
        }
        return baseSQLTreeNode;
    }

    public BaseSQLTreeNode getRightSibling() {
        return this.rightSibling;
    }

    public BaseSQLTreeNode leftMostChild() {
        return this.leftMostChild;
    }

    public void removeChildren() {
        if (this.leftMostChild != null) {
            BaseSQLTreeNode baseSQLTreeNode = this.leftMostChild;
            this.leftMostChild = null;
            while (baseSQLTreeNode != null) {
                baseSQLTreeNode.parent = null;
                baseSQLTreeNode = baseSQLTreeNode.rightSibling;
            }
        }
    }

    public void replaceRange(BaseSQLTreeNode baseSQLTreeNode, BaseSQLTreeNode baseSQLTreeNode2, BaseSQLTreeNode baseSQLTreeNode3, BaseExceptions baseExceptions) throws SQLException {
        BaseSQLTreeNode baseSQLTreeNode4;
        BaseSQLTreeNode baseSQLTreeNode5 = baseSQLTreeNode.getParent();
        if (baseSQLTreeNode5.leftMostChild == baseSQLTreeNode) {
            baseSQLTreeNode5.leftMostChild = baseSQLTreeNode3;
        } else {
            baseSQLTreeNode4 = baseSQLTreeNode5.leftMostChild;
            while (baseSQLTreeNode4.rightSibling != baseSQLTreeNode) {
                baseSQLTreeNode4 = baseSQLTreeNode4.rightSibling;
            }
            baseSQLTreeNode4.rightSibling = baseSQLTreeNode3;
        }
        baseSQLTreeNode4 = baseSQLTreeNode;
        while (!this.existsInSubtree(baseSQLTreeNode4, baseSQLTreeNode2, baseExceptions)) {
            baseSQLTreeNode4 = baseSQLTreeNode4.rightSibling;
        }
        baseSQLTreeNode3.rightSibling = baseSQLTreeNode4.rightSibling;
    }

    public void setNextChild(BaseSQLTreeNode baseSQLTreeNode) {
        if (baseSQLTreeNode != null) {
            baseSQLTreeNode.parent = this;
            if (this.leftMostChild == null) {
                this.leftMostChild = baseSQLTreeNode;
            } else {
                BaseSQLTreeNode baseSQLTreeNode2 = this.leftMostChild;
                while (baseSQLTreeNode2.rightSibling != null) {
                    baseSQLTreeNode2 = baseSQLTreeNode2.rightSibling;
                }
                baseSQLTreeNode2.rightSibling = baseSQLTreeNode;
            }
            while (baseSQLTreeNode.rightSibling != null) {
                baseSQLTreeNode.rightSibling.parent = this;
                baseSQLTreeNode = baseSQLTreeNode.rightSibling;
            }
        }
    }

    public void setParent(BaseSQLTreeNode baseSQLTreeNode) {
        this.parent = baseSQLTreeNode;
    }

    public void setRightSibling(BaseSQLTreeNode baseSQLTreeNode) {
        this.rightSibling = baseSQLTreeNode;
    }
}

