/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseCharacterStreamWrapper;
import com.microsoft.jdbc.base.BaseColumns;
import com.microsoft.jdbc.base.BaseConnection;
import com.microsoft.jdbc.base.BaseData;
import com.microsoft.jdbc.base.BaseExceptions;
import com.microsoft.jdbc.base.BaseImplResultSet;
import com.microsoft.jdbc.base.BaseImplResultSetNotificationSink;
import com.microsoft.jdbc.base.BaseInputStreamWrapper;
import com.microsoft.jdbc.base.BaseResultSetMetaData;
import com.microsoft.jdbc.base.BaseStatement;
import com.microsoft.jdbc.base.BaseWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;

public final class BaseResultSet
implements ResultSet,
BaseImplResultSetNotificationSink {
    private static String footprint = "$Revision:   1.57.1.1  $";
    private boolean closed = false;
    private BaseWarnings warnings;
    private BaseExceptions exceptions;
    private BaseStatement statement;
    private BaseConnection connection;
    boolean databaseMetaDataResultSet = false;
    private int resultSetType;
    private int resultSetConcurrency;
    private boolean lastGetWasNull;
    BaseColumns columns;
    private int rowsFetchSize;
    private int fetchDirection = 1002;
    BaseImplResultSet implResultSet;
    private int cursorPosition;
    private boolean onInsertRow;
    private boolean onDeletedRow;
    private int maxCursorPosition;
    private int lastColumnAccessed;
    private Vector streamsReturned;
    private int maxFieldSize = Integer.MAX_VALUE;

    public BaseResultSet(BaseStatement baseStatement, BaseColumns baseColumns, BaseImplResultSet baseImplResultSet) throws SQLException {
        this.exceptions = baseStatement.exceptions;
        this.statement = baseStatement;
        this.columns = baseColumns;
        this.warnings = new BaseWarnings(baseStatement.connection.driverName);
        this.implResultSet = baseImplResultSet;
        this.cursorPosition = 0;
        this.maxCursorPosition = baseStatement.maxRows > 0 ? baseStatement.maxRows : -1;
        this.rowsFetchSize = baseStatement.getFetchSize();
        this.resultSetType = baseImplResultSet.getScrollType();
        baseImplResultSet.setWarnings(this.warnings);
        baseImplResultSet.setNotificationSink(this);
        this.resultSetConcurrency = baseImplResultSet.getConcurrency();
        this.lastColumnAccessed = 0;
        this.fetchDirection = baseStatement.getFetchDirection();
        this.streamsReturned = new Vector();
        this.connection = baseStatement.connection;
        baseImplResultSet.postSetupInitialize();
    }

    public boolean absolute(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.cancelPendingUpdates();
            boolean bl = true;
            this.commonFetchInitialize();
            this.validateScrollable("ResultSet.absolute");
            if (n == 0) {
                throw this.exceptions.getException(6042, "HY107");
            }
            if (this.maxCursorPosition == 0) {
                bl = false;
            } else if (n > 0) {
                boolean bl2 = false;
                if (this.maxCursorPosition != -1 && n > this.maxCursorPosition) {
                    this.cursorPosition = this.maxCursorPosition + 1;
                    bl = false;
                }
                if (bl && !(bl = this.implResultSet.positionCursor(n)) && n > this.maxCursorPosition) {
                    this.cursorPosition = this.maxCursorPosition + 1;
                }
            } else {
                bl = this.last();
                if (bl) {
                    if ((n = this.maxCursorPosition + n + 1) < 1) {
                        bl = false;
                        this.cursorPosition = 0;
                    } else {
                        bl = this.implResultSet.positionCursor(n);
                    }
                }
            }
            if (bl) {
                this.cursorPosition = n;
            }
            boolean bl3 = bl;
            Object var4_6 = null;
            return bl3;
        }
    }

    public void afterLast() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.commonFetchInitialize();
            this.validateScrollable("ResultSet.afterLast");
            if (this.maxCursorPosition == -1) {
                while (this.next()) {
                }
            }
            this.cursorPosition = this.maxCursorPosition + 1;
        }
    }

    public void beforeFirst() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.commonFetchInitialize();
            this.validateScrollable("ResultSet.beforeFirst");
            this.cursorPosition = 0;
        }
    }

    public void cancelPendingUpdates() throws SQLException {
        if (this.resultSetConcurrency == 1008) {
            this.implResultSet.cancelUpdates();
            if (this.onInsertRow) {
                this.moveToCurrentRow();
            }
        }
    }

    public void cancelRowUpdates() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateUpdateable(-1);
            this.validateCursorPosition();
            this.implResultSet.cancelUpdates();
        }
    }

    public void clearWarnings() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.warnings.clear();
        }
    }

    public void close() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.closeStreams(false);
            this.closed = true;
            if (this.implResultSet != null) {
                this.implResultSet.close();
                this.implResultSet = null;
            }
            this.statement.resultSetClosed(this);
        }
    }

    private void closeStreams(boolean bl) {
        if (bl && this.implResultSet.getColumnAccess() != 1) {
            return;
        }
        int n = this.streamsReturned.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = this.streamsReturned.elementAt(n2);
            try {
                if (e instanceof InputStream) {
                    ((InputStream)e).close();
                } else {
                    ((Reader)e).close();
                }
            }
            catch (IOException iOException) {}
            ++n2;
        }
        if (n > 0) {
            this.streamsReturned = new Vector();
        }
    }

    private void commonFetchInitialize() throws SQLException {
        this.validateClosedState();
        this.clearWarnings();
        this.closeStreams(false);
        this.lastColumnAccessed = 0;
        this.onDeletedRow = false;
    }

    public void deleteRow() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateUpdateable(-1);
            this.validateClosedState();
            this.validateInsertRow();
            this.implResultSet.deleteRow();
        }
    }

    public void endOfResultSetReached(int n) {
        this.maxCursorPosition = n;
    }

    public int findColumn(String string) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            int n = this.columns.getOrdinal(string);
            if (n == 0) {
                throw this.exceptions.getException(6006, "42S22");
            }
            int n2 = n;
            Object var4_5 = null;
            return n2;
        }
    }

    public boolean first() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.cancelPendingUpdates();
            boolean bl = false;
            this.commonFetchInitialize();
            this.validateScrollable("ResultSet.first");
            bl = this.implResultSet.positionCursor(1);
            if (bl) {
                this.cursorPosition = 1;
            }
            boolean bl2 = bl;
            Object var3_4 = null;
            return bl2;
        }
    }

    public Array getArray(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            String[] stringArray = new String[]{"ResultSet.getArray"};
            throw this.connection.exceptions.getException(6004, stringArray);
        }
    }

    public Array getArray(String string) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            String[] stringArray = new String[]{"ResultSet.getArray"};
            throw this.connection.exceptions.getException(6004, stringArray);
        }
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateCursorPosition();
            this.closeStreams(true);
            this.validateColumnIndex(n, true);
            BaseData baseData = this.implResultSet.getData(n, 1015);
            InputStream inputStream = baseData.getASCIIStream(this.maxFieldSize, this.connection, this.exceptions);
            if (inputStream != null) {
                this.streamsReturned.addElement(inputStream);
                this.lastGetWasNull = false;
            } else {
                this.lastGetWasNull = true;
            }
            InputStream inputStream2 = inputStream;
            Object var4_6 = null;
            return inputStream2;
        }
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.getColumnOrdinal(string));
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateCursorPosition();
            this.closeStreams(true);
            this.validateColumnIndex(n, true);
            BaseData baseData = this.implResultSet.getData(n, 1008);
            this.lastGetWasNull = baseData.type == 1019;
            BigDecimal bigDecimal = baseData.getBigDecimal(this.exceptions);
            Object var4_5 = null;
            return bigDecimal;
        }
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateCursorPosition();
            this.closeStreams(true);
            this.validateColumnIndex(n, true);
            BaseData baseData = this.implResultSet.getData(n, 1008);
            this.lastGetWasNull = baseData.type == 1019;
            BigDecimal bigDecimal = baseData.getBigDecimal(n2, this.exceptions);
            Object var5_6 = null;
            return bigDecimal;
        }
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.getColumnOrdinal(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.getColumnOrdinal(string), n);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateCursorPosition();
            this.closeStreams(true);
            this.validateColumnIndex(n, true);
            BaseData baseData = this.implResultSet.getData(n, 1014);
            InputStream inputStream = baseData.getBinaryStream(this.maxFieldSize, this.connection, this.exceptions);
            if (inputStream != null) {
                this.streamsReturned.addElement(inputStream);
                this.lastGetWasNull = false;
            } else {
                this.lastGetWasNull = true;
            }
            InputStream inputStream2 = inputStream;
            Object var4_6 = null;
            return inputStream2;
        }
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.getColumnOrdinal(string));
    }

    public Blob getBlob(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateCursorPosition();
            this.closeStreams(true);
            this.validateColumnIndex(n, true);
            BaseData baseData = this.implResultSet.getData(n, 1020);
            this.lastGetWasNull = baseData.type == 1019;
            Blob blob = baseData.getBlob(this.connection, this.exceptions);
            Object var4_5 = null;
            return blob;
        }
    }

    public Blob getBlob(String string) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            Blob blob = this.getBlob(this.getColumnOrdinal(string));
            Object var4_4 = null;
            return blob;
        }
    }

    public boolean getBoolean(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateCursorPosition();
            this.closeStreams(true);
            this.validateColumnIndex(n, true);
            BaseData baseData = this.implResultSet.getData(n, 1009);
            this.lastGetWasNull = baseData.type == 1019;
            boolean bl = baseData.getBoolean(this.exceptions);
            Object var4_5 = null;
            return bl;
        }
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.getColumnOrdinal(string));
    }

    public byte getByte(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateCursorPosition();
            this.closeStreams(true);
            this.validateColumnIndex(n, true);
            BaseData baseData = this.implResultSet.getData(n, 1001);
            this.lastGetWasNull = baseData.type == 1019;
            byte by = baseData.getByte(this.exceptions);
            Object var4_5 = null;
            return by;
        }
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.getColumnOrdinal(string));
    }

    public byte[] getBytes(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateCursorPosition();
            this.closeStreams(true);
            this.validateColumnIndex(n, true);
            BaseData baseData = this.implResultSet.getData(n, 1002);
            this.lastGetWasNull = baseData.type == 1019;
            byte[] byArray = baseData.getBytes(this.maxFieldSize, this.columns.get(n).getTransliterator(), this.exceptions);
            Object var4_5 = null;
            return byArray;
        }
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.getColumnOrdinal(string));
    }

    public Reader getCharacterStream(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateCursorPosition();
            this.closeStreams(true);
            this.validateColumnIndex(n, true);
            BaseData baseData = this.implResultSet.getData(n, 1018);
            Reader reader = baseData.getCharacterStreamReader(this.maxFieldSize, this.connection, this.exceptions);
            if (reader != null) {
                this.lastGetWasNull = false;
                this.streamsReturned.addElement(reader);
            } else {
                this.lastGetWasNull = true;
            }
            Reader reader2 = reader;
            Object var4_6 = null;
            return reader2;
        }
    }

    public Reader getCharacterStream(String string) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            Reader reader = this.getCharacterStream(this.getColumnOrdinal(string));
            Object var4_4 = null;
            return reader;
        }
    }

    public Clob getClob(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateCursorPosition();
            this.closeStreams(true);
            this.validateColumnIndex(n, true);
            BaseData baseData = this.implResultSet.getData(n, 1021);
            this.lastGetWasNull = baseData.type == 1019;
            Clob clob = baseData.getClob(this.connection, this.exceptions);
            Object var4_5 = null;
            return clob;
        }
    }

    public Clob getClob(String string) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            Clob clob = this.getClob(this.getColumnOrdinal(string));
            Object var4_4 = null;
            return clob;
        }
    }

    int getColumnOrdinal(String string) throws SQLException {
        int n = this.columns.getOrdinal(string);
        if (n == 0) {
            String[] stringArray = new String[]{string};
            throw this.exceptions.getException(6006, stringArray, "42S22");
        }
        return n;
    }

    public int getConcurrency() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            int n = this.resultSetConcurrency;
            Object var3_3 = null;
            return n;
        }
    }

    public String getCursorName() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            String[] stringArray = new String[]{"ResultSet.getCursorName"};
            throw this.connection.exceptions.getException(6004, stringArray);
        }
    }

    public Date getDate(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateCursorPosition();
            this.closeStreams(true);
            this.validateColumnIndex(n, true);
            BaseData baseData = this.implResultSet.getData(n, 1011);
            this.lastGetWasNull = baseData.type == 1019;
            Date date = baseData.getDate(this.exceptions);
            Object var4_5 = null;
            return date;
        }
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateCursorPosition();
            this.closeStreams(true);
            this.validateColumnIndex(n, true);
            BaseData baseData = this.implResultSet.getData(n, 1011);
            this.lastGetWasNull = baseData.type == 1019;
            Date date = baseData.getDate(calendar, this.exceptions);
            Object var5_6 = null;
            return date;
        }
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.getColumnOrdinal(string));
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            Date date = this.getDate(this.getColumnOrdinal(string), calendar);
            Object var5_5 = null;
            return date;
        }
    }

    public double getDouble(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateCursorPosition();
            this.closeStreams(true);
            this.validateColumnIndex(n, true);
            BaseData baseData = this.implResultSet.getData(n, 1007);
            this.lastGetWasNull = baseData.type == 1019;
            double d = baseData.getDouble(this.exceptions);
            Object var5_5 = null;
            return d;
        }
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.getColumnOrdinal(string));
    }

    public int getFetchDirection() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            int n = this.fetchDirection;
            Object var3_3 = null;
            return n;
        }
    }

    public int getFetchSize() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            int n = this.rowsFetchSize;
            Object var3_3 = null;
            return n;
        }
    }

    public float getFloat(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateCursorPosition();
            this.closeStreams(true);
            this.validateColumnIndex(n, true);
            BaseData baseData = this.implResultSet.getData(n, 1006);
            this.lastGetWasNull = baseData.type == 1019;
            float f = baseData.getFloat(this.exceptions);
            Object var4_5 = null;
            return f;
        }
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.getColumnOrdinal(string));
    }

    public int getInt(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateCursorPosition();
            this.closeStreams(true);
            this.validateColumnIndex(n, true);
            BaseData baseData = this.implResultSet.getData(n, 1004);
            this.lastGetWasNull = baseData.type == 1019;
            int n2 = baseData.getInteger(this.exceptions);
            Object var4_5 = null;
            return n2;
        }
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.getColumnOrdinal(string));
    }

    public long getLong(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateCursorPosition();
            this.closeStreams(true);
            this.validateColumnIndex(n, true);
            BaseData baseData = this.implResultSet.getData(n, 1005);
            this.lastGetWasNull = baseData.type == 1019;
            long l = baseData.getLong(this.exceptions);
            Object var5_5 = null;
            return l;
        }
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.getColumnOrdinal(string));
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            BaseResultSetMetaData baseResultSetMetaData = new BaseResultSetMetaData(this, this.exceptions);
            Object var3_3 = null;
            return baseResultSetMetaData;
        }
    }

    public Object getObject(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateCursorPosition();
            this.closeStreams(true);
            this.validateColumnIndex(n, true);
            int n2 = BaseData.mapJDBCTypeToJavaObjectType(this.columns.get((int)n).type);
            BaseData baseData = this.implResultSet.getData(n, n2);
            boolean bl = this.lastGetWasNull = baseData.type == 1019;
            if (this.lastGetWasNull) {
                Object var2_5 = null;
                Object var4_7 = null;
                return var2_5;
            }
            Object object = baseData.getObject(n2, this.maxFieldSize, this.connection, this.exceptions);
            Object var4_8 = null;
            return object;
        }
    }

    public Object getObject(int n, Map map) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            Object object = this.getObject(n);
            Object var5_5 = null;
            return object;
        }
    }

    public Object getObject(String string) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            Object object = this.getObject(this.getColumnOrdinal(string));
            Object var4_4 = null;
            return object;
        }
    }

    public Object getObject(String string, Map map) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            Object object = this.getObject(string);
            Object var5_5 = null;
            return object;
        }
    }

    public Ref getRef(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            String[] stringArray = new String[]{"ResultSet.getRef"};
            throw this.connection.exceptions.getException(6004, stringArray);
        }
    }

    public Ref getRef(String string) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            String[] stringArray = new String[]{"ResultSet.getRef"};
            throw this.connection.exceptions.getException(6004, stringArray);
        }
    }

    public int getRow() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (this.cursorPosition == 0 || this.maxCursorPosition > -1 && this.cursorPosition > this.maxCursorPosition) {
                int n = 0;
                Object var3_4 = null;
                return n;
            }
            int n = this.cursorPosition;
            Object var3_5 = null;
            return n;
        }
    }

    public short getShort(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateCursorPosition();
            this.closeStreams(true);
            this.validateColumnIndex(n, true);
            BaseData baseData = this.implResultSet.getData(n, 1003);
            this.lastGetWasNull = baseData.type == 1019;
            short s = baseData.getShort(this.exceptions);
            Object var4_5 = null;
            return s;
        }
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.getColumnOrdinal(string));
    }

    public Statement getStatement() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (!this.databaseMetaDataResultSet) {
                BaseStatement baseStatement = this.statement;
                Object var3_4 = null;
                return baseStatement;
            }
            Statement statement = null;
            Object var3_5 = null;
            return statement;
        }
    }

    public String getString(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateCursorPosition();
            this.closeStreams(true);
            this.validateColumnIndex(n, true);
            BaseData baseData = this.implResultSet.getData(n, 1010);
            this.lastGetWasNull = baseData.type == 1019;
            String string = baseData.getString(this.maxFieldSize, this.exceptions);
            Object var4_5 = null;
            return string;
        }
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.getColumnOrdinal(string));
    }

    public Time getTime(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateCursorPosition();
            this.closeStreams(true);
            this.validateColumnIndex(n, true);
            BaseData baseData = this.implResultSet.getData(n, 1012);
            this.lastGetWasNull = baseData.type == 1019;
            Time time = baseData.getTime(this.exceptions);
            Object var4_5 = null;
            return time;
        }
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateCursorPosition();
            this.closeStreams(true);
            this.validateColumnIndex(n, true);
            BaseData baseData = this.implResultSet.getData(n, 1012);
            this.lastGetWasNull = baseData.type == 1019;
            Time time = baseData.getTime(calendar, this.exceptions);
            Object var5_6 = null;
            return time;
        }
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.getColumnOrdinal(string));
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            Time time = this.getTime(this.getColumnOrdinal(string), calendar);
            Object var5_5 = null;
            return time;
        }
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateCursorPosition();
            this.closeStreams(true);
            this.validateColumnIndex(n, true);
            BaseData baseData = this.implResultSet.getData(n, 1013);
            this.lastGetWasNull = baseData.type == 1019;
            Timestamp timestamp = baseData.getTimestamp(this.exceptions);
            Object var4_5 = null;
            return timestamp;
        }
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateCursorPosition();
            this.closeStreams(true);
            this.validateColumnIndex(n, true);
            BaseData baseData = this.implResultSet.getData(n, 1013);
            this.lastGetWasNull = baseData.type == 1019;
            Timestamp timestamp = baseData.getTimestamp(calendar, this.exceptions);
            Object var5_6 = null;
            return timestamp;
        }
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.getColumnOrdinal(string));
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            Timestamp timestamp = this.getTimestamp(this.getColumnOrdinal(string), calendar);
            Object var5_5 = null;
            return timestamp;
        }
    }

    public int getType() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            int n = this.resultSetType;
            Object var3_3 = null;
            return n;
        }
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            String[] stringArray = new String[]{"ResultSet.getUnicodeStream"};
            throw this.exceptions.getException(6004, stringArray);
        }
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.getColumnOrdinal(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            SQLWarning sQLWarning = this.warnings.get();
            Object var3_3 = null;
            return sQLWarning;
        }
    }

    public void insertRow() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateUpdateable(-1);
            if (!this.onInsertRow) {
                throw this.exceptions.getException(6062);
            }
            this.implResultSet.insertRow();
        }
    }

    public boolean isAfterLast() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateScrollable("ResultSet.isAfterLast");
            boolean bl = this.isAfterLastInternal();
            Object var3_3 = null;
            return bl;
        }
    }

    private boolean isAfterLastInternal() {
        return this.maxCursorPosition > 0 && this.cursorPosition > this.maxCursorPosition;
    }

    public boolean isBeforeFirst() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateScrollable("ResultSet.isBeforeFirst");
            boolean bl = this.isBeforeFirstInternal();
            Object var3_3 = null;
            return bl;
        }
    }

    private boolean isBeforeFirstInternal() {
        if (this.maxCursorPosition == 0) {
            return false;
        }
        return this.cursorPosition == 0;
    }

    public boolean isClosed() {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean bl = this.closed;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean isFirst() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateScrollable("ResultSet.isFirst");
            if (this.maxCursorPosition != 0 && this.cursorPosition == 1) {
                boolean bl = true;
                Object var3_4 = null;
                return bl;
            }
            boolean bl = false;
            Object var3_5 = null;
            return bl;
        }
    }

    public boolean isLast() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateScrollable("ResultSet.isLast");
            if (this.maxCursorPosition > 0 && this.cursorPosition == this.maxCursorPosition) {
                boolean bl = true;
                Object var3_4 = null;
                return bl;
            }
            boolean bl = false;
            Object var3_5 = null;
            return bl;
        }
    }

    public boolean last() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.cancelPendingUpdates();
            boolean bl = false;
            this.commonFetchInitialize();
            this.validateScrollable("ResultSet.last");
            this.afterLast();
            if (this.cursorPosition > 1 && (bl = this.implResultSet.positionCursor(this.maxCursorPosition))) {
                this.cursorPosition = this.maxCursorPosition;
            }
            boolean bl2 = bl;
            Object var3_4 = null;
            return bl2;
        }
    }

    public void moveToCurrentRow() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.onInsertRow = false;
            this.implResultSet.cancelInsertRow();
        }
    }

    public void moveToInsertRow() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.onInsertRow = true;
            this.implResultSet.prepareInsertRow();
        }
    }

    public boolean next() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.cancelPendingUpdates();
            boolean bl = true;
            this.commonFetchInitialize();
            if (this.maxCursorPosition == 0) {
                bl = false;
            } else if (this.maxCursorPosition > -1) {
                if (this.maxCursorPosition == this.cursorPosition) {
                    ++this.cursorPosition;
                    bl = false;
                } else if (this.maxCursorPosition < this.cursorPosition) {
                    bl = false;
                }
            }
            if (bl) {
                ++this.cursorPosition;
                bl = this.implResultSet.positionCursor(this.cursorPosition);
                if (!bl) {
                    this.maxCursorPosition = this.cursorPosition - 1;
                }
            }
            boolean bl2 = bl;
            Object var3_4 = null;
            return bl2;
        }
    }

    public void onDeletedRow() {
        this.onDeletedRow = true;
    }

    public boolean previous() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.cancelPendingUpdates();
            boolean bl = true;
            this.commonFetchInitialize();
            this.validateScrollable("ResultSet.previous");
            if (this.maxCursorPosition == 0) {
                bl = false;
            } else {
                if (this.cursorPosition > 0) {
                    --this.cursorPosition;
                }
                bl = this.cursorPosition == 0 ? false : this.implResultSet.positionCursor(this.cursorPosition);
            }
            boolean bl2 = bl;
            Object var3_4 = null;
            return bl2;
        }
    }

    public void refreshRow() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateInsertRow();
            this.validateScrollable("ResultSet.refreshRow");
            if (this.isBeforeFirstInternal() || this.isAfterLastInternal()) {
                throw this.exceptions.getException(6005);
            }
        }
    }

    public boolean relative(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.cancelPendingUpdates();
            boolean bl = true;
            this.commonFetchInitialize();
            this.validateScrollable("ResultSet.relative");
            if (this.maxCursorPosition == 0) {
                bl = false;
                throw this.exceptions.getException(6043, "HY109");
            }
            if (this.cursorPosition == 0 || this.maxCursorPosition > -1 && this.cursorPosition > this.maxCursorPosition) {
                throw this.exceptions.getException(6043, "HY109");
            }
            if (n == 0) {
                bl = true;
            } else {
                int n2 = this.cursorPosition + n;
                if (n2 == 0) {
                    this.cursorPosition = 0;
                    bl = false;
                } else {
                    bl = this.absolute(n2);
                }
            }
            boolean bl2 = bl;
            Object var4_6 = null;
            return bl2;
        }
    }

    public boolean rowDeleted() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean bl = this.onDeletedRow;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean rowInserted() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean bl = false;
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean rowUpdated() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            boolean bl = false;
            Object var3_3 = null;
            return bl;
        }
    }

    public void setFetchDirection(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateScrollable("ResultSet.setFetchDirection");
            this.fetchDirection = n;
        }
    }

    public void setFetchSize(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            if (n < 0 || this.statement.maxRows > 0 && n > this.statement.maxRows) {
                String[] stringArray = new String[]{"setFetchSize"};
                throw this.exceptions.getException(6003, stringArray);
            }
            this.rowsFetchSize = n;
            this.implResultSet.setFetchSize(n);
        }
    }

    void setMaxFieldSize(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.maxFieldSize = n == 0 ? Integer.MAX_VALUE : n;
        }
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateColumnIndex(n, false);
            this.validateUpdateable(n);
            this.validateCursorPosition();
            this.closeStreams(true);
            BaseData baseData = new BaseData(1015, new BaseInputStreamWrapper(inputStream, n2, this.connection, this.exceptions));
            this.implResultSet.updateData(n, baseData);
        }
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.getColumnOrdinal(string), inputStream, n);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateColumnIndex(n, false);
            this.validateUpdateable(n);
            this.validateCursorPosition();
            this.closeStreams(true);
            BaseData baseData = new BaseData(1008, bigDecimal);
            this.implResultSet.updateData(n, baseData);
        }
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.getColumnOrdinal(string), bigDecimal);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateColumnIndex(n, false);
            this.validateUpdateable(n);
            this.validateCursorPosition();
            this.closeStreams(true);
            BaseData baseData = new BaseData(1014, new BaseInputStreamWrapper(inputStream, n2, this.connection, this.exceptions));
            this.implResultSet.updateData(n, baseData);
        }
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.getColumnOrdinal(string), inputStream, n);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateColumnIndex(n, false);
            this.validateUpdateable(n);
            this.validateCursorPosition();
            this.closeStreams(true);
            BaseData baseData = new BaseData(1009, new Boolean(bl));
            this.implResultSet.updateData(n, baseData);
        }
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.getColumnOrdinal(string), bl);
    }

    public void updateByte(int n, byte by) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateColumnIndex(n, false);
            this.validateUpdateable(n);
            this.validateCursorPosition();
            this.closeStreams(true);
            BaseData baseData = new BaseData(1001, new Byte(by));
            this.implResultSet.updateData(n, baseData);
        }
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.getColumnOrdinal(string), by);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateColumnIndex(n, false);
            this.validateUpdateable(n);
            this.validateCursorPosition();
            this.closeStreams(true);
            BaseData baseData = new BaseData(1002, byArray);
            this.implResultSet.updateData(n, baseData);
        }
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.getColumnOrdinal(string), byArray);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateColumnIndex(n, false);
            this.validateUpdateable(n);
            this.validateCursorPosition();
            this.closeStreams(true);
            BaseData baseData = new BaseData(1018, new BaseCharacterStreamWrapper(reader, n2, this.connection, this.exceptions));
            this.implResultSet.updateData(n, baseData);
        }
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.getColumnOrdinal(string), reader, n);
    }

    public void updateDate(int n, Date date) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateColumnIndex(n, false);
            this.validateUpdateable(n);
            this.validateCursorPosition();
            this.closeStreams(true);
            BaseData baseData = new BaseData(1011, date);
            this.implResultSet.updateData(n, baseData);
        }
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.getColumnOrdinal(string), date);
    }

    public void updateDouble(int n, double d) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateColumnIndex(n, false);
            this.validateUpdateable(n);
            this.validateCursorPosition();
            this.closeStreams(true);
            BaseData baseData = new BaseData(1007, new Double(d));
            this.implResultSet.updateData(n, baseData);
        }
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.getColumnOrdinal(string), d);
    }

    public void updateFloat(int n, float f) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateColumnIndex(n, false);
            this.validateUpdateable(n);
            this.validateCursorPosition();
            this.closeStreams(true);
            BaseData baseData = new BaseData(1006, new Float(f));
            this.implResultSet.updateData(n, baseData);
        }
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.getColumnOrdinal(string), f);
    }

    public void updateInt(int n, int n2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateColumnIndex(n, false);
            this.validateUpdateable(n);
            this.validateCursorPosition();
            this.closeStreams(true);
            BaseData baseData = new BaseData(1004, new Integer(n2));
            this.implResultSet.updateData(n, baseData);
        }
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.getColumnOrdinal(string), n);
    }

    public void updateLong(int n, long l) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateColumnIndex(n, false);
            this.validateUpdateable(n);
            this.validateCursorPosition();
            this.closeStreams(true);
            BaseData baseData = new BaseData(1005, new Long(l));
            this.implResultSet.updateData(n, baseData);
        }
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.getColumnOrdinal(string), l);
    }

    public void updateNull(int n) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateColumnIndex(n, false);
            this.validateUpdateable(n);
            this.validateCursorPosition();
            this.closeStreams(true);
            BaseData baseData = new BaseData(1019, null);
            this.implResultSet.updateData(n, baseData);
        }
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.getColumnOrdinal(string));
    }

    public void updateObject(int n, Object object) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateColumnIndex(n, false);
            this.validateUpdateable(n);
            this.validateCursorPosition();
            this.closeStreams(true);
            BaseData baseData = new BaseData(object);
            this.implResultSet.updateData(n, baseData);
        }
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateColumnIndex(n, false);
            this.validateUpdateable(n);
            this.validateCursorPosition();
            this.closeStreams(true);
            BaseData baseData = new BaseData(object);
            BigDecimal bigDecimal = baseData.getBigDecimal(n2, this.exceptions);
            baseData.data = bigDecimal;
            baseData.type = 1008;
            this.implResultSet.updateData(n, baseData);
        }
    }

    public void updateObject(String string, Object object) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.updateObject(this.getColumnOrdinal(string), object);
        }
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.getColumnOrdinal(string), object, n);
    }

    public void updateRow() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateUpdateable(-1);
            this.validateCursorPosition();
            this.closeStreams(true);
            this.implResultSet.updateRow();
        }
    }

    public void updateShort(int n, short s) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateColumnIndex(n, false);
            this.validateUpdateable(n);
            this.validateCursorPosition();
            this.closeStreams(true);
            BaseData baseData = new BaseData(1003, new Short(s));
            this.implResultSet.updateData(n, baseData);
        }
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.getColumnOrdinal(string), s);
    }

    public void updateString(int n, String string) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateColumnIndex(n, false);
            this.validateUpdateable(n);
            this.validateCursorPosition();
            this.closeStreams(true);
            BaseData baseData = new BaseData(1010, string);
            this.implResultSet.updateData(n, baseData);
        }
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.getColumnOrdinal(string), string2);
    }

    public void updateTime(int n, Time time) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateColumnIndex(n, false);
            this.validateUpdateable(n);
            this.validateCursorPosition();
            this.closeStreams(true);
            BaseData baseData = new BaseData(1012, time);
            this.implResultSet.updateData(n, baseData);
        }
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.getColumnOrdinal(string), time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            this.validateColumnIndex(n, false);
            this.validateUpdateable(n);
            this.validateCursorPosition();
            this.closeStreams(true);
            BaseData baseData = new BaseData(1013, timestamp);
            this.implResultSet.updateData(n, baseData);
        }
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.getColumnOrdinal(string), timestamp);
    }

    void validateClosedState() throws SQLException {
        this.statement.validateClosedState();
        if (this.closed) {
            throw this.exceptions.getException(6010);
        }
    }

    void validateColumnIndex(int n, boolean bl) throws SQLException {
        if (!this.columns.isValidColumnOrdinal(n)) {
            Integer n2 = new Integer(n);
            String[] stringArray = new String[]{n2.toString()};
            throw this.exceptions.getException(6007, stringArray, "42S22");
        }
        if (bl && n <= this.lastColumnAccessed && this.implResultSet.getColumnAccess() == 1) {
            Integer n3 = new Integer(n);
            String[] stringArray = new String[]{n3.toString()};
            throw this.exceptions.getException(6008, stringArray, "HY010");
        }
        if (bl) {
            this.lastColumnAccessed = n;
        }
    }

    void validateCursorPosition() throws SQLException {
        if ((this.cursorPosition < 1 || this.maxCursorPosition > -1 && this.cursorPosition > this.maxCursorPosition) && !this.onInsertRow) {
            throw this.exceptions.getException(6005, "24000");
        }
        if (this.onDeletedRow && !this.onInsertRow) {
            throw this.exceptions.getException(6005, "24000");
        }
    }

    void validateInsertRow() throws SQLException {
        if (this.onInsertRow) {
            throw this.exceptions.getException(6059);
        }
    }

    void validateScrollable(String string) throws SQLException {
        if (this.resultSetType != 1004) {
            String[] stringArray = new String[]{string};
            throw this.connection.exceptions.getException(6004, stringArray);
        }
    }

    void validateUpdateable(int n) throws SQLException {
        if (this.resultSetConcurrency != 1008) {
            throw this.connection.exceptions.getException(6055);
        }
        if (n != -1 && !this.columns.get((int)n).isWritable) {
            throw this.connection.exceptions.getException(6056);
        }
    }

    public boolean wasNull() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            this.validateClosedState();
            boolean bl = this.lastGetWasNull;
            Object var3_3 = null;
            return bl;
        }
    }
}

