/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseClassUtility;
import com.microsoft.jdbc.base.BaseConnection;
import com.microsoft.jdbc.base.BaseConnectionProperties;
import com.microsoft.jdbc.base.BaseDatabaseMetaData;
import com.microsoft.jdbc.base.BaseExceptions;
import com.microsoft.jdbc.base.BaseMessages;
import com.microsoft.jdbc.base.BaseURLParser;
import com.microsoft.util.UtilDebug;
import com.microsoft.util.UtilDummyPrintWriter;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;

public abstract class BaseDriver
implements Driver {
    private static String footprint = "$Revision:   1.24  $";
    public UtilDebug debug;
    public BaseExceptions exceptions;

    public final boolean acceptsURL(String string) throws SQLException {
        this.setupExceptionHandling();
        BaseURLParser baseURLParser = new BaseURLParser();
        return baseURLParser.parse(BaseClassUtility.getRootName(this), string, false, null);
    }

    public final Connection connect(String string, Properties properties) throws SQLException {
        BaseConnectionProperties baseConnectionProperties = new BaseConnectionProperties();
        BaseURLParser baseURLParser = new BaseURLParser();
        BaseConnection baseConnection = BaseClassUtility.getConnection(this);
        baseConnectionProperties.putDefaults(baseConnection.getPropertyInfo());
        this.setupExceptionHandling();
        baseConnectionProperties.put("loginTimeout", String.valueOf(DriverManager.getLoginTimeout()));
        String string2 = BaseClassUtility.getRootName(this);
        if (baseURLParser.parse(string2, string, true, baseConnectionProperties)) {
            baseConnectionProperties.get("SpyAttributes");
            if (properties != null) {
                baseConnectionProperties.putUserSpecifed(properties);
            }
            try {
                this.debug = BaseDriver.setupDebugging(baseConnectionProperties);
                baseConnection.open(baseConnectionProperties, this.exceptions, this.debug);
            }
            catch (SQLException sQLException) {
                baseConnection = null;
                throw sQLException;
            }
        } else {
            if (baseURLParser.parse(string2, string, false, null)) {
                throw this.exceptions.getException(6031);
            }
            baseConnection = null;
        }
        return baseConnection;
    }

    protected static void dumpDriverInfo(BaseDriver baseDriver) {
        try {
            BaseMessages baseMessages = new BaseMessages(BaseClassUtility.getRootName(baseDriver));
            String[] stringArray = new String[]{new BaseDatabaseMetaData().getDriverVersion()};
            System.out.flush();
            System.out.println(baseMessages.getMessage(6017, stringArray, false));
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    public final int getMajorVersion() {
        return 2;
    }

    public final int getMinorVersion() {
        return 2;
    }

    public final DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        this.setupExceptionHandling();
        DriverPropertyInfo[] driverPropertyInfoArray = null;
        BaseURLParser baseURLParser = new BaseURLParser();
        if (baseURLParser.parse(BaseClassUtility.getRootName(this), string, false, null)) {
            BaseConnection baseConnection = BaseClassUtility.getConnection(this);
            driverPropertyInfoArray = baseConnection.getPropertyInfo().get();
        }
        return driverPropertyInfoArray;
    }

    public final boolean jdbcCompliant() {
        return true;
    }

    protected static void registerDriver(BaseDriver baseDriver) {
        try {
            DriverManager.registerDriver(baseDriver);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static UtilDebug setupDebugging(BaseConnectionProperties baseConnectionProperties) {
        UtilDebug utilDebug = new UtilDebug();
        try {
            String string = baseConnectionProperties.get("debug_to_standard_out");
            boolean bl = string != null && string.equalsIgnoreCase("true");
            if (false) {
                utilDebug.setPrintWriter(new PrintWriter(System.out, true));
            } else {
                utilDebug.setPrintWriter((PrintWriter)new UtilDummyPrintWriter());
            }
        }
        catch (Exception exception) {}
        return utilDebug;
    }

    private void setupExceptionHandling() throws SQLException {
        if (this.exceptions == null) {
            this.exceptions = new BaseExceptions(BaseClassUtility.getRootName(this));
        }
    }
}

