/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.cvslib;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tools.ant.taskdefs.cvslib.CVSEntry;

class ChangeLogParser {
    private static final int GET_FILE = 1;
    private static final int GET_DATE = 2;
    private static final int GET_COMMENT = 3;
    private static final int GET_REVISION = 4;
    private static final int GET_PREVIOUS_REV = 5;
    private static final SimpleDateFormat c_inputDate;
    private String m_file;
    private String m_date;
    private String m_author;
    private String m_comment;
    private String m_revision;
    private String m_previousRevision;
    private int m_status = 1;
    private final Hashtable m_entries = new Hashtable();

    ChangeLogParser() {
    }

    CVSEntry[] getEntrySetAsArray() {
        CVSEntry[] array = new CVSEntry[this.m_entries.size()];
        Enumeration enumeration = this.m_entries.elements();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            array[i++] = (CVSEntry)enumeration.nextElement();
        }
        return array;
    }

    public void stdout(String line) {
        switch (this.m_status) {
            case 1: {
                this.processFile(line);
                break;
            }
            case 4: {
                this.processRevision(line);
                break;
            }
            case 2: {
                this.processDate(line);
                break;
            }
            case 3: {
                this.processComment(line);
                break;
            }
            case 5: {
                this.processGetPreviousRevision(line);
            }
        }
    }

    private void processComment(String line) {
        String lineSeparator = System.getProperty("line.separator");
        if (line.startsWith("======")) {
            int end = this.m_comment.length() - lineSeparator.length();
            this.m_comment = this.m_comment.substring(0, end);
            this.saveEntry();
            this.m_status = 1;
        } else if (line.startsWith("----------------------------")) {
            int end = this.m_comment.length() - lineSeparator.length();
            this.m_comment = this.m_comment.substring(0, end);
            this.m_status = 5;
        } else {
            this.m_comment = this.m_comment + line + lineSeparator;
        }
    }

    private void processFile(String line) {
        if (line.startsWith("Working file:")) {
            this.m_file = line.substring(14, line.length());
            this.m_status = 4;
        }
    }

    private void processRevision(String line) {
        if (line.startsWith("revision")) {
            this.m_revision = line.substring(9);
            this.m_status = 2;
        } else if (line.startsWith("======")) {
            this.m_status = 1;
        }
    }

    private void processDate(String line) {
        if (line.startsWith("date:")) {
            this.m_date = line.substring(6, 25);
            String lineData = line.substring(line.indexOf(";") + 1);
            this.m_author = lineData.substring(10, lineData.indexOf(";"));
            this.m_status = 3;
            this.m_comment = "";
        }
    }

    private void processGetPreviousRevision(String line) {
        if (!line.startsWith("revision")) {
            throw new IllegalStateException("Unexpected line from CVS: " + line);
        }
        this.m_previousRevision = line.substring(9);
        this.saveEntry();
        this.m_revision = this.m_previousRevision;
        this.m_status = 2;
    }

    private void saveEntry() {
        CVSEntry entry;
        String entryKey = this.m_date + this.m_author + this.m_comment;
        if (!this.m_entries.containsKey(entryKey)) {
            entry = new CVSEntry(this.parseDate(this.m_date), this.m_author, this.m_comment);
            this.m_entries.put(entryKey, entry);
        } else {
            entry = (CVSEntry)this.m_entries.get(entryKey);
        }
        entry.addFile(this.m_file, this.m_revision, this.m_previousRevision);
    }

    private Date parseDate(String date) {
        try {
            return c_inputDate.parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    static {
        GET_FILE = 1;
        GET_DATE = 2;
        GET_COMMENT = 3;
        GET_REVISION = 4;
        GET_PREVIOUS_REV = 5;
        c_inputDate = new SimpleDateFormat("yyyy/MM/dd hh:mm:ss");
    }
}

