/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.filters;

import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import org.apache.tools.ant.filters.BaseParamFilterReader;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.types.Parameter;

public final class ReplaceTokens
extends BaseParamFilterReader
implements ChainableReader {
    private static final char DEFAULT_BEGIN_TOKEN = '@';
    private static final char DEFAULT_END_TOKEN = '@';
    private String queuedData = null;
    private Hashtable hash = new Hashtable();
    private char beginToken = (char)64;
    private char endToken = (char)64;

    public ReplaceTokens() {
    }

    public ReplaceTokens(Reader in) {
        super(in);
    }

    public final int read() throws IOException {
        if (!this.getInitialized()) {
            this.initialize();
            this.setInitialized(true);
        }
        if (this.queuedData != null && this.queuedData.length() > 0) {
            char ch = this.queuedData.charAt(0);
            this.queuedData = this.queuedData.length() > 1 ? this.queuedData.substring(1) : null;
            return ch;
        }
        int ch = this.in.read();
        if (ch == this.beginToken) {
            StringBuffer key = new StringBuffer("");
            while ((ch = this.in.read()) != -1) {
                key.append((char)ch);
                if (ch != this.endToken) continue;
            }
            if (ch == -1) {
                this.queuedData = this.beginToken + key.toString();
                return this.read();
            }
            key.setLength(key.length() - 1);
            String replaceWith = (String)this.hash.get(key.toString());
            if (replaceWith != null) {
                this.queuedData = replaceWith;
                return this.read();
            }
            this.queuedData = this.beginToken + key.toString() + this.endToken;
            return this.read();
        }
        return ch;
    }

    public final void setBeginToken(char beginToken) {
        this.beginToken = beginToken;
    }

    private final char getBeginToken() {
        return this.beginToken;
    }

    public final void setEndToken(char endToken) {
        this.endToken = endToken;
    }

    private final char getEndToken() {
        return this.endToken;
    }

    public final void addConfiguredToken(Token token) {
        this.hash.put(token.getKey(), token.getValue());
    }

    private void setTokens(Hashtable hash) {
        this.hash = hash;
    }

    private final Hashtable getTokens() {
        return this.hash;
    }

    public final Reader chain(Reader rdr) {
        ReplaceTokens newFilter = new ReplaceTokens(rdr);
        newFilter.setBeginToken(this.getBeginToken());
        newFilter.setEndToken(this.getEndToken());
        newFilter.setTokens(this.getTokens());
        newFilter.setInitialized(true);
        return newFilter;
    }

    private final void initialize() {
        Parameter[] params = this.getParameters();
        if (params != null) {
            int i = 0;
            while (i < params.length) {
                if (params[i] != null) {
                    String name;
                    String type = params[i].getType();
                    if ("tokenchar".equals(type)) {
                        name = params[i].getName();
                        if ("begintoken".equals(name)) {
                            this.beginToken = params[i].getValue().charAt(0);
                        } else if ("endtoken".equals(name)) {
                            this.endToken = params[i].getValue().charAt(0);
                        }
                    } else if ("token".equals(type)) {
                        name = params[i].getName();
                        String value = params[i].getValue();
                        this.hash.put(name, value);
                    }
                }
                ++i;
            }
        }
    }

    static {
        DEFAULT_BEGIN_TOKEN = (char)64;
        DEFAULT_END_TOKEN = (char)64;
    }

    public static class Token {
        private String key;
        private String value;

        public final void setKey(String key) {
            this.key = key;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final String getKey() {
            return this.key;
        }

        public final String getValue() {
            return this.value;
        }
    }
}

