/*
 * Generated by XCodeGen v1.0
 * Sun Jul 07 16:05:42 EDT 2002
 */

package xcodegen.sample.domain.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Types;
import xcodegen.sample.domain.dto.UserDTO;
    import xcodegen.sample.domain.dto.PersonDTO;
    import xcodegen.sample.domain.dao.PersonDAO;

/**
 * User of the system
 *
 * @author Herve Tchepannou
 * @version 
 *
 * @see UserDTO
 */
public class UserDAO
{
    /** INSERT SQL statement */
    public static final String SQL_INSERT = "INSERT INTO USER(password,_pk) VALUES(?,?)";
    
    /** SELECT SQL statement */
    public static final String SQL_SELECT = "SELECT PERSON.id,PERSON.firstname,PERSON.lastname,PERSON.email,USER.password FROM USER INNER JOIN PERSON ON USER._pk=PERSON.id";
    
    /** UPDATE SQL statement */
    public static final String SQL_UPDATE = "UPDATE USER SET password=?";
    
    /** Delete SQL Statement */
    public static final String SQL_DELETE = "DELETE FROM USER";

    /** Active connection */
    private Connection cnn;
    
    
////////////////////////////////////
// Constructors
////////////////////////////////////

    public UserDAO( Connection cnn )
    {
        if ( cnn == null )  throw new IllegalArgumentException( "cnn is null" );
        
        this.cnn = cnn;
    }
    

////////////////////////////////////
// Public methods
////////////////////////////////////
    
    /**
     * Persist a User into the database
     *
     * @param       User to persist
     * @return      value of the primary key of the object persisted
     * @throws      SQLException if any error occurs
     */
    public int create( UserDTO data ) throws SQLException
    {
        PreparedStatement stmt = null;
        try
        {

            // Create the super-object
            PersonDAO superdao = new PersonDAO ( cnn );
            superdao.create( data );

            // Create the object
            stmt = cnn.prepareStatement( SQL_INSERT, ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY );
            
                            
        stmt.setString( 1, data.getPassword() );
                                
        stmt.setInt( 2, data.getId() );
    
            stmt.executeUpdate();
            
            return data.getId();
        }
        finally
        {
            if ( stmt != null )
            {
                try{    stmt.close();   } catch( Exception e )  { e.printStackTrace(); }
            }
        }
    }

    /**
     * Persist modification on a User into the database
     *
     * @param       User to persist
     * @throws      SQLException if any error occurs
     */
    public void update( UserDTO data ) throws SQLException
    {


        // Update the super-object
        PersonDAO superdao = new PersonDAO ( cnn );
        superdao.update( data );
        // Update the object
        PreparedStatement stmt = null;
        try
        {
            stmt = cnn.prepareStatement( SQL_UPDATE + " WHERE _pk=?", ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY );

        
                                
        stmt.setString( 1, data.getPassword() );
                                        
        stmt.setInt( 2, data.getId() );
    
            stmt.executeUpdate();
        }
        finally
        {
            if ( stmt != null )
            {
                try{    stmt.close();   } catch( Exception e )  { e.printStackTrace(); }
            }
        }
    }


    /**
     * Remove a User from the database
     *
     * @param       pk  Primary key of the User to remove
     * @throws      SQLException if any error occurs
     */
    public void removeByPK( int pk ) throws SQLException
    {
        PreparedStatement stmt = null;
        try
        {

            // Remove the super-object
            PersonDAO superdao = new PersonDAO ( cnn );
            superdao.removeByPK( pk );
        }
        finally
        {
            if ( stmt != null )
            {
                try{    stmt.close();   } catch( Exception e )  { e.printStackTrace(); }
            }
        }
    }



    /**
     * Find a User by its primary key
     *
     * @param pk    primary key of the User requested
     * @return      User found, <code>null</code> if nothing found
     * @throws      SQLException if any error occurs
     */
    public UserDTO findByPK( int pk ) throws SQLException
    {
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try
        {
            String sql = SQL_SELECT + " WHERE USER._pk=?";
            stmt = cnn.prepareStatement( sql, ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY );
                
                                
        stmt.setInt( 1, pk );
    
            rs = stmt.executeQuery();
            return rs.next() ? newDataObject( rs ) : null;
        }
        finally
        {
            if ( rs != null )
            {
                try{    rs.close();   } catch( Exception e )  { e.printStackTrace(); }
            }
            if ( stmt != null )
            {
                try{    stmt.close();   } catch( Exception e )  { e.printStackTrace(); }
            }
        }
    }

                                
    /**
     * Find a user by its email and password
     *
         * @param email     
         * @return                User found, <code>null</code> if nothing found
     * @throws SQLException   if any error occurs
     */
    public UserDTO findByEmail ( String email ) throws SQLException
    {
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try
        {
            String sql = SQL_SELECT + " WHERE email=?";
            stmt = cnn.prepareStatement( sql, ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY );

    
                                
        stmt.setString( 1, email );
        
            rs = stmt.executeQuery();

            return rs.next() ? newDataObject( rs ) : null;
        }
        finally
        {
            if ( rs != null )
            {
                try{    rs.close();   } catch( Exception e )  { e.printStackTrace(); }
            }
            if ( stmt != null )
            {
                try{    stmt.close();   } catch( Exception e )  { e.printStackTrace(); }
            }
        }
    }
  

//////////////////////////////////////////////////
// Private methods
//////////////////////////////////////////////////

    private Collection filter( ResultSet rs, int offset, int maxcount ) throws SQLException
    {
        Collection col = new ArrayList();
        for( int i=0, count=0 ; rs.next() && ( maxcount > count ) ; i++ )
        {
            if ( i >= offset )
            {
                col.add( newDataObject( rs ) );
                count++;
            }
        }
        return col;
    }

    private UserDTO newDataObject( ResultSet rs ) throws SQLException
    {
        UserDTO data = new UserDTO();
        

                        data.setId( rs.getInt( 1 ) );

                        data.setFirstname( rs.getString( 2 ) );

                        data.setLastname( rs.getString( 3 ) );

                        data.setEmail( rs.getString( 4 ) );

                        data.setPassword( rs.getString( 5 ) );

        return data;
    }
}
