/* Module:          SQLDisconnect.c
 *
 * Description:     Closes the connection associated with a specific connection handle.
 *
 * Classes:         
 *
 * API functions:   SQLDisconnect
 *
 * Comments:        See "notice.txt" for copyright and license information.
 *
 */

#include "driver.h"

SQLRETURN SQL_API SQLDisconnect(SQLHDBC	hDrvDbc)
{
	ConnectionClass *conn = (ConnectionClass *) hDrvDbc;
	static char *func = "SQLDisconnect";
	
	mylog( "%s: entering...\n", func);

	if ( ! conn)
	{
		CC_log_error(func, "", NULL);
		return SQL_INVALID_HANDLE;
	}

	qlog("conn=%u, %s\n", conn, func);

	if (conn->status == CONN_EXECUTING)
	{
		conn->errornumber = CONN_IN_USE;
		conn->errormsg = "A transaction is currently being executed";
		CC_log_error(func, "", conn);
		return SQL_ERROR;
	}

	mylog("%s: about to CC_cleanup\n", func);

	/*  Close the connection and free statements */
	CC_cleanup(conn);

	mylog("%s: done CC_cleanup\n", func);
	mylog("%s: returning...\n", func);

	return SQL_SUCCESS;
}

