/* $PostgresPy: if/src/rel.c,v 1.17 2004/07/10 15:52:48 flaw Exp $
 *
 * † Instrument:
 *     Copyright 2004, rhid development. All Rights Reserved.
 *     
 *     Usage of the works is permitted provided that this
 *     instrument is retained with the works, so that any entity
 *     that uses the works is notified of this instrument.
 *     
 *     DISCLAIMER: THE WORKS ARE WITHOUT WARRANTY.
 *     
 *     [2004, Fair License; rhid.com/fair]
 *     
 * Description:
 *    The Relation Python type implementation.
 */
#include <pputils.h>

#include <postgres.h>
#include <access/heapam.h>
#include <catalog/pg_type.h>
#include <utils/palloc.h>
#include <utils/relcache.h>
#include <pg.h>
#include <PGExcept.h>

#include <Python.h>
#include <structmember.h>
#include <py.h>

#include "datum.h"
#include "tupd.h"
#include "tup.h"
#include "obj.h"
#include "rel.h"

const char PyPgRelation_Doc[] = "Python Interface to the PostgreSQL Datum.";

static int
rel_length(PgRel self)
{
	return(0);
}

static PyObj
rel_concat(PgRel self, PyObj with)
{
	RETURN_NONE;
}

static PyObj
rel_repeat(PgRel self, int item)
{
	RETURN_NONE;
}

static PyObj
rel_item(PgRel self, int item)
{
	RETURN_NONE;
}

static PyObj
rel_slice(PgRel self, int fitem, int titem)
{
	RETURN_NONE;
}

static PyObj
rel_ass_item(PgRel self, int item, PyObj as)
{
	RETURN_NONE;
}

static PyObj
rel_ass_slice(PgRel self, int from, int toi, PyObj as)
{
	RETURN_NONE;
}

static PyObj
rel_contains(PgRel self, PyObj ob)
{
	RETURN_NONE;
}

static PyObj
rel_inplace_concat(PgRel self, PyObj with)
{
	RETURN_NONE;
}

static PyObj
rel_inplace_repeat(PgRel self, int num)
{
	RETURN_NONE;
}

static PySequenceMethods PyPgRelationAsSequence = {
	(inquiry)rel_length,					/* sq_length */
	(binaryfunc)rel_concat,				/* sq_concat */
	(intargfunc)rel_repeat,				/* sq_repeat */
	(intargfunc)rel_item,				/* sq_item */
	(intintargfunc)rel_slice,			/* sq_slice */
	(intobjargproc)rel_ass_item,		/* sq_ass_item */
	(intintobjargproc)rel_ass_slice,	/* sq_ass_slice */
	(objobjproc)rel_contains,			/* sq_contains */
	(binaryfunc)rel_inplace_concat,	/* sq_inplace_concat */
	(intargfunc)rel_inplace_repeat,	/* sq_inplace_repeat */
};

static PyObj
rel_subscript(PgRel self, PyObj sub)
{
	RETURN_NONE;
}

static PyObj
rel_ass_subscript(PgRel self, PyObj sub, PyObj to)
{
	RETURN_NONE;
}

static PyMappingMethods PyPgRelationAsMapping = {
	(inquiry)rel_length,						/* mp_length */
	(binaryfunc)rel_subscript,				/* mp_subscript */
	(objobjargproc)rel_ass_subscript,	/* mp_ass_subscript */
};

static PyObj
rel_add(PgRel self, PyObj with)
{
	RETURN_NONE;
}

static PyObj
rel_subtract(PgRel self, PyObj with)
{
	RETURN_NONE;
}

static PyObj
rel_multiply(PgRel self, PyObj with)
{
	RETURN_NONE;
}

static PyObj
rel_divide(PgRel self, PyObj with)
{
	RETURN_NONE;
}

static PyObj
rel_remainder(PgRel self, PyObj with)
{
	RETURN_NONE;
}

static PyObj
rel_divmod(PgRel self, PyObj with)
{
	RETURN_NONE;
}

static PyObj
rel_power(PgRel self, PyObj with, PyObj andthis)
{
	RETURN_NONE;
}

static PyObj
rel_negative(PgRel self)
{
	RETURN_NONE;
}

static PyObj
rel_positive(PgRel self)
{
	RETURN_NONE;
}

static PyObj
rel_absolute(PgRel self)
{
	RETURN_NONE;
}

static int
rel_nonzero(PgRel self)
{
	return(-1);
}

static PyObj
rel_invert(PgRel self)
{
	RETURN_NONE;
}

static PyObj
rel_lshift(PgRel self, PyObj with)
{
	RETURN_NONE;
}

static PyObj
rel_rshift(PgRel self, PyObj with)
{
	RETURN_NONE;
}

static PyObj
rel_and(PgRel self, PyObj with)
{
	RETURN_NONE;
}

static PyObj
rel_xor(PgRel self, PyObj with)
{
	RETURN_NONE;
}

static PyObj
rel_or(PgRel self, PyObj with)
{
	RETURN_NONE;
}

static int
rel_coerce(PgRel self, PyObj with)
{
	return(-1);
}

static PyObj
rel_int(PgRel self)
{
	RETURN_NONE;
}

static PyObj
rel_long(PgRel self)
{
	RETURN_NONE;
}

static PyObj
rel_float(PgRel self)
{
	RETURN_NONE;
}

static PyObj
rel_oct(PgRel self)
{
	RETURN_NONE;
}

static PyObj
rel_hex(PgRel self)
{
	RETURN_NONE;
}

static PyObj
rel_inplace_add(PgRel self, PyObj ob)
{
	RETURN_NONE;
}

static PyObj
rel_inplace_subtract(PgRel self, PyObj ob)
{
	RETURN_NONE;
}

static PyObj
rel_inplace_multiply(PgRel self, PyObj ob)
{
	RETURN_NONE;
}

static PyObj
rel_inplace_divide(PgRel self, PyObj ob)
{
	RETURN_NONE;
}

static PyObj
rel_inplace_remainder(PgRel self, PyObj ob)
{
	RETURN_NONE;
}

static PyObj
rel_inplace_power(PgRel self, PyObj ob, PyObj ex)
{
	RETURN_NONE;
}

static PyObj
rel_inplace_lshift(PgRel self, PyObj ob)
{
	RETURN_NONE;
}

static PyObj
rel_inplace_rshift(PgRel self, PyObj ob)
{
	RETURN_NONE;
}

static PyObj
rel_inplace_and(PgRel self, PyObj ob)
{
	RETURN_NONE;
}

static PyObj
rel_inplace_xor(PgRel self, PyObj ob)
{
	RETURN_NONE;
}

static PyObj
rel_inplace_or(PgRel self, PyObj ob)
{
	RETURN_NONE;
}

static PyObj
rel_floor_divide(PgRel self, PyObj ob)
{
	RETURN_NONE;
}

static PyObj
rel_true_divide(PgRel self, PyObj ob)
{
	RETURN_NONE;
}

static PyObj
rel_inplace_floor_divide(PgRel self, PyObj ob)
{
	RETURN_NONE;
}

static PyObj
rel_inplace_true_divide(PgRel self, PyObj ob)
{
	RETURN_NONE;
}

static PyNumberMethods PyPgRelationAsNumber = {
	(binaryfunc)rel_add,						/* nb_add */
	(binaryfunc)rel_subtract,				/* nb_subtract */
	(binaryfunc)rel_multiply,				/* nb_multiply */
	(binaryfunc)rel_divide,					/* nb_divide */
	(binaryfunc)rel_remainder,				/* nb_remainder */
	(binaryfunc)rel_divmod,					/* nb_divmod */
	(ternaryfunc)rel_power,					/* nb_power */
	(unaryfunc)rel_negative,				/* nb_negative */
	(unaryfunc)rel_positive,				/* nb_positive */
	(unaryfunc)rel_absolute,				/* nb_absolute */
	(inquiry)rel_nonzero,					/* nb_nonzero */
	(unaryfunc)rel_invert,					/* nb_invert */
	(binaryfunc)rel_lshift,					/* nb_lshift */
	(binaryfunc)rel_rshift,					/* nb_rshift */
	(binaryfunc)rel_and,						/* nb_and */
	(binaryfunc)rel_xor,						/* nb_xor */
	(binaryfunc)rel_or,						/* nb_or */
	(coercion)rel_coerce,					/* nb_coerce */
	(unaryfunc)rel_int,						/* nb_int */
	(unaryfunc)rel_long,						/* nb_long */
	(unaryfunc)rel_float,					/* nb_float */
	(unaryfunc)rel_oct,						/* nb_oct */
	(unaryfunc)rel_hex,						/* nb_hex */

	(binaryfunc)rel_inplace_add,			/* nb_inplace_add */
	(binaryfunc)rel_inplace_subtract,	/* nb_inplace_subtract */
	(binaryfunc)rel_inplace_multiply,	/* nb_inplace_multiply */
	(binaryfunc)rel_inplace_divide,		/* nb_inplace_divide */
	(binaryfunc)rel_inplace_remainder,	/* nb_inplace_remainder */
	(ternaryfunc)rel_inplace_power,		/* nb_inplace_power */
	(binaryfunc)rel_inplace_lshift,		/* nb_inplace_lshift */
	(binaryfunc)rel_inplace_rshift,		/* nb_inplace_rshift */
	(binaryfunc)rel_inplace_and,			/* nb_inplace_and */
	(binaryfunc)rel_inplace_xor,			/* nb_inplace_xor */
	(binaryfunc)rel_inplace_or,			/* nb_inplace_or */

	(binaryfunc)rel_floor_divide,			/* nb_floor_divide */
	(binaryfunc)rel_true_divide,			/* nb_true_divide */
	(binaryfunc)rel_inplace_floor_divide,/* nb_inplace_floor_divide */
	(binaryfunc)rel_inplace_true_divide,/* nb_inplace_true_divide */
};

static PyMethodDef PyPgRelation_Methods[] = {
	//{"name", FunctionRef, flags, "docstring"},
	{NULL}
};

static void
rel_dealloc(PgRel self)
{
	RelationClose(PgRel_FetchRelation(self));
	PyObject_Del((PyObj)self);
}

static PyObj
rel_getattr(PgRel self, char *attr)
{
	RETURN_NONE;
}

static int
rel_setattr(PgRel self, char *attr, PyObj ob)
{
	return(-1);
}

static int
rel_compare(PgRel self, PyObj *with)
{
	return(-1);
}

static PyObj
rel_call(PgRel self, PyObj args, PyObj kw)
{
	RETURN_NONE;
}

static PyObj
rel_str(PgRel self)
{
	RETURN_NONE;
}

static PyObj
rel_iter(PgRel self)
{
	RETURN_NONE;
}

static int
rel_clear(PgRel self)
{
	return(-1);
}

static int
rel_richcmp(PgRel self, PyObj ob)
{
	return(-1);
}

static int
rel_init(PgRel self, PyObj args, PyObj kw)
{
	return(-1);
}

PyTypeObject PyPgRelation_Type = {
	PyObject_HEAD_INIT(NULL)
	0,										/* ob_size */
	"Postgres.Relation",				/* tp_name */
	sizeof(struct PyPgRelation),	/* tp_basicsize */
	0,										/* tp_itemsize */
	(destructor)rel_dealloc,		/* tp_dealloc */
	NULL,									/* tp_print */
	(getattrfunc)rel_getattr,		/* tp_getattr */
	(setattrfunc)rel_setattr,		/* tp_setattr */
	(cmpfunc)rel_compare,			/* tp_compare */
	(reprfunc)0,						/* tp_repr */
	&PyPgRelationAsNumber,			/* tp_as_number */
	&PyPgRelationAsSequence,		/* tp_as_sequence */
	&PyPgRelationAsMapping,			/* tp_as_mapping */
	(hashfunc)NULL,					/* tp_hash */
	(ternaryfunc)rel_call,			/* tp_call */
	(reprfunc)rel_str,				/* tp_str */
	NULL,									/* tp_getattro */
	NULL,									/* tp_setattro */
	NULL,									/* tp_as_buffer */
	Py_TPFLAGS_DEFAULT,			   /* tp_flags */
	(char*)PyPgRelation_Doc,		/* tp_doc */
	(traverseproc)NULL,				/* tp_traverse */
	(inquiry)rel_clear,				/* tp_clear */
	(richcmpfunc)rel_richcmp,		/* tp_richcompare */
	(long)0,								/* tp_weaklistoffset */
	(getiterfunc)rel_iter,			/* tp_iter */
	(iternextfunc)NULL,				/* tp_iternext */
	PyPgRelation_Methods,			/* tp_methods */
	NULL,									/* tp_members */
	NULL,									/* tp_getset */
	NULL,									/* tp_base */
	NULL,									/* tp_dict */
	NULL,									/* tp_descr_get */
	NULL,									/* tp_descr_set */
	0,										/* tp_dictoffset */
	(initproc)rel_init,				/* tp_init */
	NULL,									/* tp_alloc */
	PyType_GenericNew,				/* tp_new */
};

PyObj
PyPgRelation_New(Relation rel)
{
	PyObj ro = NULL;
	ro = PgRel_NEW();

	return(ro);
}
