<?php // $Id: client-edit.php,v 1.4 2001/05/07 06:48:25 ciaccia Exp $ - #phpAdsNew Revision: 1.13 #

/************************************************************************/
/* phpPgAds                                                             */
/* ========                                                             */
/*                                                                      */
/* Copyright (c) 2001 by Matteo Beccati                                 */
/* http://www.greatbridge.org/project/phppgads/                         */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

// Include required files
require ("config.php");
require ("lib-statistics.inc.php");


// Security check
phpAds_checkAccess(phpAds_Admin+phpAds_Client);



/*********************************************************/
/* Client interface security                             */
/*********************************************************/

if (phpAds_isUser(phpAds_Client))
{
	if (!phpAds_isAllowed(phpAds_ModifyInfo))
	{
		phpAds_PageHeader("$phpAds_name");
		phpAds_ShowNav("2.3");
		php_die ($strAccessDenied, $strNotAdmin);
	}

	$clientID = $Session["clientid"];
}



/*********************************************************/
/* Process submitted form                                */
/*********************************************************/

if (isset($submit))
{ 
	if (phpAds_isUser(phpAds_Admin))
	{
		// If ID is not set, it should be a null-value for the auto_increment
		$message = $strClientModified;
		
		if (empty($clientID))
		{
			$clientID = "null";
			$message = $strClientAdded;
		}
		
		// set expired
		if ($views == '-')
			$views = 0;
		if ($clicks == '-')
			$clicks = 0;
		
		// set unlimited
		if (strtolower ($unlimitedviews) == "on")
			$views = -1;
		if (strtolower ($unlimitedclicks) == "on")
			$clicks = -1;
		
		if ($expireSet == 'true')
		{
			if ($expireDay != '-' && $expireMonth != '-' && $expireYear != '-')
			{
				$expire = "'".$expireYear."-".$expireMonth."-".$expireDay."'";
			}
			else
				$expire = "NULL";
		}
		else
			$expire = "NULL";
		
		
		if ($activateSet == 'true')
		{
			if ($activateDay != '-' && $activateMonth != '-' && $activateYear != '-')
			{
				$activate = "'".$activateYear."-".$activateMonth."-".$activateDay."'";
			}
			else
				$activate = "NULL";
		}
		else
			$activate = "NULL";
		
		
		$active = "t";
		
		if ($clicks == 0 || $views==0)
			$active = "f";
		
		if ($activateDay != '-' && $activateMonth != '-' && $activateYear != '-')
			if (time() < mktime(0, 0, 0, $activateMonth, $activateDay, $activateYear))
				$active = "f";
		
		if ($expireDay != '-' && $expireMonth != '-' && $expireYear != '-')
			if (time() > mktime(0, 0, 0, $expireMonth, $expireDay, $expireYear))
				$active = "f";
		
		
		
		$permissions = 0;
		for ($i=0;$i<sizeof($clientpermissions);$i++)
		{
			$permissions += $clientpermissions[$i];
		}
		
		if ($clientID == "null")
			{
			$query = "INSERT INTO
				$phpAds_tbl_clients(clientname,
				contact,
				email,
				views,
				clicks,
				clientusername,
				clientpassword,
				expire,
				activate,
				active,
				weight,
				permissions,
				language)
			VALUES
				('$clientname',
				'$contact',
				'$email',
				'$views',
				'$clicks',
				'$clientusername',
				'$clientpassword',
				$expire,
				$activate,
				'$active',
				'$weight',
				$permissions,
				'$clientlanguage')";
			}
		else
			{
			$query = "UPDATE $phpAds_tbl_clients SET
				clientname = '$clientname',
				contact = '$contact',
				email = '$email',
				views = '$views',
				clicks = '$clicks',
				clientusername = '$clientusername',
				clientpassword = '$clientpassword',
				expire = $expire,
				activate = $activate,
				active = '$active',
				weight = '$weight',
				permissions = $permissions,
				language = '$clientlanguage'
				WHERE clientid = '$clientID'";
			}
			
		$res = db_query($query) or pg_die();  
		
		Header("Location: admin.php");
		session_register("message");
		exit;
	}
	
	if (phpAds_isUser(phpAds_Client))
	{
		$message = $strClientModified;
		$res = db_query("
			UPDATE 
				$phpAds_tbl_clients
			SET
				clientname = '$clientname',
				contact = '$contact',
				email = '$email',
				clientpassword = '$clientpassword',
				language = '$clientlanguage'
			WHERE
				clientID = '$clientID'")
			or pg_die();  
		
		$Session['language'] = $clientlanguage;
				
		Header("Location: index.php");
		session_register("message");
		exit;
	}
}




/*********************************************************/
/* HTML framework                                        */
/*********************************************************/

if ($clientID != "")
{
	if (phpAds_isUser(phpAds_Admin))
	{
		phpAds_PageHeader("$strModifyClient");
		
		$extra = '';
		
		$res = db_query("
			SELECT
				*
			FROM
				$phpAds_tbl_clients  
			") or pg_die();

		$extra = "";		
		for ($pgc = 0; $row = @pg_fetch_array($res, $pgc); $pgc++)
		{
			if ($clientID == $row['clientid'])
				$extra .= "&nbsp;&nbsp;&nbsp;<img src='images/box-1.gif'>&nbsp;";
			else
				$extra .= "&nbsp;&nbsp;&nbsp;<img src='images/box-0.gif'>&nbsp;";
			
			$extra .= "<a href=client-edit.php?clientID=". $row['clientid'].">".phpAds_buildClientName ($row['clientid'], $row['clientname'])."</a>";
			$extra .= "<br>"; 
		}
		$extra .= "<img src='images/break.gif' height='1' width='160' vspace='4'><br>";
		
		$extra .= "<br><br><br><br><br>";
		$extra .= "<b>$strShortcuts</b><br>";
		$extra .= "<img src='images/break.gif' height='1' width='160' vspace='4'><br>";
		$extra .= "<img src='images/caret-rs.gif'>&nbsp;<a href=banner-client.php?clientID=$clientID>$strBannerAdmin</a><br>";
		$extra .= "<img src='images/break.gif' height='1' width='160' vspace='4'><br>";
		$extra .= "<img src='images/caret-rs.gif'>&nbsp;<a href=stats-client.php?clientID=$clientID>$strStats</a><br>";
		$extra .= "&nbsp;&nbsp;&nbsp;<img src='images/caret-rs.gif'>&nbsp;<a href=stats-weekly.php?clientID=$clientID>$strWeeklyStats</a><br>";
		$extra .= "<img src='images/break.gif' height='1' width='160' vspace='4'><br>";
		
		phpAds_ShowNav("1.2", $extra);
	}
	else
	{
		phpAds_PageHeader("$strPreferences");
		phpAds_ShowNav("2.3");
	}
	
	$res = db_query("
		SELECT
			*,
			date_part('day', (NOW()-expire)::interval) as days_left,
			UNIX_TIMESTAMP(expire) as timestamp,
			DATE_FORMAT(expire, '$date_format') as expire_f,
			dayofmonth(expire) as expire_dayofmonth,
			month(expire) as expire_month,
			year(expire) as expire_year,
			DATE_FORMAT(activate, '$date_format') as activate_f,
			dayofmonth(activate) as activate_dayofmonth,
			month(activate) as activate_month,
			year(activate) as activate_year
		FROM
			$phpAds_tbl_clients
		WHERE
			clientID = $clientID
		") or pg_die();
	$row = pg_fetch_array($res, 0);
	
	if (!isset($row["activate_dayofmonth"]))
		$row["activate_dayofmonth"] = 0;
	if (!isset($row["activate_month"]))
		$row["activate_month"] = 0;
	if (!isset($row["activate_year"]))
		$row["activate_year"] = 0;
	if (!isset($row["activate_f"]))
		$row["activate_f"] = "-";
	
	if (!isset($row["expire_dayofmonth"]))
		$row["expire_dayofmonth"] = 0;
	if (!isset($row["expire_month"]))
		$row["expire_month"] = 0;
	if (!isset($row["expire_year"]))
		$row["expire_year"] = 0;
	if (!isset($row["expire_f"]))
		$row["expire_f"] = "-";

	if ($row["timestamp"] < time())
	{
		if ($row["timestamp"] > 0)
		{
			$days_left = "0";
		}
		else
		{
			$days_left = -1;
		}
	}
	else
	{
		$days_left=$row["days_left"];
	}
}
else
{
	phpAds_PageHeader("$strAddClient");
	phpAds_ShowNav("1.1");   

	$row["views"] = "";
	$row["clicks"] = "";
	$row["permissions"] = "";

	$days_left = "";
}



/*********************************************************/
/* Main code                                             */
/*********************************************************/

if ($row["views"] == "")
	$row["views"] = -1;
if ($row["clicks"] == "")
	$row["clicks"] = -1;

if ($days_left == "")
	$days_left = -1;

function phpAds_showDateEdit($name, $day=0, $month=0, $year=0, $edit=true)
{
	global $strMonth, $strDontExpire, $strActivateNow;
	
	if ($day == 0 && $month == 0 && $year == 0)
	{
		$day = '-';
		$month = '-';
		$year = '-';
		$set = false;
	}
	else
	{
		$set = true;
	}
	
	if ($name == 'expire')
		$caption = $strDontExpire;
	elseif ($name == 'activate')
		$caption = $strActivateNow;
	
	if ($edit)
	{
		echo "<table><tr><td>";
		echo "<input type='radio' name='".$name."Set' value='false' onclick=\"disableradio('".$name."', false);\"".($set==false?' checked':'').">";
		echo "&nbsp;$caption";
		echo "</td></tr><tr><td>";
		echo "<input type='radio' name='".$name."Set' value='true' onclick=\"disableradio('".$name."', true);\"".($set==true?' checked':'').">";
		echo "&nbsp;";
		
		echo "<select name='".$name."Day' onchange=\"checkdate('".$name."');\">\n";
		echo "<option value='-'".($day=='-' ? ' selected' : '').">-</option>\n";
		for ($i=1;$i<=31;$i++)
			echo "<option value='$i'".($day==$i ? ' selected' : '').">$i</option>\n";
		echo "</select>&nbsp;\n";
		
		echo "<select name='".$name."Month' onchange=\"checkdate('".$name."');\">\n";
		echo "<option value='-'".($month=='-' ? ' selected' : '').">-</option>\n";
		for ($i=1;$i<=12;$i++)
			echo "<option value='$i'".($month==$i ? ' selected' : '').">".$strMonth[$i-1]."</option>\n";
		echo "</select>&nbsp;\n";
		
		if ($year != '-')
			$start = $year < date('Y') ? $year : date('Y');
		else
			$start = date('Y');
		
		echo "<select name='".$name."Year' onchange=\"checkdate('".$name."');\">\n";
		echo "<option value='-'".($year=='-' ? ' selected' : '').">-</option>\n";
		for ($i=$start;$i<=($start+4);$i++)
			echo "<option value='$i'".($year==$i ? ' selected' : '').">$i</option>\n";
		echo "</select>\n";
		
		echo "</td></tr></table>";
	}
	else
	{
		if ($set == true)
		{
			echo $day." ".$strMonth[$month-1]." ".$year;
		}
		else
		{
			echo $caption;
		}
	}
}
?>


<script language="JavaScript">
<!--
	function disableradio(o, value)
	{
		day = eval ("document.clientform." + o + "Day.value");
		month = eval ("document.clientform." + o + "Month.value");
		year = eval ("document.clientform." + o + "Year.value");

		if (value == false)
		{
			eval ("document.clientform." + o + "Day.selectedIndex = 0");
			eval ("document.clientform." + o + "Month.selectedIndex = 0");
			eval ("document.clientform." + o + "Year.selectedIndex = 0");
		}
		
		if (value == true && (day=='-' || month=='-' || year=='-'))
		{
			eval ("document.clientform." + o + "Set[0].checked = true");
		}
	}

	function checkdate(o)
	{
		day = eval ("document.clientform." + o + "Day.value");
		month = eval ("document.clientform." + o + "Month.value");
		year = eval ("document.clientform." + o + "Year.value");
		
		if (day=='-' || month=='-' || year=='-')
		{
			eval ("document.clientform." + o + "Set[0].checked = true");
		}
		else
		{
			eval ("document.clientform." + o + "Set[1].checked = true");
		}
	}
	
	function valid(form)
	{
		var views=form.views.value;
		var clicks=form.clicks.value;

		if (!parseInt(views))
		{
			if (eval(form.unlimitedviews.checked) == false && views != '-')
			{
				alert("<?print $GLOBALS['strErrorViews'];?>");
				return false;
			}
		} 
		else if (parseInt(views) < 0)
		{
			alert("<?print $GLOBALS['strErrorNegViews'];?>");
			return false;
		}
		
		if (!parseInt(clicks))
		{
			if (eval(form.unlimitedclicks.checked) == false && clicks != '-')
			{
				alert("<?print $GLOBALS['strErrorClicks'];?>");
				return false;
			}
		} 
		else if (parseInt(clicks) < 0)
		{
			alert("<?print $GLOBALS['strErrorNegClicks'];?>");
			return false;
		}
	}
//-->
</script>


<form name="clientform" method="post" action="<?echo basename($PHP_SELF);?>" onSubmit="return valid(this)">
<input type="hidden" name="clientID" value="<?if(isset($clientID)) echo $clientID;?>">
<input type="hidden" name="expire" value="<?if(isset($row["expire"])) echo $row["expire"];?>">

<table border='0' width='100%' cellpadding='0' cellspacing='0'>
	<tr><td height='25' colspan='3'><b><?echo $strBasicInformation;?></b></td></tr>
	<tr height='1'><td colspan='3' bgcolor='#888888'><img src='images/break.gif' height='1' width='100%'></td></tr>

	<tr><td height='10' colspan='3'>&nbsp;</td></tr>
	<tr>
		<td width='30'>&nbsp;</td>
		<td width='200'><?echo $strClientName;?></td>
		<td><input type="text" name="clientname" size='35' style="width:350px;" value="<?if(isset($row["clientname"]))echo $row["clientname"];?>"></td>
	</tr>
	<tr>
		<td><img src='images/spacer.gif' height='1' width='100%'></td>
		<td colspan='2'><img src='images/break-l.gif' height='1' width='200' vspace='6'></td>
	</tr>
	<tr>
		<td width='30'>&nbsp;</td>
		<td width='200'><?echo $strContact;?></td>
		<td><input type="text" name="contact" size='35' style="width:350px;" value="<?if(isset($row["contact"]))echo $row["contact"];?>"></td>
	</tr>
	<tr>
		<td><img src='images/spacer.gif' height='1' width='100%'></td>
		<td colspan='2'><img src='images/break-l.gif' height='1' width='200' vspace='6'></td>
	</tr>
	<tr>
		<td width='30'>&nbsp;</td>
		<td width='200'><?echo $strEMail;?></td>
		<td><input type="text" name="email" size='35' style="width:350px;" value="<?if(isset($row["email"]))echo $row["email"];?>"></td>
	</tr>
	<tr>
		<td><img src='images/spacer.gif' height='1' width='100%'></td>
		<td colspan='2'><img src='images/break-l.gif' height='1' width='200' vspace='6'></td>
	</tr>
	<tr>
		<td width='30'>&nbsp;</td>
		<td width='200'><?echo $GLOBALS['strLanguage']; ?></td>	
		<td>
			<select name="clientlanguage">
		<?
		echo "<option value='' SELECTED>".$GLOBALS['strDefault']."</option>\n"; 

		$langdir = opendir ("../language/");
		while ($langfile = readdir ($langdir))
		{
			if (ereg ("^([a-zA-Z0-9\-]*)\.inc\.php$", $langfile, $matches))
			{
				$option = $matches[1];
				if ($row['language'] == $option)
					echo "<option value='$option' SELECTED>".(empty($GLOBALS['strThisLanguage']) ? ucfirst($option) : $GLOBALS['strThisLanguage'])."</option>\n";
				else
					echo "<option value='$option'>".ucfirst($option)."</option>\n";
			}
		}
		closedir ($langdir);
		?>
			</select>
		</td>
	</tr>
	<tr><td height='10' colspan='3'>&nbsp;</td></tr>

	<tr height='1'><td colspan='3' bgcolor='#888888'><img src='images/break.gif' height='1' width='100%'></td></tr>
</table>

<br><br>
<br><br>
<table border='0' width='100%' cellpadding='0' cellspacing='0'>
	<tr><td height='25' colspan='3'><b><?echo $strContractInformation;?></b></td></tr>
	<tr height='1'><td colspan='3' bgcolor='#888888'><img src='images/break.gif' height='1' width='100%'></td></tr>

	<tr><td height='10' colspan='3'>&nbsp;</td></tr>
	<?
		if (isset($row['active']) && $row['active'] == 'false') {
	?>
	<tr>
		<td width='30' valign='top'><img src='images/info.gif'></td>
		<td width='200' colspan='2'>
		<?
			echo $strClientDeactivated;
			
			$expire_ts = mktime(0, 0, 0, $row["expire_month"], $row["expire_dayofmonth"], $row["expire_year"]);
			
			if ($row['clicks'] == 0) echo ", $strNoMoreClicks";
			if ($row['views'] == 0) echo ", $strNoMoreViews";
			if (time() < mktime(0, 0, 0, $row["activate_month"], $row["activate_dayofmonth"], $row["activate_year"]))
				echo ", $strBeforeActivate";
			if (time() > $expire_ts && $expire_ts > 0)
				echo ", $strAfterExpire";
			
			echo ".<br><br>";
		?>
		</td>
	</tr>
	<tr>
		<td><img src='images/spacer.gif' height='1' width='100%'></td>
		<td colspan='2'><img src='images/break-l.gif' height='1' width='200' vspace='6'></td>
	</tr>
	<?
		}
	?>
	<tr>
		<td width='30'>&nbsp;</td>
		<td width='200'><?echo $strViewsPurchased;?></td>
		<?
		if (phpAds_isUser(phpAds_Admin))
		{
			?>
			<td>
				<input type="text" name="views" size='25' value="<?if($row["views"]>0)echo $row["views"];else echo '-';?>" onKeyUp="disable_checkbox('unlimitedviews');">
				<input type="checkbox" name="unlimitedviews"<?if($row["views"]==-1)print " CHECKED";?> onClick="click_checkbox('unlimitedviews', 'views');">
				<? echo $GLOBALS['strUnlimited']; ?>
			</td>
			<?
		}
		else {
			?>
			<td><?if($row["views"]!=-1)echo $row["views"];else echo $GLOBALS['strUnlimited'];?></td>
			<?
		}
		?>
	</tr>
	<tr>
		<td><img src='images/spacer.gif' height='1' width='100%'></td>
		<td colspan='2'><img src='images/break-l.gif' height='1' width='200' vspace='6'></td>
	</tr>
	<tr>
		<td width='30'>&nbsp;</td>
		<td width='200'><?echo $strClicksPurchased;?></td>
		<?
		if (phpAds_isUser(phpAds_Admin))
		{
			?>
			<td>
				<input type="text" name="clicks" size='25' value="<?if($row["clicks"]>0)echo $row["clicks"];else echo '-';?>" onKeyUp="disable_checkbox('unlimitedclicks');">
				<input type="checkbox" name="unlimitedclicks"<?if($row["clicks"]==-1)print " CHECKED";?> onClick="click_checkbox('unlimitedclicks', 'clicks');">
				<? echo $GLOBALS['strUnlimited']; ?>
			</td>
			<?
		}
		else {
			?>
			<td><?if($row["clicks"]!=-1)echo $row["clicks"];else echo $GLOBALS['strUnlimited'];?></td>
			<?
		}
		?>
	</tr>
	<tr>
		<td><img src='images/spacer.gif' height='1' width='100%'></td>
		<td colspan='2'><img src='images/break-l.gif' height='1' width='200' vspace='6'></td>
	</tr>
	<tr>
		<td width='30'>&nbsp;</td>
		<td width='200'><? echo $GLOBALS['strActivationDate']; ?></td>
		<?
		if (phpAds_isUser(phpAds_Admin))
		{
			?>
			<td>
				<? phpAds_showDateEdit('activate', isset($row["activate_dayofmonth"]) ? $row["activate_dayofmonth"] : 0, 
												   isset($row["activate_month"]) ? $row["activate_month"] : 0, 
												   isset($row["activate_year"]) ? $row["activate_year"] : 0); ?>
			</td>
			<?
		}
		else 
		{
			?>
			<td>
				<? phpAds_showDateEdit('activate', isset($row["activate_dayofmonth"]) ? $row["activate_dayofmonth"] : 0, 
												   isset($row["activate_month"]) ? $row["activate_month"] : 0, 
												   isset($row["activate_year"]) ? $row["activate_year"] : 0, false); ?>
			</td>
			<?
		}
		?>
	</tr>
	<tr>
		<td><img src='images/spacer.gif' height='1' width='100%'></td>
		<td colspan='2'><img src='images/break-l.gif' height='1' width='200' vspace='6'></td>
	</tr>
	<tr>
		<td width='30'>&nbsp;</td>
		<td width='200'><? echo $strExpirationDate; ?></td>
		<?
		if (phpAds_isUser(phpAds_Admin))
		{
			?>
			<td>
				<? phpAds_showDateEdit('expire', isset($row["expire_dayofmonth"]) ? $row["expire_dayofmonth"] : 0, 
												 isset($row["expire_month"]) ? $row["expire_month"] : 0, 
												 isset($row["expire_year"]) ? $row["expire_year"] : 0); ?>
			</td>
			<?
		}
		else 
		{
			?>
			<td>
				<? phpAds_showDateEdit('expire', isset($row["expire_dayofmonth"]) ? $row["expire_dayofmonth"] : 0, 
												 isset($row["expire_month"]) ? $row["expire_month"] : 0, 
												 isset($row["expire_year"]) ? $row["expire_year"] : 0, false); ?>
			</td>

			<?
		}
		?>
	</tr>
	<tr>
		<td><img src='images/spacer.gif' height='1' width='100%'></td>
		<td colspan='2'><img src='images/break-l.gif' height='1' width='200' vspace='6'></td>
	</tr>
	<tr>
		<td width='30'>&nbsp;</td>
		<td width='200'><?echo $strWeight;?></td>
		<?
		if (phpAds_isUser(phpAds_Admin))
		{
			?>
			<td>
				<input type="text" name="weight" size='25' value="<?echo isset($row["weight"]) ? $row["weight"] : 1;?>">
			</td>
			<?
		}
		else {
			?>
			<td><?echo $row["weight"];?></td>
			<?
		}
		?>
	</tr>

	<tr><td height='10' colspan='3'>&nbsp;</td></tr>

	<tr height='1'><td colspan='3' bgcolor='#888888'><img src='images/break.gif' height='1' width='100%'></td></tr>
</table>

<br><br>
<br><br>

<table border='0' width='100%' cellpadding='0' cellspacing='0'>
	<tr><td height='25' colspan='3'><b><?echo $strLoginInformation;?></b></td></tr>
	<tr height='1'><td colspan='3' bgcolor='#888888'><img src='images/break.gif' height='1' width='100%'></td></tr>

	<tr><td height='10' colspan='3'>&nbsp;</td></tr>
	<tr>
		<td width='30'>&nbsp;</td>
		<td width='200'><?echo $strUsername;?></td>
		<?
		if (phpAds_isUser(phpAds_Admin))
		{
			?>
			<td><input type="text" name="clientusername" size='25' value="<?if(isset($row["clientusername"]))echo $row["clientusername"];?>">
			<?
		}
		else 
		{
			?>
			<td><?if(isset($row["clientusername"]))echo $row["clientusername"];?>
			<?
		}
		?>
	</tr>
	<tr>
		<td><img src='images/spacer.gif' height='1' width='100%'></td>
		<td colspan='2'><img src='images/break-l.gif' height='1' width='200' vspace='6'></td>
	</tr>
	<tr>
		<td width='30'>&nbsp;</td>
		<td width='200'><?echo $strPassword;?></td>
		<td><input type="text" name="clientpassword" size='25' value="<?if(isset($row["clientpassword"]))echo $row["clientpassword"];?>">
	</tr>
	<tr><td height='10' colspan='3'>&nbsp;</td></tr>
		<?
		if (phpAds_isUser(phpAds_Admin))
		{
			?>
	<tr height='1'><td colspan='3' bgcolor='#888888'><img src='images/break.gif' height='1' width='100%'></td></tr>
	<tr><td height='10' colspan='3'>&nbsp;</td></tr>

	<tr>
		<td width='30'>&nbsp;</td>
		<td colspan='2'>
			<input type="checkbox" name="clientpermissions[]" value="<?echo phpAds_ModifyInfo; ?>"<?echo (phpAds_ModifyInfo & $row["permissions"]) ? " CHECKED" : ""; ?>>
			<?echo $GLOBALS['strAllowClientModifyInfo']; ?>
		</td>
	</tr>
	<tr>
		<td width='30'>&nbsp;</td>
		<td colspan='2'>
			<input type="checkbox" name="clientpermissions[]" value="<?echo phpAds_ModifyBanner; ?>"<?echo (phpAds_ModifyBanner & $row["permissions"]) ? " CHECKED" : ""; ?>>
			<?echo $GLOBALS['strAllowClientModifyBanner']; ?>
		</td>
	</tr>	
	<!-- Still working on this (Niels)
	<tr>
		<td width='30'>&nbsp;</td>
		<td colspan='2'>
			<input type="checkbox" name="clientpermissions[]" value="<?echo phpAds_AddBanner; ?>"<?echo (phpAds_AddBanner & $row["permissions"]) ? " CHECKED" : ""; ?>>
			<?echo $GLOBALS['strAllowClientAddBanner']; ?>
		</td>
	</tr>	
	-->
			<?
		}
		?>
	<tr><td height='10' colspan='2'>&nbsp;</td></tr>
</table>
		
<br><br>
		
<input type="submit" name="submit" value="<?echo $strSaveChanges;?>">
</form>



<?

/*********************************************************/
/* HTML framework                                        */
/*********************************************************/

phpAds_PageFooter();

?>
