/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef FOREIGNKEYGROUPLISTVIEWITEM_H
#define FOREIGNKEYGROUPLISTVIEWITEM_H

#include "../../baselistviewitem.h"
#include "../../../dataaccess/tables/foreignkeys/dbforeignkey.h"
#include "../../../dataaccess/dbmastermanagerref.h"

/**
 * This list view item is used to represent a group of foreign keys.
 */
class ForeignKeyGroupListViewItem: public BaseListViewItem, public DBMasterManagerRef
{
protected:
	string m_strTableName;
				
public:
	
	/**
 	 * Constructor
   */		
	ForeignKeyGroupListViewItem(QListViewItem *pqoListViewItem);
	
	/**
 	 * Constructor
   */			
	ForeignKeyGroupListViewItem(QListViewItem *pqoListViewItem, QListViewItem *pqoAfterItem);	

	/**
 	 * Used to set the table name.
 	 * @param rstrTableName	the table name
   */			    	
	void setTableName(const string & rstrTableName);
			
	/**
 	 * Used to create all the first level children of the current item.
   */			    						
	virtual void initChildren();

};


#endif

