/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef SEQUENCEITEMPOPUP_H
#define SEQUENCEITEMPOPUP_H

#include <qpopupmenu.h>
#include <qstring.h>
#include "sequencelistviewitem.h"

/**
 * This popup menu is fired when a user right clicks on a sequence item in the list viewer.
 */
class SequenceItemPopup: public QPopupMenu
{
	Q_OBJECT
	
protected:
	SequenceListViewItem * m_poSequenceListViewItem;	
	
public:
	/**
	 * Constructor
	 */
	SequenceItemPopup(QWidget *pqoParent, SequenceListViewItem *poSequenceListViewItem);

	/**
	 * Used to get a reference to the sequence item that this popup was generated from.
	 */
	SequenceListViewItem * getSequenceListViewItem() const;
	
protected slots:	
	/**
	 * This slot is called by the popup menu itself when edit comment is selected.
	 */
	void editComment();
	
private:

};


#endif

