/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "sequencegrouplistviewitem.h"
#include "sequencelistviewitem.h"
#include "sequencegroupitempopup.h"
#include "../common/infodialogs.h"
#include "../../utils/debugger.h"
#include "../../dataaccess/sequences/dbsequencemanager.h"
#include "../../dataaccess/sequences/dbsequenceset.h"

#include <iostream.h>

	SequenceGroupListViewItem::SequenceGroupListViewItem(QListViewItem *pqoListViewItem)
		: BaseListViewItem(pqoListViewItem), DBMasterManagerRef()
	{
		setText(0, "Sequences");
		m_qstrDescription = "<h1>Sequences</h1><hr><p>Lists all the sequences and its properties in this database.</p>";
	} // end constructor

	SequenceGroupListViewItem::SequenceGroupListViewItem(QListViewItem *pqoListViewItem, QListViewItem *pqoAfterItem)
		: BaseListViewItem(pqoListViewItem, pqoAfterItem), DBMasterManagerRef()
	{
		setText(0, "Sequences");
		m_qstrDescription = "<h1>Sequences</h1><hr><p>Lists all the sequences and its properties in this database.</p>";		
	} // end constructor

	/**
 	 * Displays the right pressed menu for this item.
   */			    	
	void SequenceGroupListViewItem::showRightPressedMenu(const QPoint & rqoLocation, int nColumn)
	{
		string strMethodName = "SequenceGroupListViewItem::showRightPressedMenu";
		Debugger::entered(strMethodName);
		
		// check to see if menu has been brought up previously
		if (m_pqoPopupMenu == 0)
		{
			m_pqoPopupMenu = new SequenceGroupItemPopup(listView(), this);
		} // end if popup already created
		m_pqoPopupMenu->popup(rqoLocation);
		
		Debugger::exited(strMethodName);
	} // end showRightPressedMenu		
					
	/**
 	 * Used to create all the first level children of the current item.
   */			    						
	void SequenceGroupListViewItem::initChildren()
	{	
		string strMethodName = "SequenceGroupListViewItem::initChildren";
		
		Debugger::entered(strMethodName);

		// temporary sequence set
		DBSequenceSet oDBSequenceSet;
		
		try
		{		
			getDBMasterManager()->getDBSequenceManager()->retrieveListOfSequences(oDBSequenceSet);
		} // end try
		catch (SQLException e)
		{
			Debugger::logException(strMethodName, e);
			// report error to user
			InfoDialogs::infoSQLException(listView(), e);						
			return;
		} // end catch
		while (oDBSequenceSet.next())
		{
			SequenceListViewItem *poSequenceItem = new SequenceListViewItem(this);
			// retrieve Sequence details
			oDBSequenceSet.getDBSequence(*poSequenceItem);
			poSequenceItem->setText(0, poSequenceItem->getSequenceName().c_str());					
			// set database connection
			poSequenceItem->setDBMasterManager(getDBMasterManager());
			poSequenceItem->updateDescription();
		} // end while more
				
		Debugger::exited(strMethodName);		
	} // end initChildren
	