/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef MAINLISTVIEW_H
#define MAINLISTVIEW_H

#include <qlistview.h>
#include <qstring.h>
#include <qdom.h>
#include "../exceptions/xmlparseexception.h"
#include "grouplistviewitem.h"
#include "serverlistviewitem.h"

/**
 * The main list view.
 */
class MainListView: public QListView
{
	Q_OBJECT
public:
	/**
	 * Constructor
	 */
	MainListView(QWidget *pqoParent);
	
	/**
	 * This function is used to setup the database servers from the database settings file.
	 */
	void readDatabaseSettingsFromFile();
			
public slots:

	/**
	 * This function is used to save the database servers to the database settings file.
	 */
	void saveDatabaseSettingsToFile();

	/**
 	 * This slot should be called when a list item is left pressed. The function should signal to
 	 * the text browser widget that the description needs to be updated.
   *
   * @param 	*pqoListViewItem	the item that was left pressed
   */	
	void changeItemDescription(QListViewItem *pqoListViewItem);
	
	/**
	 * This slot is used to add a new group item.
	 */
	void addGroupItem();

protected:

	/**
	 * This is used to store the file name for the database settings.
	 */
	QString m_qstrDatabaseSettingsFileName;

	/**
	 * This internal method is used to parse the group list tag.
	 */
	void parseGroupListTag(QDomElement & rqobjGroupListTag) throw (XmlParseException);	
		
	/**
	 * This internal method is used to parse the group list tag.
	 */
	void parseServerListTag(QDomElement & rqobjServerListTag, GroupListViewItem * pobjGroupItem)
		 throw (XmlParseException);	

	/**
	 * This internal method is used to parse the database list tag.
	 */
	void parseDatabaseListTag(QDomElement & rqobjDatabaseListTag, ServerListViewItem * pobjServerItem)
			throw (XmlParseException);	
		
protected slots:
	/**
 	 * This slot should be called when a list item is right pressed. The function should call the
 	 * showRightClickedMenu function from the list view item. Also sets the text of the browser
 	 * text widget.
   *
   * @param 	*pqoListViewItem	the item that was right pressed
   * @param		rqoPoint					the point at which the item was clicked
   * @param		nColumn						the column the item belongs to
   */
	void showRightPressedMenu(QListViewItem *pqoListViewItem, const QPoint & rqoPoint, int nColumn);
			
	/**
 	 * This slot should be called when a list item is expanded. The function should call the
 	 * set the initGrandChildren function of the item. This will tell the children to prepare to be
 	 * viewed.
   *
   * @param 	*pqoListViewItem	the item that was expanded
   */		
	void prepareGrandChildren(QListViewItem *pqoListViewItem);		

signals:
	/**
	 * This signal is used to tell another widget that the item description needs to be updated.
	 */
	void itemDescriptionChanged(const QString & rqstrDescription);
	
};


#endif
