/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef GROUPLISTVIEWITEM_H
#define GROUPLISTVIEWITEM_H

#include "baselistviewitem.h"
#include <string>

/**
 * This list view item is used to represent a group item.
 */
class GroupListViewItem: public BaseListViewItem
{
protected:
	string m_strGroupName;
	string m_strGroupDescription;

public:	
	/**
 	 * Constructor
   */		
	GroupListViewItem(QListView *pqoListView);

	/**
	 * This method is used to set the group name.
	 */
	void setGroupName(const string &rstrGroupName);

	/**
	 * This method is used to get the group name.
	 */
	const string & getGroupName() const;
	
	/**
	 * This method is used to set the group description.
	 */
	void setGroupDescription(const string &rstrGroupDescription);
	
	/**
	 * This method is used to get the group description.
	 */
	const string & getGroupDescription() const;

	/**
 	 * Displays the right pressed menu for this item.
   */			    	
	virtual void showRightPressedMenu(const QPoint & rqoLocation, int nColumn);
	
	/**
 	 * Used to update the description.
   */			    	
	virtual void updateDescription();
				
	/**
 	 * Used to create all the first level children of the current item.
   */			    						
	virtual void initChildren();
	
	
};

#endif