/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef FUNCTIONLISTVIEWITEM_H
#define FUNCTIONLISTVIEWITEM_H

#include "../baselistviewitem.h"
#include "../../dataaccess/functions/dbfunction.h"
#include "../../dataaccess/dbmastermanagerref.h"

/**
 * This list view item is used to represent a database function.
 */
class FunctionListViewItem: public BaseListViewItem, public DBFunction, public DBMasterManagerRef
{
				
public:
	
	/**
 	 * Constructor
   */		
	FunctionListViewItem(QListViewItem *pqoListViewItem);
	FunctionListViewItem(QListViewItem *pqoListViewItem, QListViewItem *pqoAfterItem);	

	/**
 	 * Displays the right pressed menu for this item.
   */			    	
	virtual void showRightPressedMenu(const QPoint & rqoLocation, int nColumn);
	
	/**
 	 * Used to update the description.
   */			    	
	void updateDescription();
		
		
protected:

};


#endif

