/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef XMLPARSEEXCEPTION_H
#define XMLPARSEEXCEPTION_H

#include "vpsystemexception.h"
#include <string>

/**
 * This exception is thrown when an Xml string cannot be parsed.
 */
class XmlParseException: public VPSystemException
{
protected:
	string m_strFileName;
	string m_strXmlText;

public:

	/**
 	 * Constructor
 	 *
 	 * @param	rstrFileName	used to indicate the file name that was parsed
 	 * @param	rstrXmlText	used to indicate what the exception was 	 	
 	 * @param	rstrDescription	used to indicate what the exception was
 	 * @param	rstrClassName		the class that the exception was initially thrown from
 	 * @param	rstrMethodName		the method that the exception was initially thrown from
   */		
	XmlParseException(const string & rstrFileName, const string & rstrXmlText,
			const string &rstrDescription, const string &rstrClassName, const string &rstrMethodName);
			
	/**
 	 * Copy Constructor
 	 *
 	 * @param	roException			another exception to copy
   */		
	XmlParseException(const XmlParseException &roException);

	/**
 	 * Assignment operator
 	 *
 	 * @param	roException			another exception to assign from
   */		
	XmlParseException & operator=(const XmlParseException &roException);
				
	/**
	 * This function is used to retrieve the file name
	 * @return	the file name
	 */
	const string & getFileName() const;			

	/**
	 * This function is used to retrieve the xml text
	 * @return	the xml text
	 */
	const string & getXmlText() const;			
	
};


#endif

