/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef SQLEXCEPTION_H
#define SQLEXCEPTION_H


#include "vpsystemexception.h"
#include <string>

/**
 * This exception is thrown when a error occurs trying to query the database.
 */
class SQLException: public VPSystemException
{
protected:
	string m_strSQL;

public:
	/**
 	 * Constructor
 	 *
 	 * @param	rstrSQL	the sql statement that was issued
 	 * @param	rstrDescription	used to indicate what the exception was
 	 * @param	rstrClassName		the class that the exception was initially thrown from
 	 * @param	rstrMethodName		the method that the exception was initially thrown from
   */		
	SQLException(const string &rstrSQL, const string &rstrDescription, const string &rstrClassName, const string &rstrMethodName);
	
	/**
 	 * Constructor
 	 *
 	 * @param	rstrDescription	used to indicate what the exception was
 	 * @param	rstrClassName		the class that the exception was initially thrown from
 	 * @param	rstrMethodName		the method that the exception was initially thrown from
   */		
	SQLException(const string &rstrDescription, const string &rstrClassName, const string &rstrMethodName);

	/**
 	 * Copy Constructor
 	 *
 	 * @param	roException			another exception to copy
   */		
	SQLException(const SQLException &roException);

	/**
 	 * Assignment operator
 	 *
 	 * @param	roException			another exception to assign from
   */		
	SQLException & operator=(const SQLException &roException);
				
	/**
	 * This function is used to retrieve the SQL statement that was issued when the exception occured.
	 * @return	the sql statement
	 */
	const string & getSQL() const;
};


#endif

