/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "dbforeignkey.h"

	/**
 	 * Constructor
   */		
	DBForeignKey::DBForeignKey()
	{
		clear();	
	} // end constructor
	
	/**
 	 * Destructor
   */		
	DBForeignKey::~DBForeignKey()
	{
	} // end destructor

	/**
	 * This function will clear out variables in this object, so that it can be used again.
	 */
	void DBForeignKey::clear()
	{
		m_strForeignKeyName = "";
		m_strForeignTableName = "";
		m_strTableName = "";
		m_vstrForeignColumns.clear();
		m_vstrReferencingColumns.clear();
	} // end clear

	/**
 	 * Used to set the foreign key name.
   */			    	
	void DBForeignKey::setForeignKeyName(const string &rstrForeignKeyName)
	{
		m_strForeignKeyName = rstrForeignKeyName;
	} // end setForeignKeyName

	/**
 	 * Used to retrieve the foreign key name.
   */			    			
	const string & DBForeignKey::getForeignKeyName() const
	{
		return m_strForeignKeyName;
	} // end getForeignKeyName
				
	/**
 	 * Used to set the foreign table name.
   */			    	
	void DBForeignKey::setForeignTableName(const string &rstrForeignTableName)
	{
		m_strForeignTableName = rstrForeignTableName;
	} // end setForeignTableName

	/**
 	 * Used to retrieve the foreign table name.
   */			    			
	const string & DBForeignKey::getForeignTableName() const
	{
		return m_strForeignTableName;
	} // end getForeignTableName

	/**
 	 * Used to set the table name.
   */			    						
	void DBForeignKey::setTableName(const string &rstrTableName)
	{
		m_strTableName = rstrTableName;
	} // end setTableName

	/**
 	 * Used to retrieve the table name.
   */			    			
	const string & DBForeignKey::getTableName() const
	{
		return m_strTableName;
	} // end getTableName			

	/**
 	 * Used to add a foreign key column.
   */			    						
	void DBForeignKey::addForeignColumn(const string & rstrForeignColumn)
	{
		m_vstrForeignColumns.push_back(rstrForeignColumn);
	} // end addForeignColumn

	/**
 	 * Used to retrieve a foreign key column.
   */			    			
	const string & DBForeignKey::getForeignColumn(int nColumnIndex) const throw (IndexOutOfRangeException)
	{
		if (nColumnIndex < 0 || nColumnIndex >= getNumberOfForeignColumns())
		{
			throw IndexOutOfRangeException("Index out of range.", "DBForeignKey", "getForeignColumn");					
		} // end if out of range		
		return m_vstrForeignColumns[nColumnIndex];
	} // end getForeignColumn
	
	/**
	 * Used to get the number of foreign key columns.
	 */
	int DBForeignKey::getNumberOfForeignColumns() const
	{
		return m_vstrForeignColumns.size();
	} // end getNumberOfForeignColumns 			
		
	/**
 	 * Used to add a referencing key column.
   */			    						
	void DBForeignKey::addReferencingColumn(const string & rstrReferencingColumn)
	{
		m_vstrReferencingColumns.push_back(rstrReferencingColumn);
	} // end addReferencingColumn

	/**
 	 * Used to retrieve a referencing key column.
   */			    			
	const string & DBForeignKey::getReferencingColumn(int nColumnIndex) const throw (IndexOutOfRangeException)
	{
		if (nColumnIndex < 0 || nColumnIndex >= getNumberOfReferencingColumns())
		{
			throw IndexOutOfRangeException("Index out of range.", "DBForeignKey", "getReferencingColumn");					
		} // end if out of range				
		return m_vstrReferencingColumns[nColumnIndex];
	} // end getReferencingColumn
	
	/**
	 * Used to get the number of referencing key columns.
	 */
	int DBForeignKey::getNumberOfReferencingColumns() const
	{
		return m_vstrReferencingColumns.size();
	} // end getNumberOfReferencingColumns

