/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef DBSEQUENCESET_H
#define DBSEQUENCESET_H

#include <string>
#include "../dbrecordset.h"
#include "dbsequence.h"

// forward declaration
class DBSequenceManager;

/**
 * This class is used to hold a set of database sequences. It implements the
 * abstract DBRecordSetInterface class.
 */
class DBSequenceSet : DBRecordSetInterface
{
protected:
	// this record set is used to hold the set of available sequences
	DBRecordSet m_oSequenceList;
				
public:

	/**
	 * Friend class.
	 */
	friend class DBSequenceManager;
	
	/**
 	 * Constructor 	
   */		
  DBSequenceSet();
	
	/**
 	 * Destructor
   */		
	~DBSequenceSet();

	/**
	 * Used to indicate if the record set is empty.
	 * @return	true if record set is empty, false otherwise
	 */
	bool isEmpty();

	/**
	 * Used to get the current index location.
	 * @return	the current index
	 */
	int getCurrentIndex();
		
	/**
	 * Used to move to the next record in the record set. This function must be called before
	 * the first result can be retrieved. When a record set is initially set, the internal
	 * pointer points to a location before the first record. The reason for this is so that
	 * the record set may sit in a while loop with calls to next indicating if more records
	 * are to come. The function returns true when more records exist and false when no more
	 * records are to come.
	 *
	 * @return	true when more records to come, false when no more records
	 */
	bool next();

	/**
	 * Used to move to the previous record in the record set. The function returns true when
	 * a previous record exists, it will return false when the begining of the set is reached.
	 *
	 * @return	true when previous record exists, false when first record reached (or when empty record set)
	 */
	bool previous();

  /**
	 * Used to move the cursor back to a position before the first record. This is used when
	 * the recordset needs to be used but then reset, so that next() function can be used
	 * correctly.
	 */
	void reset();

	/**
	 * Used to move to the first record.
	 * @exception	throws NoRecordException when empty record
	 */
	void first() throw (NoRecordException);

	/**
	 * Used to move to the last record.
	 * @exception	throws NoRecordException when empty record	
	 */
	void last() throw (NoRecordException);
				
	/**
	 * Used to get the number of records in this record set.
	 * @return 	the number of records
	 */
	int getRecordCount();	

	/**
	 * Used to get the current sequence.
	 * @param	roDBSequence the a DBSequence object used to return output for current record
	 * @exception	throws NoRecordException when empty record	
	 */
	void getDBSequence(DBSequence & roDBSequence) throw (NoRecordException);
	
};

#endif

