--
-- install_customerdb.sql
--
-- customerdb is a sample data base for use with pfm version 1.2.3
-- To install it, create a new database, then run this SQL script
-- on that database.
--
-- Note: This SQL script also installs the pfm_* tables. Do not run
--       it on a database that already contains the pfm_* tables.

--
-- TOC entry 16 (OID 90638)
-- Name: pfm_version; Type: TABLE; Schema: public; Owner: wim
--

CREATE TABLE pfm_version (
    seqnr serial NOT NULL,
    "version" text,
    date text,
    "comment" text
);

INSERT INTO pfm_version ("version", "date", "comment")
VALUES ('1.2.3', CURRENT_DATE, 'install_customerdb.sql');


--
-- TOC entry 6 (OID 100533)
-- Name: pfm_attribute; Type: TABLE; Schema: public; Owner: wim
--

CREATE TABLE pfm_attribute (
    attribute text NOT NULL,
    typeofattrib text,
    typeofget text,
    sqlselect text,
    nr integer,
    form text NOT NULL,
    valuelist text,
    "default" text
);


--
-- TOC entry 7 (OID 100538)
-- Name: pfm_form; Type: TABLE; Schema: public; Owner: wim
--

CREATE TABLE pfm_form (
    name text NOT NULL,
    tablename text,
    showform boolean DEFAULT true,
    "view" boolean DEFAULT false,
    sqlselect text,
    sqlfrom text,
    groupby text,
    help text,
    pkey text
);


--
-- TOC entry 8 (OID 100545)
-- Name: pfm_link; Type: TABLE; Schema: public; Owner: wim
--

CREATE TABLE pfm_link (
    linkname text NOT NULL,
    sqlwhere text,
    orderby text,
    displayattrib text,
    fromform text NOT NULL,
    toform text
);


--
-- TOC entry 9 (OID 100550)
-- Name: pfm_report; Type: TABLE; Schema: public; Owner: wim
--

CREATE TABLE pfm_report (
    name text NOT NULL,
    description text,
    sqlselect text
);


--
-- TOC entry 10 (OID 100555)
-- Name: pfm_section; Type: TABLE; Schema: public; Owner: wim
--

CREATE TABLE pfm_section (
    report text NOT NULL,
    "level" integer NOT NULL,
    fieldlist text,
    layout text,
    summary text,
    CONSTRAINT level_min_1 CHECK (("level" >= 1))
);


--
-- TOC entry 11 (OID 100560)
-- Name: pfm_value; Type: TABLE; Schema: public; Owner: wim
--

CREATE TABLE pfm_value (
    value text NOT NULL,
    description text,
    valuelist text NOT NULL
);


--
-- TOC entry 12 (OID 100565)
-- Name: pfm_value_list; Type: TABLE; Schema: public; Owner: wim
--

CREATE TABLE pfm_value_list (
    name text NOT NULL
);


--
-- TOC entry 13 (OID 100683)
-- Name: customer; Type: TABLE; Schema: public; Owner: wim
--

CREATE TABLE customer (
    id serial NOT NULL,
    name text,
    street text,
    post_code text,
    town text,
    country text,
    telephone text,
    e_mail text
);


--
-- TOC entry 14 (OID 100691)
-- Name: product; Type: TABLE; Schema: public; Owner: wim
--

CREATE TABLE product (
    id serial NOT NULL,
    name text,
    description text,
    nr_in_stock integer,
    price numeric(8,2)
);


--
-- TOC entry 15 (OID 100697)
-- Name: order; Type: TABLE; Schema: public; Owner: wim
--

CREATE TABLE "order" (
    invoice integer NOT NULL,
    product integer NOT NULL,
    how_many integer
);


--
-- TOC entry 16 (OID 100701)
-- Name: invoice; Type: TABLE; Schema: public; Owner: wim
--

CREATE TABLE invoice (
    id serial NOT NULL,
    customer integer,
    date date
);


--
-- Data for TOC entry 34 (OID 100533)
-- Name: pfm_attribute; Type: TABLE DATA; Schema: public; Owner: wim
--

COPY pfm_attribute FROM stdin;
linkname	taQuoted	tgDirect		1	pfm_link	none	\N
value	taQuoted	tgDirect	\N	2	pfm_value	none	\N
sqlwhere	taQuoted	tgDirect		4	pfm_link	none	\N
orderby	taQuoted	tgDirect		5	pfm_link	none	\N
displayattrib	taQuoted	tgDirect		6	pfm_link	none	\N
description	taQuoted	tgDirect		3	pfm_value	none	\N
name	taQuoted	tgDirect		1	pfm_report	none	\N
description	taQuoted	tgDirect		2	pfm_report	none	\N
report	taQuoted	tgLink	select name, description from pfm_report order by name	1	pfm_section	none	\N
fieldlist	taQuoted	tgDirect		4	pfm_section	none	\N
nr	taNotQuoted	tgDirect		7	pfm_attribute	none	\N
name	taQuoted	tgDirect		1	pfm_form	none	\N
tablename	taQuoted	tgDirect		2	pfm_form	none	\N
attribute	taQuoted	tgDirect		2	pfm_attribute	none	\N
sqlselect	taQuoted	tgDirect		5	pfm_attribute	none	\N
form	taQuoted	tgLink	SELECT name FROM pfm_form ORDER BY name	1	pfm_attribute	none	\N
fromform	taQuoted	tgLink	SELECT name FROM pfm_form ORDER BY name	2	pfm_link	none	\N
toform	taQuoted	tgLink	SELECT name FROM pfm_form ORDER BY name	3	pfm_link	none	\N
valuelist	taQuoted	tgLink	SELECT name FROM pfm_value_list ORDER BY name	1	pfm_value	none	\N
name	taQuoted	tgDirect		1	pfm_value_list	none	\N
sqlselect	taQuoted	tgDirect		3	pfm_report	none	\N
sqlselect	taQuoted	tgDirect	\N	4	pfm_form	none	\N
sqlfrom	taQuoted	tgDirect	\N	5	pfm_form	none	\N
help	taQuoted	tgDirect		9	pfm_form	none	\N
groupby	taQuoted	tgDirect		6	pfm_form	none	\N
pkey	taQuoted	tgDirect		3	pfm_form	none	
default	taQuoted	tgDirect		8	pfm_attribute	none	
typeofattrib	taQuoted	tgList		3	pfm_attribute	typeofattribute	taQuoted
typeofget	taQuoted	tgList	\N	4	pfm_attribute	typeofget	tgDirect
valuelist	taQuoted	tgLink	SELECT name FROM pfm_value_list ORDER BY name	6	pfm_attribute	none	none
showform	taQuoted	tgList		7	pfm_form	boolean	t
view	taQuoted	tgList		8	pfm_form	boolean	f
level	taNotQuoted	tgDirect		2	pfm_section	none	1
layout	taQuoted	tgList		3	pfm_section	layout	table
id	taNotQuoted	tgDirect		1	customer	none	=SELECT nextval('customer_id_seq')
street	taQuoted	tgDirect		3	customer	none	
post_code	taQuoted	tgDirect		4	customer	none	
town	taQuoted	tgDirect		5	customer	none	
country	taQuoted	tgDirect		6	customer	none	
telephone	taQuoted	tgDirect		7	customer	none	
e_mail	taQuoted	tgDirect		8	customer	none	
id	taNotQuoted	tgDirect		1	invoice	none	=SELECT nextval('invoice_id_seq')
customer	taNotQuoted	tgLink	SELECT id, name FROM customer ORDER BY name	2	invoice	none	
date	taQuoted	tgDirect		3	invoice	none	=SELECT CURRENT_DATE
name	taQuoted	tgReadOnly		4	invoice	none	
id	taNotQuoted	tgDirect		1	product	none	=SELECT nextval('product_id_seq')
name	taQuoted	tgDirect		2	product	none	
description	taQuoted	tgDirect		3	product	none	
nr_in_stock	taNotQuoted	tgDirect		4	product	none	
price	taNotQuoted	tgExpression		5	product	none	
how_many	taNotQuoted	tgDirect		7	order	none	
amount	taNotQuoted	tgReadOnly		5	invoice	none	
c_id	taNotQuoted	tgReadOnly		4	order	none	
c_name	taQuoted	tgReadOnly		5	order	none	
p_name	taQuoted	tgReadOnly		6	order	none	
amount	taNotQuoted	tgReadOnly		8	order	none	
product	taNotQuoted	tgLink	SELECT id, name FROM product ORDER BY name	2	order	none	
date	taQuoted	tgReadOnly		3	order	none	
invoice	taNotQuoted	tgLink	SELECT invoice.id, invoice."date",c.name\nFROM invoice LEFT OUTER JOIN customer c ON (invoice.customer = c.id)\nORDER BY invoice."date" DESC, c.name	1	order	none	
nr_of_invoices	taNotQuoted	tgReadOnly		9	customer	none	
name	taQuoted	tgDirect		2	customer	none	
summary	taQuoted	tgDirect		5	pfm_section	none	
\.


--
-- Data for TOC entry 35 (OID 100538)
-- Name: pfm_form; Type: TABLE DATA; Schema: public; Owner: wim
--

COPY pfm_form FROM stdin;
pfm_value_list	pfm_value_list	f	f	name	pfm_value_list	\N	The table "pfm_value_list" contains all the value lists of all the forms.\n\nIts only attribute is\n\n    - name : a name uniquely identifying the value list.\n	name
pfm_link	pfm_link	f	f	linkname, sqlwhere, orderby, displayattrib, fromform, toform	pfm_link	\N	A link is a navigation tool which allows you to follow a "one-to-many"\nor "many-to-one" relationship from one form to another.\n\nEvery link is stored as a record in the pfm_link table, which has the\nfollowing attributes:\n\n    - linkname : the name of the link, which is displayed on\n      a link button on the "fromform";\n\n    - fromform : the name of the form from which the link\n      originates;\n\n    - toform : the name of the form to which the link leads;\n\n    - sqlwhere : the "WHERE"-clause which is used to open the\n      "toform" and in which the value of an attribute of the\n      "fromform" may be represented by $(attrib-x), where\n      'attrib-x' is the name of the attribute;\n\n    - orderby : an 'order by' clause which determines the order of the\n      records in the 'toform';\n\n    - displayattrib : a space separated list of\n      attributes of the 'fromform', the value of which is displayed on\n      the 'toform' to remind the user from which record the link\n      originated.\n\nNote: Postgres Forms does not provide any checks to safeguard\n      the referential integrity of the data base in case of updates or\n      deletions. However, postgreSQL provides these functions as\n      'foreign key' table constraints (see postgreSQL documentation).	fromform linkname
pfm_value	pfm_value	f	f	value, description, valuelist	pfm_value	\N	The table "pfm_value" contains all the values of the lists defined in\npfm_value_list.\n\nIt has the following attributes:\n\n    - valuelist : the name of the valuelist to which this value belongs\n\n    - value : a character string;\n\n    - description : a description of the value.\n	valuelist value
pfm_form	pfm_form	f	f	name, tablename, sqlselect, sqlfrom, groupby, showform, "view", help, pkey	pfm_form	\N	A form has a one-to-one relation with just 1 database table. Only the\ndata of that table can be administered by means of the form. This\ntable is henceforth referred to as "the form's main table".\n\nHowever, the form also has a one-to-one relationship with just one SQL\nSELECT statement, which generates the data that are displayed on the\nform.\n\nIn the simplest case the SQL SELECT statement is just:\n\n    SELECT <attributes of main table> FROM <main table>\n\nIn that case, the data which can be administered and the data which\nare displayed on the form are the same.\n\nIn more complex cases, the <main table> can be JOINED with other\ntables, which makes it possible to display data of other related\ntables as well. These data cannot be modified by means of the form.\n\nThe table "pfm_form" has the following attributes:\n\n    - name : the name of the form (usually equal to the name of\n      the form's table);\n\n    - tablename : the name of the form's main table;\n\n    - pkey : the primary key of the form's main table, which may\n      consist of more than one attribute. In that case pkey is a SPACE\n      separated list of the attributes of the primary key;\n\n      Note: If pkey is empty, the form is read-only, since pfm is\n            unable to uniquely identify a record. You can use the\n            'oid' as primary key, but according to the PostgreSQL\n            documentation that is not recommended, unless you set a\n            UNIQUE constraint on the 'oid'.\n\n    - sqlselect : the attribute list of the form's SQL SELECT\n      statement, not including the word 'SELECT';\n\n    - sqlfrom : the FROM clause of the form's SQL SELECT\n      statement, not including the word 'FROM';\n\n    - groupby : an optional 'GROUP BY' clause, not\n      including the words 'GROUP BY';\n\n    - view : a boolean indicating whether or not the\n      "tablename" is a view;\n\n    - showform : a boolean indicating whether the form is shown\n      in "normal mode" (showform = 'true') or in "design mode"\n      (showform = 'false'). Typically, showform is set 'true' for user\n      defined forms and 'false' for the predefined pfm_* forms.\n\n    - help : a text which is displayed when the user presses\n      the [Help] key on the form.\n\nThe form's main table is defined by tablename. Only the data of\nthat table can be administered by using the form.\n\nAll the data generated by the form's SQL SELECT statement can be\ndisplayed on the form. The SQL SELECT statement is defined by:\n\n    - the sqlselect, sqlfrom and groupby attributes of pfm_form; and\n\n    - the optional WHERE and ORDER BY clauses provided by the user\n      when opening the form.\n\nNote: The WHERE clause provided by the user when opening the form, is\n      automatically converted to a HAVING clause, if there is a GROUP\n      BY clause.\n\nThe following rules should be observed when filling out sqlselect and\nsqlfrom:\n\n    1. The form's main table must appear in 'sqlfrom', and must not be\n       aliased. Similarly, the main table's attributes appearing in\n       'sqlselect' must not be aliased. The other tables appearing in\n       the 'sqlfrom' may be aliased.\n\n    2. The fields appearing in 'sqlselect' must have a unique, simple\n       name without the need to precede them with a tablename. So,\n       calculated fields must be given a name by aliasing and\n       attributes of tables other than the main table may need to be\n       aliased in order to have a unique, simple name.\n\n    3. The 'sqlfrom' is either just the name of the form's main table,\n       or it is a JOIN clause in which 1 of the tables is the form's\n       main table. Several join clauses can be nested in order to\n       involve more than 2 tables. See examples below.\n\n\nExample 1: the SQL SELECT for the person form of the addressbook database\n\n\ntablename:\n    person\n\npkey:\n    id\n\nsqlselect:\n    id, christian_name, name, street, town, "ZIPcode",\n    country, category, description\n\nsqlfrom:\n    person\n\ngroupby:\n    -\n\n\nExample 2: the SQL SELECT for the memberlist form of the addressbook database\n\n\ntablename:\n    memberlist\n\npkey:\n    group person\n\nsqlselect:\n    memberlist."group", memberlist.person, p.christian_name, p.name\n\nsqlfrom:\n    memberlist LEFT OUTER JOIN person p ON (p.id = memberlist.person)\n\ngroupby:\n    -	name
pfm_attribute	pfm_attribute	f	f	attribute, typeofattrib, typeofget, sqlselect, nr, form, valuelist, "default"	pfm_attribute	\N	The table "pfm_attribute" defines all the properties of form attributes.\n\nIt has the following attributes:\n\n    - form : the "name" of the form to which the attribute\n      belongs;\n\n    - attribute : the name of the attribute; this must be equal\n      to the name of the corresponding attribute of the form's SQL\n      SELECT statement;\n\n    - typeofattrib : the type of attribute:\n\n        o taQuoted: the value provided by the user is put\n             between single quotes when it is transferred to SQL\n             UPDATE or INSERT statements;\n            \n        o taNotQuoted: the value provided by the user is not\n             quoted when it is transferred to SQL UPDATE or INSERT\n             statements.\n\n          Hint: In general, all attribute values must be quoted, exept\n                the values or expressions for numeric attributes.\n\n    - typeofget: defines how the user provides a value for the\n      attribute; possible values are:\n\n          o tgDirect: the user types the value directly;\n\n          o tgExpression: the user types an expression which is first\n            evaluated before it is passed to SQL UPDATE or INSERT;\n\n            Note: Even with tgDirect it is possible to enter an\n                  expression as new value for an attribute, but then\n                  the expression is evaluated by postgresql whereas\n                  with tgExpression, the expression is first evaluated\n                  by Tcl before the SQL statement is sent to\n                  postgresql.\n\n          o tgList: the user selects a value by means of a list box\n            containing a list of values defined in table "pfm_value";\n\n          o tgLink: the user selects a value by means of a list box\n            containing a list of values which is the result from a\n            query on another table.\n\n          o tgReadOnly: this attribute cannot be modified by\n            the user.\n\n            Note: All calculated attributes and all attributes from\n                  tables other than the form's main table should be\n                  declared 'read-only'. If this rule is not observed,\n                  the Add and Update operations on this form will fail.\n\n    - sqlselect: the SQL SELECT statement which is used to fill the\n      list box with possible values for the attribute (only meaningful\n      if typeofget = tgLink).\n\n      Note :\n\n         o The sqlselect may return more than 1 attribute. If so, all\n           the attributes are displayed in the list-box, but only the\n           first one is used for updating the attribute.\n\n    - valuelist : the "name" of the value list defined in table\n      "pfm_value_list" (only meaningful if typeofget = tgList);\n\n    - nr: a number which determines the order in which attributes are\n      displayed on the form;\n\n    - default: a default value for this attribute which is used when\n      adding a record. If the first character is an '=' sign, the\n      following characters should be an SQL SELECT statement which\n      returns just one value.\n\n      Example:\n\n      default: =SELECT nextval('seq_person_id')\n\n      In this example the default value is the next value of the\n      sequenece 'seq_person_id'.\n	form attribute
product	product	t	f	id, name, description, nr_in_stock, price	product			id
order	order	t	f	"order".invoice, "order".product, "order".how_many,\ni.date, i.customer AS c_id, c.name AS c_name, p.name AS p_name,\n(p.price * "order".how_many) AS amount	"order"\n   LEFT OUTER JOIN invoice i ON ("order".invoice = i.id)\n   LEFT OUTER JOIN customer c ON (i.customer = c.id)\n   LEFT OUTER JOIN product p ON ("order".product = p.id)			invoice product
invoice	invoice	t	f	invoice.id, invoice.customer, invoice.date, c.name,\nSUM(p.price * o.how_many)::numeric(9,2) AS amount	invoice\n    LEFT OUTER JOIN customer c ON (invoice.customer = c.id)\n    LEFT OUTER JOIN "order" o ON (invoice.id = o.invoice)\n    LEFT OUTER JOIN product p ON (o.product = p.id)	invoice.id, invoice.customer, invoice.date, c.name		id
customer	customer	t	f	customer.id, customer.name, customer.street, customer.post_code, customer.town, customer.country, customer.telephone, customer.e_mail, COUNT(i.id) AS nr_of_invoices	customer LEFT OUTER JOIN invoice i ON (customer.id = i.customer)	customer.id, customer.name, customer.street, customer.post_code, customer.town, customer.country, customer.telephone, customer.e_mail		id
pfm_section	pfm_section	f	f	report, "level", fieldlist, layout, summary	pfm_section	\N	The data returned by the report's SQL SELECT statement may be\nconsidered as a table with a column for each 'field' specified after\nthe word 'SELECT' and with a row for each record.\n\nBy specifying an 'ORDER BY' clause in the report's SQL SELECT\nstatement, it is possible to group rows with the same values for some\nfields together.\n\nThe report generator has an "economy" algorithm which avoids printing\nthe same data repeatedly.\n\nTo control this you have to distribute the fields (columns) of the\ntable over n sections such that section 1 contains the fields that are\nchanging least frequently (when moving from one row to the next),\nsection 2 contains the fields that are changing more frequently, and\nsection n contains the fields that are changing at every row.\n\nWhen the data of the first row of the table are printed, the data of\nsection 1 are printed first. Then, on the following line, indented by\none tab stop, the data of section 2 are printed. Then, on the\nfollowing line, indented by 2 tab stops, data of section 2 are\nprinted, etc.\n\n[section 1] <--- row 1\n\n    [section 2] <--- row 1\n\n        [section 3]  <--- row 1\n\nThen, when the next rows are being printed, data of the lower numbered\nsections are only printed if they are different from the data of the\nlast printed section of the same number:\n\n[section 1]\n\n    [section 2]\n\n        [section 3]  <--- row 1\n        [section 3]  <--- row 2\n        [section 3]  <--- row 3\n\n    [section 2]\n\n        [section 3]  <--- row 4\n        [section 3]  <--- row 5\n\n[section 1]\n\n    [section 2]\n\n        [section 3]  <--- row 6\n        [section 3]  <--- row 7\n\nThe report generator also enables you to print a summary at every\npoint where a higher numbered section is about to be followed by a\nlower numbered section:\n\n[section 1]\n\n    [section 2]\n\n        [section 3]  <--- row 1\n        [section 3]  <--- row 2\n        [section 3]  <--- row 3\n\n        [summary 3]\n\n    [section 2]\n\n        [section 3]  <--- row 4\n        [section 3]  <--- row 5\n\n        [summary 3]\n\n    [summary 2]\n\n[section 1]\n\n    [section 2]\n\n        [section 3]  <--- row 6\n        [section 3]  <--- row 7\n\n        [summary 3]\n\n    [summary 2]\n\n[summary 1]\n\nA summary i is printed just before a lower numbered section j (j < i).\nIts data can be calculated:\n\n    - by applying one of the aggregate funtions: COUNT, SUM, AVG,\n      STDDEV, MIN, MAX;\n\n    - on the fields of the sections j (j >= i), between the last\n      printed lower numbered section k (k < i), till the next (not\n      yet printed) lower numbered section k (k < i).\n\nIn particular, summary 1 is printed at the end of the report, is\ncalculated from all the sections of the report and may be calculated\nfrom all the fields.\n\nA record in pfm_section defines a section and a summary of a report.\n\nThe table pfm_section has the following attributes:\n\n    - report: the name of the report to which the section belongs\n\n    - level: a number 1, 2, 3, 4, ... . The first level must be\n      '1'. The next levels must be numbered consecutively. In the most\n      simple report, there is only a section with level 1.\n\n    - layout: can be "row", "column" or "table".\n\n    - fieldlist: a space separated list of field specifiers,\n      one for each field to be printed in the sections of this level\n      (see below for details).\n\n    - summary: a space separated list of summary field\n      specifiers (see below for details).\n\nThe fieldlist must be formatted as follows:\n\n{field_1 label_1 alignment_1} {field_2 label_2 alignment_2}...\n                                     {field_N label_N alignment_N}\n\nwhere :\n\n    - field_i is the name of one of the columns returned by the\n      report's SQL SELECT statement;\n\n    - label_i is a string which has to be used as label for printing\n      the i-th field of this section; if it consists of more than 1\n      word, it must be delimited by double quotes (" .... ");\n\n    - alignment_i is optional; if present, it is either l or r,\n      indicating whether this field should be left or right aligned.\n\n      Notes :\n\n          o The alignment is optional. If it is left out, left\n            alignment is assumed by default.\n\n          o The alignment only influences the table layout. Column and\n            row layouts are unaffected by the alignment indicator.\n\n          o Multi-line fields, i.e. fields containing more than one\n            line of text are only formatted properly in a column layout.\n\nFor every section, the layout can be defined as:\n\n    - row: the section's field labels and field values are\n      printed in one row in a format: label_1 : value_1; label_2 :\n      value_2; ... etc.\n\n    - column: the section's field labels are printed in a first\n      column, the section's field values are printed in a second column.\n\n    - table: the section's values are printed in a table with a\n      column per field and a row per record, the section's field\n      labels are used as column headers for the table.\n\nThe summary must be formatted as follows:\n\n{field_1 aggregate_1 format_1} {field_2 aggregate_2 format_2}...\n                                      {field_N aggregate_N format_N}\n\nwhere:\n\n    - field_i is the name of a field defined in the fieldlist of\n      either this section, or another, higher numbered section;\n\n    - aggregate_i is one of the aggregate functions: COUNT, SUM, AVG,\n      STDDEV, MIN, MAX (see below for details); and\n\n    - format_i is an optional 'ANSI C sprintf' formatting string (see\n      below for details). If it is left out, the number is printed\n      with maximum precision.\n\n\nAggregate functions:\n\nIn general, the aggregate functions, use the same "economy" algorithm\nthat is used for printing section data.\n\nWhen all the fields of a section, which is not the highest numbered\nsection of the report, have the same values for a number of\nconsecutive rows, this section's data are only printed once for these\nrows.\n\nSimilarly, these rows are only counted once by the aggregate functions\napplied to a field of this section.\n\nThe aggregate functions that can be used in a summary are:\n\n    - COUNT: Counts the number of rows. In this case, the field_i that\n           is specified only determines which section is counted.\n\n    - SUM: Calculates the sum of all the values of the specified\n           field.\n\n    - AVG: Calculates the average of the values of the specified\n           field.\n\n    - STDDEV: Calculates the standard deviation for the values of the\n           specified field:\n\n           SQRT (SUM( (value_i - AVG(value))**2 ) / N)\n\n\t   where :\n\n               - value_1, value_2, ... value_N are the values of the\n                 considered field;\n\n               - AVG(value) is the average of the considered values;\n\n               - N is the number of values.\n\n    - MIN: Calculates the minimum of the values of the specified\n           field.\n\n    - MAX: Calculated the maximum of the values of the specified\n           field.\n\n\n'ANSI C sprintf' formatting string:\n\nHere is a short overview of the 'ANSI C sprintf' formatting string. In\ngeneral its form is:\n\n     %'MinWidth'.'Precision''Conversion'\n\nwhere:\n\n    - 'MinWidth' is an integer defining the minimum width (as number\n      of characters) for the number to be printed. If the number does\n      not need so much space, spaces are inserted in front of the\n      number, unless MinWidth is negative. In that case, spaces are\n      appended at the end. If the number needs more space than\n      MinWidth, more space is used.\n\n    - 'Precision' is an integer defining how many digits to print\n      after the decimal point, or, in the case of g or G conversion,\n      the total number of digits to appear, including those on both\n      sides of the decimal point\n\n    - 'Conversion' is one of:\n\n          o d : convert integer to signed decimal string. In this case,\n                there is no need to define a 'Precision'.\n\n                Example: %1d\n\n                         prints an integer and uses as many characters\n                         as required.\n\n          o f : convert floating point number to fixed point\n                notation. In this case, 'Precision' defines the number\n                of digits to print after the decimal point. If there\n                are not enough digits available, trailing zeroes are\n                appended.\n\n                Example: %1.2f\n\n                         prints a floating point number wiht 2 digits\n                         after the decimal point and uses as many\n                         characters as required.\n\n          o e or E : Convert floating-point number to scientific\n                notation in the form x.yyyezz, where the number of\n                y's is determined by the 'Precision' (default: 6). If\n                the precision is 0 then no decimal point is output. If\n                the E form is used then E is printed instead of e.\n\n                Example: %1.5E\n\n                         prints a floating point number in the form\n                         x.yyyyy Ezz \n\n          o g or G : If the exponent is less than -4 or greater than\n                or equal to the precision, then convert floating-point\n                number as for %e or %E. Otherwise convert as for\n                %f. Trailing zeroes and a trailing decimal point are\n                omitted. In this case the 'Precision' specifies the\n                total number of digits to appear, including those on\n                both sides of the decimal point\n\n                Example: %1.4G\n\n                          prints 2345.0 as 2345\n                          prints 234567.0 as 2.346E+05\n                          prints 0.003456 as 0.003456\n                          prints 0.00003456 as 3.456E-05	report level
pfm_report	pfm_report	f	f	name, description, sqlselect	pfm_report	\N	The table pfm_report defines all the reports for the current data\nbase.\n\npfm_report has the following attributes:\n\n    - name: the name of the report. This is the name that\n      appears in the selection list of the "Run Report" function.\n\n    - description: free text describing the purpose of the\n      report in more detail.\n\n    - sqlselect: an SQL SELECT statement that generates the\n      data for the report.\n\nThe sqlselect may contain one or more parameters for which a\nvalue is requested at "Run report" time. A parameter in the sqlwhere\nmust be formatted as $(parameter_name).\n\nExample:\n\nsqlselect: \n\n    SELECT g.name AS "group", g.description, p.id, p.name,\n           p.christian_name, p.street, p."ZIPcode", p.town, p.country\n    FROM "group" g\n       LEFT JOIN memberlist m ON g.name = m."group"\n       LEFT JOIN person p ON m.person = p.id\n    WHERE "group" = '$(group)'\n    ORDER BY g.name, p.name, p.christian_name\n\nWhen the report is run, the user is prompted to enter a value for the\nparameter "group". Then the report data are generated by executing the\nsqlselect statement in which $(group) is replaced with the value\nentered by the user.	name
\.


--
-- Data for TOC entry 36 (OID 100545)
-- Name: pfm_link; Type: TABLE DATA; Schema: public; Owner: wim
--

COPY pfm_link FROM stdin;
Report	name='$(report)'		level	pfm_section	pfm_report
Sections	report='$(name)'	level	name	pfm_report	pfm_section
Attributes	form='$(name)'	nr	name	pfm_form	pfm_attribute
incoming links	toform='$(name)'	fromform	name	pfm_form	pfm_link
outgoing links	fromform='$(name)'	toform	name	pfm_form	pfm_link
Where used?	valuelist='$(name)'		name	pfm_value_list	pfm_attribute
Values	valuelist='$(name)'	value	name	pfm_value_list	pfm_value
Value list	name='$(valuelist)'		attribute	pfm_attribute	pfm_value_list
from Form	name='$(fromform)'		linkname	pfm_link	pfm_form
to Form	name='$(toform)'		linkname	pfm_link	pfm_form
Valuelist	name='$(valuelist)'		value	pfm_value	pfm_value_list
Form	name='$(form)'		attribute	pfm_attribute	pfm_form
Invoices	invoice.customer = $(id)	"date" DESC	id name	customer	invoice
Invoice	invoice.id = $(invoice)			order	invoice
Orders	"order".product = $(id)		id name	product	order
Product	id = $(product)		invoice c_name	order	product
Customer	customer.id = $(customer)		id date	invoice	customer
Orders	"order".invoice = $(id)		id date name	invoice	order
\.


--
-- Data for TOC entry 37 (OID 100550)
-- Name: pfm_report; Type: TABLE DATA; Schema: public; Owner: wim
--

COPY pfm_report FROM stdin;
Invoices	Invoices since a certain date	SELECT i.id, i."date", i.customer, c.name AS c_name, c.street, c.town, c.country,\n       o.product, p.name AS p_name, p.price, o.how_many,\n       (p.price * o.how_many)::numeric(9,2) AS amount\nFROM invoice i\n    LEFT OUTER JOIN customer c ON (i.customer = c.id)\n    LEFT OUTER JOIN "order" o ON (i.id = o.invoice)\n    LEFT OUTER JOIN product p ON (o.product = p.id)\nWHERE i."date" >= '$(since)'\nORDER BY c.name, i."date"
\.


--
-- Data for TOC entry 38 (OID 100555)
-- Name: pfm_section; Type: TABLE DATA; Schema: public; Owner: wim
--

COPY pfm_section FROM stdin;
Invoices	1	{customer CustNr l} {c_name Customer l} {street Street l} {town Town l} {country Country l}	row	{customer COUNT}
Invoices	2	{id Invoice l} {date Date l}	row	{amount SUM %1.2f} {id COUNT %1d}
Invoices	3	{product pNr r} {p_name Product l} {price Price r} {how_many HowMany r} {amount Amount r}	table	{amount SUM %1.2f}
\.


--
-- Data for TOC entry 39 (OID 100560)
-- Name: pfm_value; Type: TABLE DATA; Schema: public; Owner: wim
--

COPY pfm_value FROM stdin;
taQuoted	Value must be enclosed in ' ' for SQL.	typeofattribute
taNotQuoted	Value must not be enclosed in ' ' for SQL.	typeofattribute
tgDirect	Value directly typed by user.	typeofget
tgExpression	Value may be given as an expression.	typeofget
tgList	Value comes from a valuelist.	typeofget
tgLink	Value comes from 'sqlselect'.	typeofget
t	TRUE	boolean
f	FALSE	boolean
column	A column for the labels, a second column for the corresponding values	layout
table	A table with the labels as table header	layout
row	Labels and values on 1 row	layout
tgReadOnly	User cannot change the value of this attribute	typeofget
\.


--
-- Data for TOC entry 40 (OID 100565)
-- Name: pfm_value_list; Type: TABLE DATA; Schema: public; Owner: wim
--

COPY pfm_value_list FROM stdin;
typeofattribute
typeofget
boolean
layout
none
\.


--
-- Data for TOC entry 41 (OID 100683)
-- Name: customer; Type: TABLE DATA; Schema: public; Owner: wim
--

COPY customer FROM stdin;
6	Nancy Verdonck	Azalealaan 23	9520	Lokeren	Belgi	09 223 45 67	n.vcb@pi.be
8	Nestor Stassyns	Calle Salinas 343	2000	Buenos Aires	Argentina		nestor.stassyns@argentel.ag
16	Cecile Verplancke	Ternesselei 45	3500	Hasselt	Belgi	011 23 443	cepla@tiscali.be
9	Staf De Wilde	Lange Lepelstraat 55	2345	Zwevezele	Belgi	03 233 62 60	
3	Frans Van Langenacker	Transvaalstraat 36	9000	Gent	Belgi	03 326 25 60	fvla@vt4.be
10	Dirk Versmissen	Draaiboom 4	4576	Stekene	Belgi	03 465 32 67	dirkv@vt4.be
5	Jacky Verelst	Kesselsebaan 45	7400	Sint-Niklaas	Belgi	03 234 56 32	jacky.verelst@skynet.be
\.


--
-- Data for TOC entry 42 (OID 100691)
-- Name: product; Type: TABLE DATA; Schema: public; Owner: wim
--

COPY product FROM stdin;
2	SuSE 8.2 professional	Linux distribution	12	81.50
3	Windows XP - new PC	Microsoft windows XP for new PC	12	99.50
4	Windows XP upgrade	Microsoft windows not bound to a particular PC	3	399.00
5	Tcl/Tk	Tool Command Language and Toolkit	12	12.30
7	Open Office	CD met Office pakekt voor Windows en Linux	12	10.00
1	SuSE 8.2 personal	Linux distribution	12	23.20
6	PostgreSQL	Relational database server	23	15.60
\.


--
-- Data for TOC entry 43 (OID 100697)
-- Name: order; Type: TABLE DATA; Schema: public; Owner: wim
--

COPY "order" FROM stdin;
11	5	12
11	1	12
1	5	3
12	2	1
11	6	5
15	7	3
15	6	2
15	3	4
11	3	3
1	7	2
16	5	2
1	1	1
1	6	4
6	1	2
6	6	2
16	7	3
17	3	1
17	7	2
18	6	2
19	5	1
19	6	2
19	7	2
19	1	1
20	6	2
20	1	3
21	6	3
21	7	4
\.


--
-- Data for TOC entry 44 (OID 100701)
-- Name: invoice; Type: TABLE DATA; Schema: public; Owner: wim
--

COPY invoice FROM stdin;
11	8	2003-12-17
12	8	2003-12-18
15	8	2004-01-13
16	10	2004-01-14
1	6	2003-11-07
6	3	2003-12-10
17	16	2004-12-03
18	16	2004-12-04
19	9	2004-12-04
20	5	2004-12-04
21	10	2004-12-06
\.


--
-- TOC entry 21 (OID 100641)
-- Name: pfm_version_pkey; Type: CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY pfm_version
    ADD CONSTRAINT pfm_version_pkey PRIMARY KEY (seqnr);


--
-- TOC entry 25 (OID 100643)
-- Name: pfm_report_pkey; Type: CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY pfm_report
    ADD CONSTRAINT pfm_report_pkey PRIMARY KEY (name);


--
-- TOC entry 28 (OID 100645)
-- Name: pfm_value_list_pkey; Type: CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY pfm_value_list
    ADD CONSTRAINT pfm_value_list_pkey PRIMARY KEY (name);


--
-- TOC entry 23 (OID 100647)
-- Name: pfm_form_pkey; Type: CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY pfm_form
    ADD CONSTRAINT pfm_form_pkey PRIMARY KEY (name);


--
-- TOC entry 22 (OID 100649)
-- Name: pfm_attribute_pkey; Type: CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY pfm_attribute
    ADD CONSTRAINT pfm_attribute_pkey PRIMARY KEY (form, attribute);


--
-- TOC entry 24 (OID 100651)
-- Name: pfm_link_pkey; Type: CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY pfm_link
    ADD CONSTRAINT pfm_link_pkey PRIMARY KEY (fromform, linkname);


--
-- TOC entry 26 (OID 100653)
-- Name: pfm_section_pkey; Type: CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY pfm_section
    ADD CONSTRAINT pfm_section_pkey PRIMARY KEY (report, "level");


--
-- TOC entry 27 (OID 100655)
-- Name: pfm_value_pkey; Type: CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY pfm_value
    ADD CONSTRAINT pfm_value_pkey PRIMARY KEY (valuelist, value);


--
-- TOC entry 29 (OID 100739)
-- Name: customer_pkey; Type: CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY customer
    ADD CONSTRAINT customer_pkey PRIMARY KEY (id);


--
-- TOC entry 30 (OID 100741)
-- Name: product_pkey; Type: CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY product
    ADD CONSTRAINT product_pkey PRIMARY KEY (id);


--
-- TOC entry 32 (OID 100743)
-- Name: invoice_pkey; Type: CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY invoice
    ADD CONSTRAINT invoice_pkey PRIMARY KEY (id);


--
-- TOC entry 31 (OID 100757)
-- Name: order_pkey; Type: CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY "order"
    ADD CONSTRAINT order_pkey PRIMARY KEY (invoice, product);


--
-- TOC entry 49 (OID 100657)
-- Name: ref_sections; Type: FK CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY pfm_section
    ADD CONSTRAINT ref_sections FOREIGN KEY (report) REFERENCES pfm_report(name) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 50 (OID 100661)
-- Name: ref_list; Type: FK CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY pfm_value
    ADD CONSTRAINT ref_list FOREIGN KEY (valuelist) REFERENCES pfm_value_list(name) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 45 (OID 100665)
-- Name: ref_form; Type: FK CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY pfm_attribute
    ADD CONSTRAINT ref_form FOREIGN KEY (form) REFERENCES pfm_form(name) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 46 (OID 100669)
-- Name: ref_value_list; Type: FK CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY pfm_attribute
    ADD CONSTRAINT ref_value_list FOREIGN KEY (valuelist) REFERENCES pfm_value_list(name) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 47 (OID 100673)
-- Name: ref_fromform; Type: FK CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY pfm_link
    ADD CONSTRAINT ref_fromform FOREIGN KEY (fromform) REFERENCES pfm_form(name) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 48 (OID 100677)
-- Name: ref_toform; Type: FK CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY pfm_link
    ADD CONSTRAINT ref_toform FOREIGN KEY (toform) REFERENCES pfm_form(name) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 53 (OID 100745)
-- Name: ref_customer; Type: FK CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY invoice
    ADD CONSTRAINT ref_customer FOREIGN KEY (customer) REFERENCES customer(id) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 51 (OID 100749)
-- Name: ref_invoice; Type: FK CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY "order"
    ADD CONSTRAINT ref_invoice FOREIGN KEY (invoice) REFERENCES invoice(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 52 (OID 100753)
-- Name: ref_product; Type: FK CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY "order"
    ADD CONSTRAINT ref_product FOREIGN KEY (product) REFERENCES product(id) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 18 (OID 100681)
-- Name: customer_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wim
--

SELECT setval('customer_id_seq', 17, true);


--
-- TOC entry 19 (OID 100689)
-- Name: product_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wim
--

SELECT setval('product_id_seq', 7, true);


--
-- TOC entry 20 (OID 100699)
-- Name: invoice_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wim
--

SELECT setval('invoice_id_seq', 21, true);




