-- simulated xs40
library ieee;
use ieee.std_logic_1164.all;
entity xs40tb is end entity xs40tb;

architecture a1 of xs40tb is

constant tclk: time:= 100 nS;
signal reset: std_ulogic;
signal clk: std_ulogic;
subtype bus8 is std_logic_vector(7 downto 0);
signal al: bus8;
signal ah: bus8;
signal p0: bus8;
signal p3: bus8;
signal ma: std_logic_vector(15 downto 0);
signal psen: std_ulogic;
signal ale: std_ulogic;
signal wr_n: std_ulogic; --P3.6
signal rd_n: std_ulogic; --P3.7
signal en_led: std_ulogic;
signal ledport: bus8;

begin --a1

mcu: entity work.mcs8051(behav)
port map(
p0=> p0,
p1=> al,
p2=> ah,
p3=> p3,
rst => reset,
xtal1 => clk,
ale=> ale,
psen_n=> psen,
ea_n => '0' -- =0 for external access mode
);

ram32k: entity work.sram(behavior)
generic map(
size=> 2048, -- number of memory words
adr_width=> 15, -- number of address bits
width=> 8 -- number of bits per memory word
)
port map(
nCE=> '0',
nOE=> psen,
nWE=> '1', --disable writes for now
A=> ma(14 downto 0),
D=> p0,
download_filename=> "hjp1.hex",
loadfile_is_hex=> TRUE
);

-- memory address bus
ma<= ah & al;
-- address latch (implemented in xc4k)
al<= p0 after 18 nS when ale='1';
-- port latch (implemented in xc4k)
en_led<= ah(7) and ah(6) and ah(5) and not wr_n;
ledport<= p0 when en_led='1';

-- clock process
clock: process is
begin
clk<= '0';
wait for tclk/2;
clk<= '1';
wait for tclk/2;
end process clock;

end architecture a1;

