library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use std.textio.all;

entity serial_driver is
  generic (filename : string := "testing.txt");
  port(
    TX : out std_logic;
    RX : in std_logic);
end entity;

architecture behave of serial_driver is
  signal int_clock : std_logic := '0';
  signal clk : std_logic := '0';
  begin

  clk <= not clk after 4.34 us; 

  clock_div : process(clk)
-- make internal
  variable count : integer := 0;
    begin
    if(clk'event and (clk'last_value = '0' or clk'last_value = 'L') and 
       (clk = '1' or clk = 'H')) then
      count := count + 1;
    end if;
    if (count = 6) then
      count := 0;
      int_clock <= not int_clock;
    end if;
  end process clock_div;

  receive : process(clk, RX)
-- set for n81 and an internal that is 12 times faster than the bit stream
    variable clk_count : integer := 0;
    variable bit_count : integer := 0;
    variable start : boolean := FALSE;
    variable tmp_char : integer := 0;
    begin
    if(clk'event and (clk'last_value = 'L' or clk'last_value = '0') and
      (clk = 'H' or clk = '1') and start) then
      clk_count := clk_count + 1;
      if(clk_count = 12) then
        clk_count := 0;
        bit_count := bit_count + 1;
      end if;
      if(clk_count = 2 and bit_count > 0 and bit_count < 9) then
        if(RX = '1' or RX = 'H') then
          tmp_char := tmp_char + (2**(bit_count-1));
        end if;
      end if;
      if(bit_count = 9) then
-- should check to see if a stop bit was received;
        start := FALSE;
        report "receive " & character'val(tmp_char);
        tmp_char := 0;
        bit_count := 0;
      end if;
    end if;
    if(RX'event and (RX'last_value = 'H' or RX'last_value = '1') and
      (RX = 'L' or RX = '0') and not start) then
      start := TRUE;
    end if;
  end process receive;

  transmit : process 
    file control : text open read_mode is filename;
    variable open_status : file_open_status;
    variable read_status : boolean;
    variable char_to_send : string(1 to 1);
    variable L : line;
    variable ascii : integer;
    variable tmp_char : character;
    variable bit_char : std_logic_vector(1 to 8);
    variable clk_count : integer := 0;
    variable txing : boolean := FALSE;
    variable bit_count : integer := 0;
    variable start_up : boolean := FALSE;

    begin
    wait on int_clock;
    if not start_up then
      TX <= '1';
      wait for 2 ms;
      start_up := TRUE;
    end if;
--      file_open(status => open_status, f => control,
--                external_name => filename);

    if(not txing) then
      if(not read_status) then
        readline(control, L);
        read(L, char_to_send, read_status) ;
      else 
        if(read_status) then
          tmp_char := char_to_send(1);
          ascii := character'pos(tmp_char);
          bit_char := CONV_STD_LOGIC_VECTOR(ascii, 8);
          txing := TRUE;
--        report integer'image(ascii);
        end if;
        read(L, char_to_send, read_status) ;
      end if;
      if(endfile(control)) then
        file_close(f => control);
        file_open(status => open_status, f => control,
                  external_name => filename);
      end if;
    else
      if(int_clock'event and 
        (int_clock'last_value = '1' or int_clock'last_value = 'H') and
        (int_clock = '0' or int_clock = 'L')) then
      else
        if(bit_count = 0) then
          TX <= '0';
        end if;
        if(bit_count > 0 and bit_count < 9) then
          TX <= bit_char(9-bit_count); 
        end if;
        if(bit_count = 9) then
          TX <= '1';
        end if;
        if(bit_count > 9) then
          bit_count := 0;
          txing := FALSE;
          TX <= '1';
        end if;
        if(txing) then
          bit_count := bit_count + 1;
        end if;
      end if;
    end if;
  end process transmit;
end architecture;
