library IEEE;
use IEEE.std_logic_1164.all;

entity seven_seg is
  generic (inst : string := "1");
  port (a, b, c, d, e, f, g, dec, a1, a2, a3 : in std_logic );
end seven_seg;

architecture behavioral of seven_seg is
begin
  process (a,b,c,d,e,f,g,dec,a1,a2,a3)
    VARIABLE val : std_logic_vector(6 DOWNTO 0);
    begin
      val := to_X01(std_logic_vector'(a&b&c&d&e&f&g));
      CASE val IS
        WHEN "1111111" =>  report("Led Lights BLANK, INST: "&inst);
        WHEN "0000001" =>  report("Led Lights 0, INST: "&inst);
        WHEN "1001111" =>  report("Led Lights 1, INST: "&inst);
        WHEN "0010010" =>  report("Led Lights 2, INST: "&inst);
        WHEN "0000110" =>  report("Led Lights 3, INST: "&inst);
        WHEN "1001100" =>  report("Led Lights 4, INST: "&inst);
        WHEN "0100100" =>  report("Led Lights 5, INST: "&inst);
        WHEN "0100000" =>  report("Led Lights 6, INST: "&inst);
        WHEN "0001111" =>  report("Led Lights 7, INST: "&inst);
        WHEN "0000000" =>  report("Led Lights 8, INST: "&inst);
        WHEN "0000100" =>  report("Led Lights 9, INST: "&inst);
        WHEN "0001000" =>  report("Led Lights A, INST: "&inst);
        WHEN "1100000" =>  report("Led Lights B, INST: "&inst);
        WHEN "0110001" =>  report("Led Lights C, INST: "&inst);
        WHEN "1000010" =>  report("Led Lights D, INST: "&inst);
        WHEN "0110000" =>  report("Led Lights E, INST: "&inst);
        WHEN "0111000" =>  report("Led Lights F, INST: "&inst);
        WHEN "0010000" =>  report("Led Lights G, INST: "&inst);
        WHEN "1101000" =>  report("Led Lights H, INST: "&inst);
        WHEN "0000111" =>  report("Led Lights I, INST: "&inst);
        WHEN "1000111" =>  report("Led Lights J, INST: "&inst);
        WHEN "1001000" =>  report("Led Lights K, INST: "&inst);
        WHEN "1110001" =>  report("Led Lights L, INST: "&inst);
        WHEN "1100010" =>  report("Led Lights O, INST: "&inst);
        WHEN "0001001" =>  report("Led Lights R, INST: "&inst);
        WHEN "1010101" =>  report("Led Lights W, INST: "&inst);
--        WHEN "0111000" =>  report("Led Lights M, INST: "&inst);
--        WHEN "0111000" =>  report("Led Lights N, INST: "&inst);
--        WHEN "0111000" => report("Led Lights P, INST: "&inst);
--        WHEN "0111000" => report("Led Lights Q, INST: "&inst);
--        WHEN "0111000" => report("Led Lights T, INST: "&inst);
--        WHEN "0111000" => report("Led Lights U, INST: "&inst);
--        WHEN "0111000" => report("Led Lights V, INST: "&inst);
--        WHEN "0111000" => report("Led Lights Y, INST: "&inst);
        WHEN OTHERS => report("Led Lights UNKNOWN, INST: "&inst);
  end case; 
  end process;
end behavioral;
