LIBRARY ieee;
USE ieee.std_logic_1164.ALL;

ENTITY pwm IS
  PORT(
     output : OUT std_logic
   );
END ENTITY pwm;

ARCHITECTURE spec OF pwm IS
BEGIN
       pulse_modulate : PROCESS IS
       CONSTANT period      : TIME := 60 us;
       CONSTANT duty_cycle1 : REAL := 0.7;
       CONSTANT duty_cycle2 : REAL := 0.3;
   BEGIN
       output <= '1';
       WAIT FOR period * duty_cycle1;
       output <= '0';
       WAIT FOR period * (1.0 - duty_cycle1);
       output <= '1';
       WAIT FOR period * duty_cycle2;
       output <= '0';
       WAIT FOR period * (1.0 - duty_cycle2);
   END PROCESS pulse_modulate;

END spec;
