-- ------------------------------------------------
-- Model        :   373 Latch
--
-- File         :   latch373.vhd
--
-- Author       :   Michael Mayer,
--                  Department of Electrical Engineering
--                  University of Missouri - Rolla
--
-- Date Started :   December 3, 1997 
--
-- Limitations  :  
--
-- Revisions    :
--
-- REV    DATE       Description
-- -----  --------   _____________________________________ 
--

LIBRARY ieee; 
USE ieee.std_logic_1164.ALL;


ENTITY latch373 IS
    PORT (
        D    : IN  std_logic_vector(7 DOWNTO 0);  -- used for data input
        Q    : OUT std_logic_vector(7 DOWNTO 0);  -- used for data input
        LE   : IN  std_logic;   -- latch enable
        OE_n : IN  std_logic   -- output enable (active low)
     );
END ENTITY latch373;

ARCHITECTURE behav OF latch373 IS
    SIGNAL latched_data : std_logic_vector(7 DOWNTO 0);
BEGIN
    latched_data <= to_X01(D) WHEN to_X01(LE) = '1'
                    ELSE UNAFFECTED;
    Q <= latched_data WHEN to_X01(OE_n) = '0'
                    ELSE (OTHERS=>'Z');
END;
    