-- Sayuri GNU Public Licence 32 bit CPU design/implementation
-- Sayuri 32 bit RISC
-- Copyright (C) 2000 Toyoaki Sagawa.
-- This program/design/implementation is a free software/hardware design 
-- (and all intellectual property therein); you can redistribute it and/or
-- modify it under the terms of the GNU General Public License
-- as published by the Free Software Foundation; either version 2
-- of the License, or (at your option) any later version.
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
-- GNU General Public License for more details.
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
-- USA.
-- Toyoaki Sagawa,
-- PXW07530@nifty.ne.jp
-- http://www.morphyplanning.co.jp/FreeCPU/freecpu-e.html
-- Postal 113-0034 Yusima, 4-11-16-808 Bunkyo, Tokyo, Japan

library IEEE;
use IEEE.std_logic_unsigned.all;
use IEEE.std_logic_1164.all;

entity ROM is
	generic( AW : integer := 8;
		     DW : integer := 32  );

	port( nRD, nCS : in std_logic;
		  	ADR : in std_logic_vector(AW-1 downto 0);
			DOUT : out std_logic_vector(DW-1 downto 0)
	);
end ROM;

architecture RTL of ROM is

subtype ROMWORD is std_logic_vector(DW - 1 downto 0);
type ROMARRAY is array ( 0 to 2**AW - 1) of ROMWORD;

signal ADR_IN : integer range 0 to 2**AW - 1 ;
signal ROMDATA : ROMARRAY :=(

-- set up code
To_StdLogicVector( X"D0_09_00_20"), -- IMM EJR 0x0020
To_StdLogicVector( X"D0_03_00_10"), -- IMM IPRET 0x0010
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
-- user mode code
To_StdLogicVector( X"D0_31_00_01"), -- Imm INC_BASE 0001 ; loop counter i.
To_StdLogicVector( X"D0_41_00_00"), -- Imm R1 0000 ; R1 is answer. 
To_StdLogicVector( X"D0_42_00_14"), -- Imm R2 0014 ; Loop Label
To_StdLogicVector( X"D0_13_00_0B"), -- Imm CMP_REGA 000B; Counter = 0x0B 
To_StdLogicVector( X"E0_0a_41_00"), -- MOV ALUBASE R1;    tmp = tmp + i; 
To_StdLogicVector( X"E0_0c_31_00"), -- MOV ALUADD INCBASE; 
To_StdLogicVector( X"E0_41_0b_00"), -- MOV R1 ALUOUT; 
To_StdLogicVector( X"E0_32_31_00"), -- MOV INC_BASE ++; 
To_StdLogicVector( X"E0_17_31_00"), -- MOV CMP_GT INC;  if i < 10 then loop 
To_StdLogicVector( X"E0_01_14_00"), -- MOV STAT CMP_OUT; 
To_StdLogicVector( X"A0_02_42_00"), -- Test&Mov IP R2; 
To_StdLogicVector( X"D0_04_80_00"), -- Imm DP 8000;    Store R1 to 8000h. 
To_StdLogicVector( X"E0_05_41_00"), -- Mov DD R1;     
To_StdLogicVector( X"E0_43_05_00"), -- Mov R3 DD;
To_StdLogicVector( X"D0_02_00_00"), -- JMP to TOP
To_StdLogicVector( X"E0_42_42_00"), -- NOP
-- interrupt code
To_StdLogicVector( X"D0_04_80_01"), -- Imm DP 8001
To_StdLogicVector( X"E0_05_08_00"), -- MOV DD EPR warikomi syori no tsumori
To_StdLogicVector( X"E0_03_08_00"), -- MOV IPRET EPR
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),

To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),

To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),

To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),

To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),

To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),

To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),

To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),

To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),

To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),

To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),

To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),

To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),

To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00"),
To_StdLogicVector( X"E0_42_42_00")

);
begin
	ADR_IN <= CONV_INTEGER(ADR);
	process (nCS, nRD, ADR_IN) begin
		if(nRD='0' and nCS='0') then
			DOUT <= ROMDATA(ADR_IN) after 3 ns;
		else
			DOUT <= (others => 'Z') after 4 ns;
		end if;
	end process;
end RTL;






