-- Sayuri GNU Public Licence 32 bit CPU design/implementation
-- Sayuri 32 bit RISC
-- Copyright (C) 2000 Toyoaki Sagawa.
-- This program/design/implementation is a free software/hardware design 
-- (and all intellectual property therein); you can redistribute it and/or
-- modify it under the terms of the GNU General Public License
-- as published by the Free Software Foundation; either version 2
-- of the License, or (at your option) any later version.
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
-- GNU General Public License for more details.
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
-- USA.
-- Toyoaki Sagawa,
-- PXW07530@nifty.ne.jp
-- http://www.morphyplanning.co.jp/FreeCPU/freecpu-e.html
-- Postal 113-0034 Yusima, 4-11-16-808 Bunkyo, Tokyo, Japan


-- 
-- Sayuri Simulation Module(RAM)
-- 2000/08/15 Rev1.0 Toyozou
-- 
-- do not use it for internal cash!
-- 

library IEEE;
use IEEE.std_logic_unsigned.all;
use IEEE.std_logic_1164.all;

entity SRAM is
	generic( AW : integer := 8;
		     DW : integer := 32  );

	port( nWR, nRD, nCS : in std_logic;
		ADR : in std_logic_vector(AW-1 downto 0);
		DIN : in std_logic_vector(DW-1 downto 0);
		DOUT : out std_logic_vector(DW-1 downto 0)
	);
end SRAM;

architecture RTL of SRAM is

subtype RAMWORD is std_logic_vector(DW - 1 downto 0);
type RAMARRAY is array ( 0 to 2**AW - 1) of RAMWORD;

signal RAMDATA : RAMARRAY;
signal ADR_IN : integer range 0 to 2**AW - 1 ;
signal innCS : std_logic;
signal innDD : RAMWORD;

begin
	innCS <= nCS after 2 ns;
	innDD <= DIN after 2 ns;
	ADR_IN <= CONV_INTEGER(ADR);
	process (nWR) begin
		if (nWR'event and nWR = '1') then
			if (innCS = '0') then
				RAMDATA(ADR_IN) <= innDD;
			end if;
		end if;
	end process;
	process (nCS, nRD, RAMDATA) begin
		if(nRD='0' and nCS='0') then
			DOUT <= RAMDATA(ADR_IN) after 3 ns;
		else
			DOUT <= (others => 'Z') after 4 ns;
		end if;
	end process;
end RTL;





