-- Sayuri GNU Public Licence 32 bit CPU design/implementation
-- Sayuri 32 bit RISC
-- Copyright (C) 2000 Toyoaki Sagawa.
-- This program/design/implementation is a free software/hardware design 
-- (and all intellectual property therein); you can redistribute it and/or
-- modify it under the terms of the GNU General Public License
-- as published by the Free Software Foundation; either version 2
-- of the License, or (at your option) any later version.
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
-- GNU General Public License for more details.
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
-- USA.
-- Toyoaki Sagawa,
-- PXW07530@nifty.ne.jp
-- http://www.morphyplanning.co.jp/FreeCPU/freecpu-e.html
-- Postal 113-0034 Yusima, 4-11-16-808 Bunkyo, Tokyo, Japan
-- 
-- 
-- Extrenal Chip selector
-- 2000/08/16 Rev.1.0 Toyozou
-- 
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;
use IEEE.std_logic_arith.all;

entity CHIPSEL is
    port (
	DMEMADD: in STD_LOGIC_VECTOR (31 downto 0);
	IMEMADD: in STD_LOGIC_VECTOR (31 downto 0);
        nDMEMCS,nIMEMCS: out STD_LOGIC
    );
end CHIPSEL;

architecture arch of CHIPSEL is
begin
	process(DMEMADD) begin
		if(DMEMADD(31 downto 8)="000000000000000010000000")then
			nDMEMCS <= '0';
		else
			nDMEMCS <= '1';
		end if;
	end process;
	process(IMEMADD) begin
		if(IMEMADD(31 downto 8)="000000000000000000000000")then
			nIMEMCS <= '0';
		else
			nIMEMCS <= '1';
		end if;
	end process;
end arch;





