-- Sayuri GNU Public Licence 32 bit CPU design/implementation
-- Sayuri 32 bit RISC
-- Copyright (C) 2000 Toyoaki Sagawa.
-- This program/design/implementation is a free software/hardware design 
-- (and all intellectual property therein); you can redistribute it and/or
-- modify it under the terms of the GNU General Public License
-- as published by the Free Software Foundation; either version 2
-- of the License, or (at your option) any later version.
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
-- GNU General Public License for more details.
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
-- USA.
-- Toyoaki Sagawa,
-- PXW07530@nifty.ne.jp
-- http://www.morphyplanning.co.jp/FreeCPU/freecpu-e.html
-- Postal 113-0034 Yusima, 4-11-16-808 Bunkyo, Tokyo, Japan

-- 
-- Sayuri Status register module
-- 2000/08/15 Rev.1.0 Toyozou
-- 
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;
use IEEE.std_logic_arith.all;

entity StatReg is
    port (
        DIN: in STD_LOGIC ;
        STATOUT: out STD_LOGIC;
        CLK: in STD_LOGIC;
        WE: in STD_LOGIC
    );
end StatReg;

architecture StatReg_arch of StatReg is
	signal REGA: std_logic;
begin

  process(REGA) begin
		STATOUT <= REGA;
  end process;

  process (CLK) begin
   if (CLK'event and CLK='1') then
	if( WE = '1' ) then
	  REGA <= DIN;
	end if;
   end if;
  end process;

end StatReg_arch;

