-- Sayuri GNU Public Licence 32 bit CPU design/implementation
-- Sayuri 32 bit RISC
-- Copyright (C) 2000 Toyoaki Sagawa.
-- This program/design/implementation is a free software/hardware design 
-- (and all intellectual property therein); you can redistribute it and/or
-- modify it under the terms of the GNU General Public License
-- as published by the Free Software Foundation; either version 2
-- of the License, or (at your option) any later version.
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
-- GNU General Public License for more details.
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
-- USA.
-- Toyoaki Sagawa,
-- PXW07530@nifty.ne.jp
-- http://www.morphyplanning.co.jp/FreeCPU/freecpu-e.html
-- Postal 113-0034 Yusima, 4-11-16-808 Bunkyo, Tokyo, Japan


-- 
-- Sayuri Kernel Mode/Interrupt All Mask register module
-- 2000/08/27 Rev.1.0 Toyozou
--

library IEEE;
use IEEE.std_logic_1164.all;

entity ModeReg is
    port (
	DIN: in STD_LOGIC_VECTOR(31 downto 0) ;
	DOUT: out STD_LOGIC_VECTOR(31 downto 0) ;
	MODEOUT: out STD_LOGIC;  -- kernel mode bit output for registers
	MASKOUT: out STD_LOGIC;  -- ALLMASK bit output for ECR register
	CLK: in STD_LOGIC;
	RESET: in STD_LOGIC;
	OE: in STD_LOGIC;
	WE: in STD_LOGIC;
	MODEON: in STD_LOGIC; -- interrupt routine in, from int state machine
	IPRETWE: in STD_LOGIC -- interrupt routine return, WE of IP+1 
    );
end ModeReg;

architecture ModeReg_arch of ModeReg is
	signal REGA: std_logic_vector(2 downto 0);
begin

  process(REGA, OE) begin
	MODEOUT <= REGA(0);
	MASKOUT <= REGA(1);
	if (OE='1')then
		DOUT <= (0=>REGA(0), 1=>REGA(1), 2=>REGA(2), others=>'0');
	else
		DOUT <=( others=>'0');
	end if;
  end process;

  process (CLK, RESET, MODEON, IPRETWE, WE) begin
	if (RESET ='0') then
		REGA <= "011" ;
	elsif (CLK'event and CLK='1') then
		if(MODEON ='1') then -- interrupt in. MODE=Kernel, allmask=1, push premode
			REGA(0) <= '1';
			REGA(1) <= '1';
			REGA(2) <= REGA(0);
		elsif(IPRETWE ='1') then -- interrupt return.
			REGA(0) <= REGA(2);
			REGA(1) <= '0';
			REGA(2) <= '0';
		elsif( WE = '1') then
			REGA(0) <= REGA(0); -- can't modify MODE
			REGA(1) <= ((not REGA(0)) and REGA(1)) or (REGA(0) and DIN(1)); 
			REGA(2) <= ((not REGA(0)) and REGA(2)) or (REGA(0) and DIN(2)); 
			-- selector logic. REGA(0)=MODE=1, can be written
		else
			REGA <= REGA;
		end if;
	end if;
  end process;

end ModeReg_arch;













