-- Sayuri GNU Public Licence 32 bit CPU design/implementation
-- Sayuri 32 bit RISC
-- Copyright (C) 2000 Toyoaki Sagawa.
-- This program/design/implementation is a free software/hardware design 
-- (and all intellectual property therein); you can redistribute it and/or
-- modify it under the terms of the GNU General Public License
-- as published by the Free Software Foundation; either version 2
-- of the License, or (at your option) any later version.
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
-- GNU General Public License for more details.
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
-- USA.
-- Toyoaki Sagawa,
-- PXW07530@nifty.ne.jp
-- http://www.morphyplanning.co.jp/FreeCPU/freecpu-e.html
-- Postal 113-0034 Yusima, 4-11-16-808 Bunkyo, Tokyo, Japan

-- 
-- Sayuri IP module
-- 2000/08/15 Rev.1.0 Toyozou
-- 
-- 08/20 output is '0' when not selected

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;
-- use IEEE.std_logic_arith.all;

entity IP is
    port (
	DIN: in STD_LOGIC_VECTOR (31 downto 0);
	DOUT: out STD_LOGIC_VECTOR (31 downto 0);
	CLK: in STD_LOGIC;
	RESET: in STD_LOGIC; -- if 0, set IPREG 0
	COUNTEN: in STD_LOGIC; -- if 1, IP Count UP
	WE: in STD_LOGIC;
	OE: in STD_LOGIC;
	MEMA: out STD_LOGIC_VECTOR (31 downto 0)
    );
end IP;

architecture IP_arch of IP is
	signal IPREG : std_logic_vector(31 downto 0);
begin
  MEMA <= IPREG;
  process(OE, IPREG) begin
	if (OE = '0') then
		DOUT <= (others => '0');
	else
		DOUT <= IPREG;
	end if;
  end process;

  process (CLK) begin
    if(RESET ='0')then
		IPREG <= (others =>'0');
    elsif (CLK'event and CLK='1') then
		if( WE = '1' ) then
			IPREG <= DIN;
		elsif (COUNTEN ='1') then
			IPREG <= IPREG + '1';
		end if;
   end if;
  end process;

end IP_arch;





