


// Localizers: please translate the strings found between the double quotes

//Errors and warnings
var ERR_WIN_ONLY = "This installer is not designed for a non-windows platform.  Please locate the correct installer.  Exiting.";
var ERR_JAVA_IS_OFF = "You do not have java turned on, please enable Java, restart, and try again";
var ERR_AUTOINSTALL_IS_OFF = "AutoInstall is not turned on in Advanced Preferences, please enable it, restart, and try again" ;
var ERR_NOT_FOR_THIS_OS = "Sorry, the install you are downloading doesn't support your operating system.  Install will not continue";
var ERR_210_INSTALL_CANCELLED = "Install cancelled! Exiting installation..." ;
var ERR_201_NOT_GRANTED = "Privileges not granted, Exiting..." ;
var ERR_200_BAD_PACK_NAME = "ERROR! Incorrect / Bad install package name.  Exiting..." ;
var ERR_202_ACCESS_DENIED = "ERROR! Access denied.  Cannot write to system.  Exiting..." ;
var ERR_203_TOO_MANY_CERTS = "ERROR! Too many certificates, only 1 is allowed. Exiting..." ;
var ERR_204_NO_CERTS = "ERROR! No installer certificate found! Exiting...";
var ERR_205_FILE_NOT_SIGNED = "ERROR! Extracted file is not signed. Exiting..." ;
var ERR_206_FILE_NOT_CERTS = "ERROR! Extracted file does not match installer certificate. Exiting..." ;
var ERR_207_JAR_NOT_OPENED = "ERROR! Jar file hasn't been opened/found. Exiting..." ;
var ERR_208_BAD_ARGS_TO_FUNC = "ERROR! Error calling function (bad arguments). Exiting..." ;
var ERR_209_BAD_PATH = "ERROR! Illegal relative path to destination. Exiting..." ;
var ERR_211_INSTALL_WONT_START = "ERROR! Install never started. Exiting..." ;
var ERR_20_CANT_SETUP_FILES = "ERROR, trying to setupFiles." ;
var ERR_1_CANT_ADD_COMP = "ERROR, Adding components to the install." ;
var ERR_2_NOT_APPROVED = "ERROR: Install not approved.  Exiting..." ;
var ERR_3_WIN32_ONLY = "ERROR: This installer is for 32 bit Windows only.  Exiting..." ;
var ERR_GENERIC_INSTALL_ERR = "an install error has occurred. Exiting..." ;
var ERR_ABORT_WITH_ERRNO = "ABORT! Installer error: ";
var ERR_999_FILES_IN_USE = "<FONT SIZE=+1 COLOR=#990000><i>WARNING!</FONT>  Some of the files are in use, you will have to restart your computer after installing your software.</i>" ;



// Take care of the embedded HTML in the following string
var WARN_999_MUST_RESTART = "<FONT SIZE=+1 COLOR=#990000><i>WARNING!</FONT>  Some of the files are in use, you will have to restart your computer after installing your software.</i>" ;

//Note: CheckLang will currently only handle English.  What happens to the script when
//we support Int'l?
var ERR_NEED_COM4_ENGLISH = "Sorry, you must have Communicator 4.0 in English in order to upgrade.  Install will not continue" ;
var STATUS_PLEASE_WAIT = "Please Wait..." ;

//Font face and size for status updates.  Note the single quotes inside the string
// for font face; this is essential.
var PARAM_FONT_FACE = "'Arial, Helvetica'" ;
var PARAM_FONT_SIZE = 5 ;
var PARAM_FONT_SIZE_FOR_UPDATE = 4;

var PARAM_LANG_FOR_SCRIPT = "en";


// ###### END OF SHARED LOCALIZABLE TEXT #########


// Localizers: please translate the strings found between the double quotes

//Errors and warnings
var DBG_NO_SUBKEY = "error setting creating key for " ;
var DBG_SET_WINREGVALUE = "error setting winreg value for " ;
var DBG_VI_EQUALS = "vi equals: " ;

var TEXT_REFLECTINSTALLDIR = "CosmoPlayer will be installed to: " ;
var TEXT_PICKWHERETOINSTALL = "Please Pick where you would like to install Cosmo Player in the Directory window." ;
var TEXT_ORGANIZING_INSTALL = "Organizing Installation Components..." ;
var TEXT_ADDING_FILENUM = "Adding file number: "  ;
var INFO_ADDFILESTR = "Adding file number : {0} to the install: {1} " ;
var TEXT_TO_INSTALL = " to the install: " ;
var TEXT_ERR_ADDINGFILE = "Error adding " ;
var TEXT_WRONG_COMM_VER = "You do not have the correct version of communicator (4.02), exiting the installer" ;
var TEXT_ALREADY_HAVEIT = "You already have a version of 4.05 on your system, do you wish to continue?" ;
var TEXT_CLICK_GRANT = "Click 'grant' if you are asked to approve the installation in the Java Security dialog." ;
var TEXT_NONEWSUOBJ = "Failed to create new softupdate obj." ;
var TEXT_CHECKINGSYSTEM = "Checking your system environment..." ;
var TEXT_SETTINGUP_FILES = "Setting up files for the install..." ;
var TEXT_SETTINGUP_REST = "Setting up the rest of the install..." ;
var TEXT_READYING_FILES = "Readying files.  Please click 'Install' or 'Cancel' to abort in the SmartUpdate window..." ;
var TEXT_INSTALL_COMPLETED = "INSTALL COMPLETED SUCCESSFULLY!" ;
var TEXT_TOPWINDOW_TITLE = "Cosmo Software CosmoPlayer Installer" ;
var TEXT_UPDATEOBJ_NAME = "Upgrade Installer" ;
var TEXT_DEFAULT_TEXT = "Starting the install..." ;


//Errors and warnings
var ERR_NEED_SPECIFIC_VERSION_1 = "This installer requires Communicator 4.04 or later which you are not running.";
var ERR_NEED_SPECIFIC_VERSION_2 = "If you are running a previous version of communicator, you can upgrade to 4.04 easily...";
var ERR_NEED_SPECIFIC_VERSION_3 = "By choosing the HELP | SOFTWARE UPDATES menu.";
var ERR_NEED_SPECIFIC_VERSION_4 = "This install will exit now.";
var ERR_FAILED_TO_CREATE_OBJ = "Failed to create new softupdate obj.";

//Status Messages
var STATUS_ORGANIZING_FILES = "Organizing Installation Components...";
var STATUS_SETTING_UP_FILES = "Setting up files for the install...";
var STATUS_REST_OF_INSTALL = "Setting up the rest of the install...";
var STATUS_CHECKING_ENVIRONMENT = "Checking your system environment...";
var STATUS_OPENING_INFO_FILE = "Opening information file, please wait...";
var STATUS_STARTING_INSTALL = "Starting the install...";


var INSTRUCTION_GRANT_PRIVILEDGE = "Checking install privileges.  Click 'grant' if you are asked to approve the installation in the Java Security dialog.";
var INSTRUCTION_INSTALL_OR_CANCEL = "Readying files.  Please click 'Install' or 'Cancel' to abort in the SmartUpdate window...";
var INSTRUCTION_PLEASE_WAIT = "please wait...";

var WINDOW_TITLE_INFO_FILE = "informationWindow";

var FORMAT_STRING_ADDING_FILE = "Adding file number: %0 to the install: %1";
var FORMAT_STRING_ERROR_ADDING_FILE = "Error adding %0 to the install...";

// Take care of the embedded HTML in the following strings
var HTML_INSTRUCTIONS_WINDOW_TITLE = "<HTML><HEAD><META HTTP-EQUIV='Content-Type' CONTENT='text/html; charset=iso-8859-1'><TITLE>Navigator Install Information</TITLE></HEAD>";
var HTML_INSTRUCTIONS_TITLE = "<BODY><CENTER><H2><FONT COLOR='#CC0000'><FONTSIZE=+3>Installation Stopped</FONT></FONT></H2></CENTER>";


var HTML_INSTRUCTIONS_1 = "We're sorry but this SmartUpdate is unable to automatically update all the files to your Communicator installation." ;
var HTML_INSTRUCTIONS_2 = "You will need to copy over some files manually to complete the install.  Please print out the following instructions on how to upgrade your version of Communicator.";
var HTML_INSTRUCTIONS_3 = "Your copy of Communicator has not been changed as a result of running this Update.";
var HTML_INSTRUCTIONS_4 = "Print out this page, for viewing outside of Communicator.";
var HTML_INSTRUCTIONS_5 = "Quit Communicator.";

// Please note these are dynamically generated strings that contain file path names
var FORMAT_STRING_HTML_INSTRUCTIONS_6 = "Copy %0install\\*.* to %1";
var FORMAT_STRING_HTML_INSTRUCTIONS_7 = "Copy %0java\\bin\\install\\*.* to %1java\\BIN\\";
var FORMAT_STRING_HTML_INSTRUCTIONS_8 = "Copy the entire contents of %0java\\classes\\install\\ to %1java\\classes\\";

var HTML_INSTRUCTIONS_9 = "You can now remove the \\install directories mentioned above and restart Communicator.";
var HTML_INSTRUCTIONS_10 = "Sorry for the inconvenience.  ";


var INSTALLER_WELCOME = "Welcome to the installer.";
var SPECIFIC_PRODUCT_WELCOME = "Welcome to the JDK 1.1 Patch Installer";

var TEXT_ADDING_AIM = "Please wait - adding the Instant Messanger component." ;
var TEXT_DONE_ADDING_AIM = "Finished downloading Instant Message Component.  Launching Install." ;
var TEXT_AIM_LAUNCHED = "Finished launching Instant Message Component.  Launching Install." ;


// #### CODE FOLLOWS.  DO NOT LOCALIZE BELOW THIS LINE!!

// Displays a message only when debugging.


// StrBuilder Utility Class
// *************************
// The function below takes a Win32-style format string and converts it to
// a JavaScript object that contains a table that can very efficiently
// be processed into a formatted string.
//
// Ex:  
// var objRef = new StrBuilder("One is %0, Two is %1, and %2%%");
//
// The objRef can then be used with the BuildString function to build a
// formatted string:
//
// var formattedString = BuildString(objRef,"Uno","Dos",100);
//
// formattedString will be "One is Uno, Two is Dos, and 100%"
//
// Note that the order in the format string can be switched, and BuildString
// will still correctly build the string:
// var objRef2 = new StrBuilder("%2%%: Ithnen hu %1, Wa Wahad hu %0");
// formattedString = BuildString(objRef,"Uno","Dos",100);
//
// Here, formattedString will now be "100%: Ithnen hu Dos, Wa Wahad hu Uno"
//

// Put the following two function definitions into your common functions file or
// headers:

//
// Function StrBuilder: constructor for Win32 style formatter
//
function StrBuilder(fmtStr){

	this.table = new Array(); // Initialize some class variables
	this.valid = true;
	this.numSlots = 1;
	
	var curPosit = 0; // local variables
	var rslt = 0, num, slotNum = 0;
	var nextChar ;
	
	// Now walk the format string, placing the components of the string
	// into the this.table array.  The %0, %1, etc. arguments are stored
	// as a numerical index.  Anything else is stored as a string, including
	// the argument '%%', which resolves to "%"
	while (rslt != -1){
		// Look for a % from current position
		rslt = fmtStr.indexOf("%",curPosit); 
		
		if(rslt == -1) //If % not found, dump the end of the string to a slot
			 this.table[slotNum] = fmtStr.substring(fmtStr.length,curPosit);
			 
		else if ((nextChar = fmtStr.charAt(rslt+1)) == "%"){ // Check for '%%'
			this.table[slotNum++] = fmtStr.substring(rslt,curPosit);
			this.table[slotNum++] = "%";
			curPosit = rslt + 2; 
		}
		 else{ //Either something we can't handle... 
			num = parseInt(nextChar);
			if (isNaN(num) || num > 9){ //Only a number or a % may follow a %
					this.valid = false;
					return this;
			  }
			  else{	// or it's a digit from 0 to 9, which we store as an index
				this.table[slotNum++] = fmtStr.substring(rslt,curPosit);
				this.table[slotNum++] = num;
				curPosit = rslt + 2; 
			}
		}
	}
	this.numSlots = slotNum + 1;
	return this;
}

//
// Function BuildString: uses a StrBuilder object to dynamically format a string.
// 
// Note: you may have up to 10 arguments after strbldr.  The first will correspond
// to %0, the second to %1, up to %9, and will be substituted for these tokens
// as were passed to StrBuilder.
//
function BuildString(strbldr, itemList){
	var thisSlot, slotVal, thisType, thisArg ;
	var theStr = "";
	
	// For now, we return something that looks invalid if strbldr is not a
	// StrBuilder object:
	if (!strbldr.valid)
		return "<INVALID>";

	// Now walk the slots.  If a string, concatenate it.  If a number,
	// check the argument list for BuildString and substitute the i+1
	// argument.  Note that if we ask for too high an arg, we add nothing
	// to the string in that position	
	for(var i = 0; i < strbldr.numSlots; i++){
		thisSlot = strbldr.table[i];
		thisType = typeof thisSlot; //check to see if we have a numerical index
		slotVal = parseInt(thisSlot);
		
		if(thisType != "number") // not an index, so just concatenate the slot
			theStr += thisSlot;
		// ELSE: substitute in an argument from BuildString's argument list
		else if (slotVal < BuildString.arguments.length - 1){
			thisArg = BuildString.arguments[slotVal + 1];
			theStr += thisArg;
		}
	}			
	return theStr;
}


/* 
 * This function takes a JS Array and converts it into a Java 
 * array of Objects.
 */
function JSArrayToJArray(objects) {
   // As a little trick here, we create a Java Object and
   // then use it to get a class to pass to java...Array.newInstance
   // In this manner, we can create and populate a Java array
   tobj = new java.lang.Object()
   JArray = java.lang.reflect.Array.newInstance(tobj.getClass(), objects.length)

   for(i = 0 ; i < objects.length ; i++) {
      if(typeof objects[i] == "string") {
	java.lang.reflect.Array.set(JArray, i, objects[i])
      }
      // Otherwise assume it's a Calendar object for either date/time
      else {
	tempJDate = new java.util.Date(objects[i].getTime())
	java.lang.reflect.Array.set(JArray, i, tempJDate)
      }
   }
   return(JArray)
}

/* 
 * SimpleMessageFormat is appropriate for if you are only going to format 
 * a string a few times.  It takes a 
 * pattern string, and array of JS objects to use while formatting.
 */
function SimpleMessageFormat(patternstring, objects) {
   JArray = JSArrayToJArray(objects)
   return(java.text.MessageFormat.format(patternstring, JArray))
}


function dbgMsg(message) 
	{
	if(debugOutput)
      java.lang.System.out.println(message) ;
	}


function checkJava() 
	{
	javaOn = navigator.javaEnabled() ; //check to see if java is enabled - nothing here works without it.
	if (javaOn == false)
		{
		alert(ERR_JAVA_IS_OFF) ; // Restart with Java please!
		return false ;
		}
	return true ;
	} 

function checkASD() 
	{
	SUEnabled = netscape.softupdate.Trigger.UpdateEnabled() ;  // SmartUpdate won't work without it being on.
	if (SUEnabled == false)
		{
		alert(ERR_AUTOINSTALL_IS_OFF) ;
		return false ;
		}
	return true ;
	} 


function verifyOS(val) // val should be a string 16, 32, or PPC, etc.  You can verify that the OS matches the OS of the intended install software
	{
	OS = navigator.platform ;
	i = OS.indexOf(val) ;
	if ( i == -1)  
		{
		alert(ERR_NOT_FOR_THIS_OS) // Package not for this OS!;
		return false ;
		}
	return true ;
	} 


function checkLang()  // you can probably modify this function to check for the language like we check for OS, but for now, it just verifies English.
	{

	if (navigator.language != PARAM_LANG_FOR_SCRIPT)
		{
		alert(ERR_NEED_COM4_ENGLISH) ;
		return false ;
		}
	return true ;
	}


//this is an object that contains fields for information about all aspects of the files we want to install.
//later we create an array of these objects depending on the number of files we have to install.
//Later still, we populate the array - filling in the data.
//Lastly, we chug through the array when we are installing the files, extracting the data as we go.
function fileInfoObject(fileName, regFilePath, fileVersion, fileSourcePath, fileDestFolder, fileLocalPath, fileForceStatus ) 
	{
	this.fileName = fileName ;		//convenience sake name
	this.regFilePath = regFilePath ;  //registry name/path 
	this.fileVersion = fileVersion ;  //what version you need this file to be
	this.fileSourcePath = fileSourcePath ; //where in the .jar file is this coming from
	this.fileDestFolder = fileDestFolder ; // where on the drive is this going to (folderspec obj)
	this.fileLocalPath = fileLocalPath ; // any change from the folderspec obj (subfolders?)
	this.fileForceStatus = fileForceStatus ; // determines whether we pay attention to windows versioning or not.
	}


//this function sets up a UI environment which you can alter and/or use to inform the user of what's happening during the install.
function setupWindows()  
	{
// just for clienteng release
//        wndw= window.open("","installer","toolbar=0,menubar=0,status=0,directories=0,location=0,scrollbars=0,resizable=0,width=480,height=400,top=50,left=100");
		wndw= open("","installer","toolbar=0,menubar=0,status=0,directories=0,location=0,scrollbars=0,resizable=0,width=480,height=400,top=50,left=100");
					     // get the users' screen size
        ScreenSize();	 // another object made by us (See Below).
        wndw.moveTo(width/2-250, height/2-200);          //center the window now that we know the dims.
        wndw.document.open("text/html");  				 //open a window that has the text/html mime type.
        wndw.document.close() ;  // flush to window.
        wndw.document.write("<TITLE>"+topWindowTitle+"</TITLE><center><br><br><h2>"+STATUS_PLEASE_WAIT+"</h2></center>") ;
		wndw.document.close() ;  // flush to window.		
		// WRITE OUT THE HTML TO THE WINDOW, CREATING THE FRAMESET
		line = "<TITLE>"+topWindowTitle+"</TITLE><FRAMESET ROWS='30%, 40%, *' border=0 frameborder='no' marginwidth=0><FRAME SRC='about:blank' NAME='TOP'> <FRAME SRC='about:blank' NAME='MIDDLE'> <FRAME SRC='about:blank' NAME='BOTTOM'></FRAMESET>" ;
        wndw.document.write(line);
        wndw.document.close() ;  // flush to window.

// an effort to clean the window of background info.

wndw.frames[0].document.write("<center><br><br><h3>"+STATUS_PLEASE_WAIT+"</h3></center>") ;
wndw.frames[0].document.close() ;  //clean the window first.

wndw.frames[1].document.write("<center><br><br><h3>"+STATUS_PLEASE_WAIT+"</h3></center>") ;
wndw.frames[1].document.close() ;  //clean the window first.

wndw.frames[2].document.write("<center><br><br><h3>"+STATUS_PLEASE_WAIT+"</h3></center>") ;
wndw.frames[2].document.close() ;  //clean the window first.

		line="<HTML><BODY><CENTER><IMG SRC=http://home.netscape.com/inserts/images/n_sm.gif><H3>"+topWindowTitle+"</H3></CENTER></BODY></HTML>";
        wndw.frames[0].document.close() ;  //clean the window first.
        wndw.frames[0].document.write(line) ;

		// updateStatusText(hSize, defaultText, 3, false, "normal") ;// RMT
		updateStatusText("", defaultText, 3, false, "normal") ;
	}


//This function gives us a delay mechanism which isn't built into javascript natively.  
//It's useful and simple.
function delay(amount) {
	// init the values
	var time = new Date() ;
	var seconds = time.getSeconds() ;
	var startCount = 80 ;
	var newSeconds = 70 ;
	//-------------------
	startCount = (seconds + amount ) % 60 ;
	time = new Date() ;
	newSeconds = time.getSeconds() ;
	while (newSeconds != startCount ) {
		time = new Date() ;
		newSeconds = time.getSeconds() ;
		}
 }


// figure out what the users' screen size is so that we can always put the install window in the beginning.
function ScreenSize()
	{
      if (navigator.javaEnabled())    // if Enable Java checkbox is checked then we can do the rest...
      {
         var tools=java.awt.Toolkit.getDefaultToolkit(); // tools object now exists and we can use 'em
         var size=tools.getScreenSize();	// Identify the users' screen size.
         width=size.width;					//on-the-fly declaration of global variable width
         height=size.height;				//on-the-fly declaration of global variable height
      }
	}


//this function updates the text in the middle frame of the window that was previously set up in 'setupwindows' function.
//You can pass it a font size, text, how long you want the message to be displayed, and flip flop between error and success 
//graphic states which you can define ahead of time.  The graphics show in the lower frame.
function updateStatusText(hSize, text, delayTime, graphic )
{
//check to see if the window is closed, if it is, re-open it.
//dbgMsg("value for barf is: " + wndw.closed) ;
if (wndw.closed)
	{
	alert ("Please do not close the information window until the install is complete.") ;
	setupWindows() ;
	}
	var defaultSize = PARAM_FONT_SIZE_FOR_UPDATE ;    //default size for status window messages text.
	if (hSize == "")
		hSize = defaultSize ;

	if (debugOutput == true) 
		{
		java.lang.System.out.println(text) ;		
		}

	if (!silentValue) 
		{
		wndw.frames[0].document.bgColor="white" ;
		wndw.frames[1].document.bgColor="white" ;
		wndw.frames[2].document.bgColor="white" ;
		wndw.frames[1].document.close() ;
		line="<HTML><BODY><SCRIPT>document.bgColor='white'</SCRIPT><CENTER><FONT FACE="+PARAM_FONT_FACE+" SIZE="+PARAM_FONT_SIZE+"5 COLOR=BLUE><BR><H"+hSize+">"+text+"</H"+hSize+"><BR></CENTER></BODY></HTML>";
		wndw.frames[1].document.close() ;  //clean the window first.
		wndw.frames[1].document.write(line) ;
		wndw.frames[1].document.close() ;  //clean the window first.
		
		if (graphic != "") 
			{
   	    	if (graphic == "error")
				{
    	        line="<HTML><BODY><SCRIPT>document.bgColor='white'</SCRIPT><CENTER><IMG HEIGHT=100 SRC=http://home.netscape.com/download/images/mozilla_bungee.gif></CENTER></BODY></HTML>" ;
	   	    	wndw.frames[2].document.close() ;  //clean the window first.
		        wndw.frames[2].document.write(line) ;
		        wndw.frames[2].document.close() ;  //clean the window first.
				}
   			else
			if (graphic == "normal")
				{
	            line="<HTML><BODY><SCRIPT>document.bgColor='white'</SCRIPT><CENTER><IMG WIDTH=360 SRC=http://home.netscape.com/download/images/mozilla_hurdles.gif></CENTER></BODY></HTML>" ;
	   	    	wndw.frames[2].document.close() ;  //clean the window first.
		        wndw.frames[2].document.write(line) ;
		        wndw.frames[2].document.close() ;  //clean the window first.
				}
    		}
		
		if (delayTime != 0)	delay(delayTime) ; 
		}

}




//Call this function ifyou want to bail out of the installer.
function abortMe() {
			// check here for what the error numbers are.
			//if 999 then reset to zero and do nothing. Otherwise, proceed with abort.
			//999 is when files are in use.  Everything is pretty much correct if you get a 999.
			if (err!=999)  
				{
				java.lang.System.out.println(ERR_ABORT_WITH_ERRNO + err) ;
				if (!silentValue) { 
					wndw.close() ;
					}
				su.AbortInstall() ;
				errorFlag = true ;
				return ;
				}
			else 
				{
				err = 0
				return ;
				}
}


//if you get an error, you cancall this function to parse it.
function errorParse(err) {
	switch (err) {
		case -210 :
			updateStatusText(4, ERR_210_INSTALL_CANCELLED, 5, "error") ;
			break ;
		case -201 :
			updateStatusText(4, ERR_201_NOT_GRANTED, 5, "error") ;
			break ;
		case -200 :
			updateStatusText(4, ERR_200_BAD_PACK_NAME, 5, "error") ;
			break ;
		case -202 :
			updateStatusText(4, ERR_202_ACCESS_DENIED, 5, "error") ;
			break ;
		case -203 :
			updateStatusText(4, ERR_203_TOO_MANY_CERTS, 5, "error") ;
			break ;
		case -204 :
			updateStatusText(4, ERR_204_NO_CERTS) ;
			break ;
		case -205 :
			updateStatusText(4, ERR_205_FILE_NOT_SIGNED, 5, "error") ;
			break ;
		case -206 :
			updateStatusText(4, ERR_206_FILE_NOT_CERTS, 5, "error") ;
			break ;
		case -207 :
			updateStatusText(4, ERR_207_JAR_NOT_OPENED, 5, "error") ;
			break ;
		case -208 :
			updateStatusText(4, ERR_208_BAD_ARGS_TO_FUNC, 5, "error") ;
			break ;
		case -209 :
			updateStatusText(4, ERR_209_BAD_PATH, 5, "error") ;
			break ;
		case -211 :
			updateStatusText(4, ERR_211_INSTALL_WONT_START, 5, "error") ;
			break ;
		case -20 :
			updateStatusText(4, ERR_20_CANT_SETUP_FILES, 4, "error") ;
			break ;
		case -1 :
			updateStatusText(4, ERR_1_CANT_ADD_COMP, 4, "error") ;
			break ;
		case -2 :
			updateStatusText(4, ERR_2_NOT_APPROVED, 4, "error") ;
			break ;
		case -3 :
			updateStatusText(4, ERR_3_WIN32_ONLY, 4, "error") ;
			break ;
		case 999 :
			updateStatusText(4, ERR_999_FILES_IN_USE, 6, "normal") ;
			break ;

		default :
			updateStatusText(4, ERR_GENERIC_INSTALL_ERR, 5, "error") ;
		} //endswitch
} //end errorParse

//*************************** END OF HEADER FILE ****************************

function updateRegistry() 
{
//fWindows = su.GetFolder("Windows") ;
//fProgram = su.GetFolder("Program") ;
//fJavaBin = su.GetFolder("Netscape Java Bin") ;

//NOTE need to extract installdir before installing product.

//COSMO SETTINGS FOR WINREGISTRY
	//create Local machine key
			var winreg = su.GetWinRegistry() ;
			winreg.setRootKey(winreg.HKEY_LOCAL_MACHINE) ;  // LOCAL_MACHINE
			subkey = "SOFTWARE\\CosmoSoftware\\CosmoPlayer\\2.0" ;
			err = winreg.createKey(subkey,"") ;  //create the above keyif it doesn't exist.
			if (err !=0) {
				updateStatusText(hSize, "Error setting " +valname + " in Windows registry at " +subkey, 4, "error") ;
				return err ;
				}																								  
//current version key
			subkey = "SOFTWARE\\CosmoSoftware\\CosmoPlayer" ;
			valname = "CurrentVersion" ;
			value = "2.0" ;
			err = winreg.setValueString(subkey, valname, value) ;
			if (err !=0) {
				updateStatusText(hSize, "Error setting " +valname + " in Windows registry at " +subkey, 4, "error") ;
				return err ;
				}
//current version key
			subkey = "SOFTWARE\\CosmoSoftware\\CosmoPlayer\\2.0" ;
			valname = "ChangeNumber" ;
			value = "27191" ;
			err = winreg.setValueString(subkey, valname, value) ;
			if (err !=0) {
				updateStatusText(hSize, "Error setting " +valname + " in Windows registry at " +subkey, 4, "error") ;
				return err ;
				}
//current version key
			subkey = "SOFTWARE\\CosmoSoftware\\CosmoPlayer\\2.0" ;
			valname = "DOC_DIR" ;
			value = fUserPick + "CosmoSoftware\\CosmoPlayer\\doc\\" ;
			dbgMsg("registry value is: " + value) ;
			err = winreg.setValueString(subkey, valname, value) ;
			if (err !=0) {
				updateStatusText(hSize, "Error setting " +valname + " in Windows registry at " +subkey, 4, "error") ;
				return err ;
				}

//current version key
			subkey = "SOFTWARE\\CosmoSoftware\\CosmoPlayer\\2.0" ;
			valname = "InstallDir" ;
			value = fUserPick + "CosmoSoftware\\CosmoPlayer\\" ;
			dbgMsg("registry value is: " + value) ;
			err = winreg.setValueString(subkey, valname, value) ;
			if (err !=0) {
				updateStatusText(hSize, "Error setting " +valname + " in Windows registry at " +subkey, 4, "error") ;
				return err ;
				}

//current version key
			subkey = "SOFTWARE\\CosmoSoftware\\CosmoPlayer\\2.0" ;
			valname = "PROTOS_FILE" ;
			value = fUserPick + "CosmoSoftware\\CosmoPlayer\\defaultProtos.wrl" ;
			dbgMsg("registry value is: " + value) ;
			err = winreg.setValueString(subkey, valname, value) ;
			if (err !=0) {
				updateStatusText(hSize, "Error setting " +valname + " in Windows registry at " +subkey, 4, "error") ;
				return err ;
				}

winreg.setRootKey(winreg.HKEY_CURRENT_USER) ;  // CURRENT_USER

			subkey = "SOFTWARE\\CosmoSoftware\\CosmoPlayer" ;
			err = winreg.createKey(subkey,"") ;  //create the above keyif it doesn't exist.
			if (err !=0) {
				updateStatusText(hSize, "Error setting " +valname + " in Windows registry at " +subkey, 4, "error") ;
				return err ;
				}																			
//current USER key
			valname = "Platform Checked" ;
			value = "0x0" ;
			err = winreg.setValueString(subkey, valname, value) ;
			if (err !=0) {
				updateStatusText(hSize, "Error setting " +valname + " in Windows registry at " +subkey, 4, "error") ;
				return err ;
				}

winreg.setRootKey(winreg.HKEY_CLASSES_ROOT) ;  // CLASSES_ROOT

			subkey = "SGI.CosmoPlayer.1\\DefaultIcon" ;
			err = winreg.createKey(subkey,"") ;  //create the above keyif it doesn't exist.
			if (err !=0) {
				updateStatusText(hSize, "Error setting " +valname + " in Windows registry at " +subkey, 4, "error") ;
				return err ;
				}																			
//current CLASSES_ROOT
			valname = "(default)" ;
			value = fUserPick + "CosmoSoftware\\CosmoPlayer\\doc\\Icon.ico" ;
			err = winreg.setValueString(subkey, valname, value) ;
			if (err !=0) {
				updateStatusText(hSize, "Error setting " +valname + " in Windows registry at " +subkey, 4, "error") ;
				return err ;
				}

//current CLASSES_ROOT
			subkey = "SGI.CosmoPlayer.1\\shell\\open\\command\\" ;
			err = winreg.createKey(subkey,"") ;  //create the above keyif it doesn't exist.
			if (err !=0) {
				updateStatusText(hSize, "Error setting " +valname + " in Windows registry at " +subkey, 4, "error") ;
				return err ;
				}																			
//current CLASSES_ROOT
			valname = "(default)" ;
			value = fProgram + "netscape.exe %1" ;
			err = winreg.setValueString(subkey, valname, value) ;
			if (err !=0) {
				updateStatusText(hSize, "Error setting " +valname + " in Windows registry at " +subkey, 4, "error") ;
				return err ;
				}

//WRL ASSOCIATION
			subkey = ".wrl" ;
			err = winreg.createKey(subkey,"") ;  //create the above keyif it doesn't exist.
			if (err !=0) {
				updateStatusText(hSize, "Error setting " +valname + " in Windows registry at " +subkey, 4, "error") ;
				return err ;
				}																			

			valname = "(default)" ;
			value = "SGI.CosmoPlayer.1" ;
			err = winreg.setValueString(subkey, valname, value) ;
			if (err !=0) {
				updateStatusText(hSize, "Error setting " +valname + " in Windows registry at " +subkey, 4, "error") ;
				return err ;
				}
			subkey = ".wrz" ;
			valname = "(default)" ;
			value = "SGI.CosmoPlayer.1" ;
			err = winreg.setValueString(subkey, valname, value) ;
			if (err !=0) {
				updateStatusText(hSize, "Error setting " +valname + " in Windows registry at " +subkey, 4, "error") ;
				return err ;
				}
// Jim Says don't do the .gzip association change.
//			subkey = ".gz" ;
//			valname = "(default)" ;
//			value = "SGI.CosmoPlayer.1" ;
//			err = winreg.setValueString(subkey, valname, value) ;
//			if (err !=0) {
//				updateStatusText(hSize, "Error setting " +valname + " in Windows registry at " +subkey, 4, "error") ;
//				return err ;
//				}

winreg.setRootKey(winreg.HKEY_LOCAL_MACHINE) ;  // LOCAL_MACHINE
subkey = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\SharedDlls" ;
//valname = fWinSystem + "\cp_axucp.dll" ;

//value = 1 ;
//cp_axucp.dll
//cm_dshow10.dll
//err = winreg.setValueString(subkey, valname, value) ;
//test = winreg.getValueString(subkey, valname) ;
//winreg.getValue

//test = winreg.getValue

  //if (test.type == dword little endian, (4)
//  		(this value is .data type which is a byte array)
//  4 bytes long

//dbgMsg("Value for msvcrt40.dll in Winregistry shared dll counter is: " + test) ;



return err ;

}

function setupFiles(su){
	var errFlag = false ; // to catch errors inside the addsubcomponent loops.
	var errString = "" ;
	updateStatusText(hSize,TEXT_ORGANIZING_INSTALL, 1, "normal") ;
	var numArray = new Array(2) ;  // this array and the setup inside updatestatustext are both for Intl issues
	var	jum = 0 ;
	for (var i=0 ; i < totalFiles ; i++ ) 
		{
	    jum++ ;
		numArray[0] = jum.toString() ;
		numArray[1] = file[i].fileName ;
		var tempStr = SimpleMessageFormat(INFO_ADDFILESTR, numArray) ;
		dbgMsg("tempstr = " +tempStr) ;
		updateStatusText(5, tempStr , 0, "") ;
		err = su.AddSubcomponent(file[i].regFilePath, 	//nice registry name,
							file[i].fileVersion,	// versionInfoObject, 
							file[i].fileSourcePath,		//Full name from inside .jar including path,
							file[i].fileDestFolder,	// folderSpecobj, 
							file[i].fileLocalPath,  //path for destination.  null=whatever destfolder is.
							file[i].fileForceStatus);			//dest file name (can be null) NEW api
		if (err != 0) {
				errFlag = true ;
				errString = file[i].fileName ;
				}
		
		}
	 	
	 	if (errFlag == true) {
			err = -1 ;
			updateStatusText(hSize, TEXT_ERR_ADDINGFILE +errString+ TEXT_TO_INSTALL, 3, "error") ;
	 		return err ;
			}

	return err ;
}


function checkSystemEnvironment()  // OS check, memcheck, etc go here.
	{
	var av = parseFloat(navigator.appVersion) ;
//check platform before doing smartupdate stuff.

	vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld) ;

	dbgMsg(DBG_VI_EQUALS+vi) ;
	registry_vi = netscape.softupdate.Trigger.GetVersionInfo(nsRegName);

	if ( (av < 4.02)) //if 4.0, 4.01, 4.01a, then fail
		{
		updateStatusText(hSize,TEXT_WRONG_COMM_VER , 3, "error") ;
		err= -1 ;
		return err ;
		}
		
	updateStatusText(4, TEXT_CLICK_GRANT, 0, "normal") ;	

	err = su.StartInstall(nsRegName, // Package name
							vi,
							1);  //new api 1= full install

	return err ;  //everything is OK.
}


function body() {	//this section works in clumps - each clump gets an error check after it's called.
					// the errorFlag is there to make sure I only call abortMe once.

	su = new netscape.softupdate.SoftwareUpdate( this, updateObjectName ) ;
	if (su == null) updateStatusText(hSize,TEXT_NONEWSUOBJ,1, "error") ;
	if ( (su != null) )
		{
		updateStatusText(hSize,TEXT_CHECKINGSYSTEM , 1, "") ;
		err = checkSystemEnvironment() ;  //checksystemenvironments, if it returns error, abort
		if (( err != 0 ) && (errorFlag == false)) 
			{
			 errorParse(err) ;
			 abortMe() ;
			}
		if (err == 0) {
			updateStatusText(hSize,TEXT_SETTINGUP_FILES, 1, "") ;
			err = buildArray() ;
			if (( err != 0 ) && (errorFlag ==false)) {
				errorParse(err) ;
				abortMe() ;
				}
			}

		if (err == 0) {		
			updateStatusText(hSize,TEXT_SETTINGUP_REST, 1, "") ;
			err = setupFiles(su) ;		  // and abort.
			if (( err != 0 ) && (errorFlag ==false)) {
				errorParse(err) ;
				abortMe() ;
				}
			}

		if (err == 0) {
			err = updateRegistry() ;
			if (( err != 0 ) && (errorFlag ==false)) {
				errorParse(err) ;
				abortMe() ;
				}
			}

		if (err == 0)
			{
//			updateStatusText(hSize, TEXT_ADDING_AIM, 2, "") ;   
//			addAim() ;
			//updateStatusText(hSize, TEXT_AIM_LAUNCHED, 3, "") ;
			}

		if (err == 0) 			// if we get to here, everything's cool and we can finalize install.
			{
			updateStatusText(hSize,TEXT_READYING_FILES, 4, true, "") ;   
			err = su.FinalizeInstall();	// This actually copies all the files to their right place
			if (err == 6)
				{
				err = 999 ; //special case for replacing netscape.exe only
				if (troubleFlag) // this is to catch false error 6 and continue with the trouble install case.
					{
					err = 0 ;
					}
				}
			if (( err != 0 ) && (errorFlag == false) && (!troubleFlag)) 
				{
				errorParse(err) ;
				abortMe() ;
				}
            if ( (troubleFlag) && (errorFlag == false) && (err == 0) )
	            {
                updateStatusText(hSize, STATUS_OPENING_INFO_FILE, 2, "normal") ;
                infowindow = window.open("", WINDOW_TITLE_INFO_FILE,"toolbar=1,menubar=1,status=1,scrollbars=1,resizable=1,width=600,height=500,top=50,left=100") ;
                infowindow.document.open("text/html");   //open a window that has the text/html mime type.
                infowindow.document.close() ;  // flush to window.
                infowindow.document.write(HTML_INSTRUCTIONS_WINDOW_TITLE);
                infowindow.document.write("<br>") ;
                infowindow.document.write(HTML_INSTRUCTIONS_TITLE);
                infowindow.document.write("<CENTER><HR WIDTH='75%'></CENTER>");
                infowindow.document.write("<UL>" + HTML_INSTRUCTIONS_1);
                infowindow.document.write("<P>" + HTML_INSTRUCTIONS_2);
                infowindow.document.write("<P>" + HTML_INSTRUCTIONS_3);
                infowindow.document.write("<BR>&nbsp;<UL><OL>");
                infowindow.document.write("<LI>" + HTML_INSTRUCTIONS_4 + "</LI>");
                infowindow.document.write("<LI>" + HTML_INSTRUCTIONS_5 + "</LI>");

                var objRef1 = new StrBuilder(FORMAT_STRING_HTML_INSTRUCTIONS_6);
                BufferString = BuildString(objRef1, fProgram, fProgram);
                infowindow.document.write("<LI>" + BufferString + "</LI>");

                var objRef2 = new StrBuilder(FORMAT_STRING_HTML_INSTRUCTIONS_7);
                BufferString = BuildString(objRef2, fProgram, fProgram);
                infowindow.document.write("<LI>" + BufferString + "</LI>");

                var objRef3 = new StrBuilder(FORMAT_STRING_HTML_INSTRUCTIONS_8);
                BufferString = BuildString(objRef3, fProgram, fProgram);
                infowindow.document.write("<LI>" + BufferString + "</LI>");

                infowindow.document.write("<LI>" + HTML_INSTRUCTIONS_9 + "</LI></OL>&nbsp;</UL>");
                infowindow.document.write(HTML_INSTRUCTIONS_10);
                infowindow.document.write("</BODY></HTML>");
                infowindow.document.close();
    	        }

			}
			
		if (( err != 0 ) && (errorFlag ==false))	// If we have an error, write it to the console
			{
			errorParse(err) ;
			abortMe() ;
			}

		if (( err == 0 ) && (errorFlag ==false))	// If we have an error, write it to the console
			{
			updateStatusText(hSize, TEXT_INSTALL_COMPLETED, 4, "") ;   
			wndw.close() ;			
			}
		

	}// endif
}

// ================ START ================
// PRE FLIGHT CHECK
if (checkLang() && checkJava() && checkASD() )
{
	var troubleFlag = false ;
	var chkOS ;
	var chkOSNum ;
	var OSFlavor ;
	chkOS 		= java.lang.System.getProperty("os.name") ;
	chkOSNum	= java.lang.System.getProperty("os.version") ;
	OSFlavor	= navigator.platform ;
	if (navigator.platform == "Win32")
		bitNum 	= "32" ;
	else	
		bitNum 	= "16" ;

    // VARIABLE DECLARATIONS
	var shadowvar 		 = java.lang.System.getProperty("os.version") ;
	var osVer 			 = parseFloat(shadowvar) ;
	var topWindowTitle   = TEXT_TOPWINDOW_TITLE ;
	var updateObjectName = TEXT_UPDATEOBJ_NAME ;
	var defaultText      = TEXT_DEFAULT_TEXT ;
    var err              = 0;
    var hSize            = "4";
    var su               = null;
    var suEnv            = this;
    var errorFlag        = false;
    var delayTime        = 1;
    var silentValue      = false ;  // = this.silent;
    var graphic          = "";
    var debugOutput      = true ;  // Turns debugging output on/off
    var nsRegName        = "Cosmo" ; 

    var installerVersion = "4.05 (en)";
    var versionMaj       = 4;
    var versionMin       = 0;
    var versionRel       = 7;

    var versionBld       = 97343 ;
    var totalFiles       = 161 ;

    var file = new Array(totalFiles);

    for (i=0; i<totalFiles; i++ )
    {
        file[i] = new fileInfoObject;
    }

    if(!silentValue)
        setupWindows();

    body();
}// end of check for java and ASD enabled

function buildArray() //stores the information for each file in the array.
{
    //Build used folder list here:
	updateStatusText(5, TEXT_PICKWHERETOINSTALL, 5, "normal") ;
	fUserPick	  = su.GetFolder("User Pick") ;
	fUserDir= fUserPick + "" ;
	updateStatusText(5, TEXT_REFLECTINSTALLDIR + " " + fUserDir, 4, "normal") ;
	dbgMsg("dest = " + fUserDir) ;

//    fPlugins      = su.GetFolder("Plugins");
    fWinSystem    = su.GetFolder("Win System");
//    fWindows      = su.GetFolder("Windows");
    fProgram      = su.GetFolder("Program");
//    fCommunicator = su.GetFolder("Communicator");
//    fJavaBin      = su.GetFolder("Netscape Java Bin");
//    fJavaClasses  = su.GetFolder("Netscape Java Classes");

    // check folders before using them.
    icount = 0;

    // the code below is generated by sugen.pl
    // BEGIN gen

    vi = new netscape.softupdate.VersionInfo(1, 0, 0, 1);
    file[icount].fileName       = "npcosmop.dll";
    file[icount].regFilePath    = "=COMM=/plugins/CosmoPlayer/npcosmop.dll";
    file[icount].fileSourcePath = "plugins/CosmoPlayer/npcosmop.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "plugins/CosmoPlayer/npcosmop.dll";
  else 
    file[icount].fileLocalPath  = "plugins/CosmoPlayer/npcosmop.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "npcosmop.jar";
    file[icount].regFilePath    = "=COMM=/plugins/CosmoPlayer/npcosmop.jar";
    file[icount].fileSourcePath = "plugins/CosmoPlayer/npcosmop.jar";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fProgram;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "plugins/CosmoPlayer/npcosmop.jar";
  else 
    file[icount].fileLocalPath  = "plugins/CosmoPlayer/npcosmop.jar";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(1, 0, 0, 1);
    file[icount].fileName       = "cm_core10.dll";
    file[icount].regFilePath    = "/CosmoSoftware/Shared/cm_core10.dll";
    file[icount].fileSourcePath = "system/cm_core10.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fWinSystem;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "cm_core10.dll";
  else 
    file[icount].fileLocalPath  = "cm_core10.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(1, 0, 0, 1);
    file[icount].fileName       = "cm_dshow10.dll";
    file[icount].regFilePath    = "/CosmoSoftware/Shared/cm_dshow10.dll";
    file[icount].fileSourcePath = "system/cm_dshow10.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fWinSystem;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "cm_dshow10.dll";
  else 
    file[icount].fileLocalPath  = "cm_dshow10.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(1, 1, 1, 0);
    file[icount].fileName       = "cosmord.dll";
    file[icount].regFilePath    = "/CosmoSoftware/Shared/cosmord.dll";
    file[icount].fileSourcePath = "system/cosmord.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fWinSystem;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "cosmord.dll";
  else 
    file[icount].fileLocalPath  = "cosmord.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "cpimg10.dll";
    file[icount].regFilePath    = "/CosmoSoftware/Shared/cpimg10.dll";
    file[icount].fileSourcePath = "system/cpimg10.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fWinSystem;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "cpimg10.dll";
  else 
    file[icount].fileLocalPath  = "cpimg10.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "cpmsjava.dll";
    file[icount].regFilePath    = "/CosmoSoftware/Shared/cpmsjava.dll";
    file[icount].fileSourcePath = "system/cpmsjava.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fWinSystem;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "cpmsjava.dll";
  else 
    file[icount].fileLocalPath  = "cpmsjava.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(1, 0, 0, 1);
    file[icount].fileName       = "cpt_basic10.dll";
    file[icount].regFilePath    = "/CosmoSoftware/Shared/cpt_basic10.dll";
    file[icount].fileSourcePath = "system/cpt_basic10.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fWinSystem;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "cpt_basic10.dll";
  else 
    file[icount].fileLocalPath  = "cpt_basic10.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(1, 0, 0, 1);
    file[icount].fileName       = "cpt_extra10.dll";
    file[icount].regFilePath    = "/CosmoSoftware/Shared/cpt_extra10.dll";
    file[icount].fileSourcePath = "system/cpt_extra10.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fWinSystem;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "cpt_extra10.dll";
  else 
    file[icount].fileLocalPath  = "cpt_extra10.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(1, 0, 0, 1);
    file[icount].fileName       = "cp_axucp.dll";
    file[icount].regFilePath    = "/CosmoSoftware/Shared/cp_axucp.dll";
    file[icount].fileSourcePath = "system/cp_axucp.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fWinSystem;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "cp_axucp.dll";
  else 
    file[icount].fileLocalPath  = "cp_axucp.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "cp_basic.dll";
    file[icount].regFilePath    = "/CosmoSoftware/Shared/cp_basic.dll";
    file[icount].fileSourcePath = "system/cp_basic.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fWinSystem;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "cp_basic.dll";
  else 
    file[icount].fileLocalPath  = "cp_basic.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "cp_glrenderer.dll";
    file[icount].regFilePath    = "/CosmoSoftware/Shared/cp_glrenderer.dll";
    file[icount].fileSourcePath = "system/cp_glrenderer.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fWinSystem;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "cp_glrenderer.dll";
  else 
    file[icount].fileLocalPath  = "cp_glrenderer.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "cp_graphicslarge8.dll";
    file[icount].regFilePath    = "/CosmoSoftware/Shared/cp_graphicslarge8.dll";
    file[icount].fileSourcePath = "system/cp_graphicslarge8.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fWinSystem;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "cp_graphicslarge8.dll";
  else 
    file[icount].fileLocalPath  = "cp_graphicslarge8.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "cp_graphicslarge16.dll";
    file[icount].regFilePath    = "/CosmoSoftware/Shared/cp_graphicslarge16.dll";
    file[icount].fileSourcePath = "system/cp_graphicslarge16.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fWinSystem;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "cp_graphicslarge16.dll";
  else 
    file[icount].fileLocalPath  = "cp_graphicslarge16.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "cp_graphicsmed8.dll";
    file[icount].regFilePath    = "/CosmoSoftware/Shared/cp_graphicsmed8.dll";
    file[icount].fileSourcePath = "system/cp_graphicsmed8.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fWinSystem;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "cp_graphicsmed8.dll";
  else 
    file[icount].fileLocalPath  = "cp_graphicsmed8.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "cp_graphicsmed16.dll";
    file[icount].regFilePath    = "/CosmoSoftware/Shared/cp_graphicsmed16.dll";
    file[icount].fileSourcePath = "system/cp_graphicsmed16.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fWinSystem;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "cp_graphicsmed16.dll";
  else 
    file[icount].fileLocalPath  = "cp_graphicsmed16.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "cp_graphicspos.dll";
    file[icount].regFilePath    = "/CosmoSoftware/Shared/cp_graphicspos.dll";
    file[icount].fileSourcePath = "system/cp_graphicspos.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fWinSystem;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "cp_graphicspos.dll";
  else 
    file[icount].fileLocalPath  = "cp_graphicspos.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "cp_graphicssmall8.dll";
    file[icount].regFilePath    = "/CosmoSoftware/Shared/cp_graphicssmall8.dll";
    file[icount].fileSourcePath = "system/cp_graphicssmall8.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fWinSystem;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "cp_graphicssmall8.dll";
  else 
    file[icount].fileLocalPath  = "cp_graphicssmall8.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "cp_graphicssmall16.dll";
    file[icount].regFilePath    = "/CosmoSoftware/Shared/cp_graphicssmall16.dll";
    file[icount].fileSourcePath = "system/cp_graphicssmall16.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fWinSystem;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "cp_graphicssmall16.dll";
  else 
    file[icount].fileLocalPath  = "cp_graphicssmall16.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "cp_javascript.dll";
    file[icount].regFilePath    = "/CosmoSoftware/Shared/cp_javascript.dll";
    file[icount].fileSourcePath = "system/cp_javascript.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fWinSystem;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "cp_javascript.dll";
  else 
    file[icount].fileLocalPath  = "cp_javascript.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "cp_main.dll";
    file[icount].regFilePath    = "/CosmoSoftware/Shared/cp_main.dll";
    file[icount].fileSourcePath = "system/cp_main.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fWinSystem;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "cp_main.dll";
  else 
    file[icount].fileLocalPath  = "cp_main.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "cp_renderer.dll";
    file[icount].regFilePath    = "/CosmoSoftware/Shared/cp_renderer.dll";
    file[icount].fileSourcePath = "system/cp_renderer.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fWinSystem;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "cp_renderer.dll";
  else 
    file[icount].fileLocalPath  = "cp_renderer.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "cp_tessellator.dll";
    file[icount].regFilePath    = "/CosmoSoftware/Shared/cp_tessellator.dll";
    file[icount].fileSourcePath = "system/cp_tessellator.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fWinSystem;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "cp_tessellator.dll";
  else 
    file[icount].fileLocalPath  = "cp_tessellator.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "cp_vrml1to2.dll";
    file[icount].regFilePath    = "/CosmoSoftware/Shared/cp_vrml1to2.dll";
    file[icount].fileSourcePath = "system/cp_vrml1to2.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fWinSystem;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "cp_vrml1to2.dll";
  else 
    file[icount].fileLocalPath  = "cp_vrml1to2.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "ifl.dll";
    file[icount].regFilePath    = "/CosmoSoftware/Shared/ifl.dll";
    file[icount].fileSourcePath = "system/ifl.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fWinSystem;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "ifl.dll";
  else 
    file[icount].fileLocalPath  = "ifl.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "ifl_database";
    file[icount].regFilePath    = "/CosmoSoftware/Shared/ifl_database";
    file[icount].fileSourcePath = "system/ifl_database";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fWinSystem;
    file[icount].fileLocalPath  = "ifl_database";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "ifl_gif.dll";
    file[icount].regFilePath    = "/CosmoSoftware/Shared/ifl_gif.dll";
    file[icount].fileSourcePath = "system/ifl_gif.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fWinSystem;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "ifl_gif.dll";
  else 
    file[icount].fileLocalPath  = "ifl_gif.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "ifl_jpeg.dll";
    file[icount].regFilePath    = "/CosmoSoftware/Shared/ifl_jpeg.dll";
    file[icount].fileSourcePath = "system/ifl_jpeg.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fWinSystem;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "ifl_jpeg.dll";
  else 
    file[icount].fileLocalPath  = "ifl_jpeg.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "ifl_libz.dll";
    file[icount].regFilePath    = "/CosmoSoftware/Shared/ifl_libz.dll";
    file[icount].fileSourcePath = "system/ifl_libz.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fWinSystem;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "ifl_libz.dll";
  else 
    file[icount].fileLocalPath  = "ifl_libz.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "ifl_png.dll";
    file[icount].regFilePath    = "/CosmoSoftware/Shared/ifl_png.dll";
    file[icount].fileSourcePath = "system/ifl_png.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fWinSystem;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "ifl_png.dll";
  else 
    file[icount].fileLocalPath  = "ifl_png.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "ifl_sgi.dll";
    file[icount].regFilePath    = "/CosmoSoftware/Shared/ifl_sgi.dll";
    file[icount].fileSourcePath = "system/ifl_sgi.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fWinSystem;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "ifl_sgi.dll";
  else 
    file[icount].fileLocalPath  = "ifl_sgi.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(5, 0, 0, 7128);
    file[icount].fileName       = "msvcrt.dll";
    file[icount].regFilePath    = "/CosmoSoftware/Shared/msvcrt.dll";
    file[icount].fileSourcePath = "system/msvcrt.dll";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fWinSystem;
  if (troubleFlag) 
    file[icount].fileLocalPath  = "install/" + "msvcrt.dll";
  else 
    file[icount].fileLocalPath  = "msvcrt.dll";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "defaultProtos.wrl";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/defaultProtos.wrl";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/defaultProtos.wrl";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/defaultProtos.wrl";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "about.html";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/about.html";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/about.html";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/about.html";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "b1ago.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/b1ago.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/b1ago.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/b1ago.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "b2slide.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/b2slide.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/b2slide.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/b2slide.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "b3tilt.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/b3tilt.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/b3tilt.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/b3tilt.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "b4rotate.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/b4rotate.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/b4rotate.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/b4rotate.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "b5pan.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/b5pan.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/b5pan.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/b5pan.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "b6zoom.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/b6zoom.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/b6zoom.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/b6zoom.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "b7aseek.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/b7aseek.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/b7aseek.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/b7aseek.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "b9grav.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/b9grav.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/b9grav.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/b9grav.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "b10float.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/b10float.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/b10float.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/b10float.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "b11aundo.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/b11aundo.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/b11aundo.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/b11aundo.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "b12astr8.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/b12astr8.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/b12astr8.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/b12astr8.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "b12bstr8.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/b12bstr8.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/b12bstr8.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/b12bstr8.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "b14aview.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/b14aview.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/b14aview.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/b14aview.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "b14bview.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/b14bview.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/b14bview.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/b14bview.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "b14cview.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/b14cview.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/b14cview.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/b14cview.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "b16logo.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/b16logo.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/b16logo.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/b16logo.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "b17logo.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/b17logo.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/b17logo.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/b17logo.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "background.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/background.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/background.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/background.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "c1go.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/c1go.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/c1go.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/c1go.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "c2slide.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/c2slide.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/c2slide.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/c2slide.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "c3tilt.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/c3tilt.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/c3tilt.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/c3tilt.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "c4rotate.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/c4rotate.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/c4rotate.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/c4rotate.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "c5pan.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/c5pan.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/c5pan.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/c5pan.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "c6zoom.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/c6zoom.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/c6zoom.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/c6zoom.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "c7seek.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/c7seek.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/c7seek.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/c7seek.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "chomp.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/chomp.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/chomp.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/chomp.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "cosmo.jpg";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/cosmo.jpg";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/cosmo.jpg";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/cosmo.jpg";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "cp20Index.html";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/cp20Index.html";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/cp20Index.html";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/cp20Index.html";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "credits.wrl";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/credits.wrl";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/credits.wrl";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/credits.wrl";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "examine.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/examine.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/examine.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/examine.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "examine2.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/examine2.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/examine2.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/examine2.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "f-about.html";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/f-about.html";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/f-about.html";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/f-about.html";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "f-media.html";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/f-media.html";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/f-media.html";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/f-media.html";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "frames-help.html";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/frames-help.html";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/frames-help.html";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/frames-help.html";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "frames-relnotes.html";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/frames-relnotes.html";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/frames-relnotes.html";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/frames-relnotes.html";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "helpContents.html";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/helpContents.html";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/helpContents.html";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/helpContents.html";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "Icon.ico";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/Icon.ico";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/Icon.ico";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/Icon.ico";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "image6.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/image6.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/image6.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/image6.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "image7.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/image7.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/image7.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/image7.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "intro.htm";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/intro.htm";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/intro.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/intro.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "label.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/label.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/label.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/label.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "mediahelp.html";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/mediahelp.html";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/mediahelp.html";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/mediahelp.html";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "minimize.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/minimize.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/minimize.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/minimize.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "moving.htm";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/moving.htm";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/moving.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/moving.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "nav-menu.html";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/nav-menu.html";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/nav-menu.html";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/nav-menu.html";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "null.html";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/null.html";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/null.html";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/null.html";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "orb.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/orb.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/orb.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/orb.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "prefs.htm";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/prefs.htm";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/prefs.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/prefs.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "relContents.html";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/relContents.html";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/relContents.html";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/relContents.html";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "relnotes.html";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/relnotes.html";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/relnotes.html";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/relnotes.html";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "sensor.htm";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/sensor.htm";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/sensor.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/sensor.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "showme.htm";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/showme.htm";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/showme.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/showme.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "walk.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/walk.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/walk.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/walk.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "walk2.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/doc/walk2.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/doc/walk2.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/doc/walk2.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "avoid.htm";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/avoid.htm";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/avoid.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/avoid.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "black.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/black.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/black.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/black.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "boom.wav";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/boom.wav";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/boom.wav";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/boom.wav";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "bubble.wav";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/bubble.wav";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/bubble.wav";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/bubble.wav";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "bubble.wrl";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/bubble.wrl";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/bubble.wrl";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/bubble.wrl";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "bubble2.wav";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/bubble2.wav";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/bubble2.wav";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/bubble2.wav";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "bubble2.wrl";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/bubble2.wrl";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/bubble2.wrl";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/bubble2.wrl";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "burp.wav";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/burp.wav";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/burp.wav";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/burp.wav";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "canyonv.wrl";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/canyonv.wrl";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/canyonv.wrl";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/canyonv.wrl";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "chomp.htm";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/chomp.htm";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/chomp.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/chomp.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "chomp.wav";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/chomp.wav";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/chomp.wav";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/chomp.wav";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "chomp.wrl";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/chomp.wrl";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/chomp.wrl";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/chomp.wrl";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "chomp1.htm";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/chomp1.htm";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/chomp1.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/chomp1.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "chomp2.htm";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/chomp2.htm";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/chomp2.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/chomp2.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "chomp3.htm";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/chomp3.htm";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/chomp3.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/chomp3.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "chomp4.htm";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/chomp4.htm";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/chomp4.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/chomp4.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "chomp5.htm";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/chomp5.htm";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/chomp5.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/chomp5.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "chomp6.htm";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/chomp6.htm";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/chomp6.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/chomp6.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "chomp7.htm";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/chomp7.htm";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/chomp7.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/chomp7.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "chomp8.htm";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/chomp8.htm";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/chomp8.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/chomp8.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "cosmlogo.jpg";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/cosmlogo.jpg";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/cosmlogo.jpg";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/cosmlogo.jpg";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "credits.htm";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/credits.htm";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/credits.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/credits.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "c_mondo.jpg";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/c_mondo.jpg";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/c_mondo.jpg";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/c_mondo.jpg";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "dead.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/dead.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/dead.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/dead.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "end.htm";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/end.htm";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/end.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/end.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "fish.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/fish.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/fish.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/fish.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "fishswim.wrl";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/fishswim.wrl";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/fishswim.wrl";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/fishswim.wrl";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "frames.htm";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/frames.htm";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/frames.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/frames.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "gullswim.wrl";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/gullswim.wrl";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/gullswim.wrl";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/gullswim.wrl";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "g_float.jpg";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/g_float.jpg";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/g_float.jpg";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/g_float.jpg";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "g_go.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/g_go.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/g_go.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/g_go.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "g_gravty.jpg";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/g_gravty.jpg";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/g_gravty.jpg";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/g_gravty.jpg";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "g_hide.jpg";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/g_hide.jpg";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/g_hide.jpg";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/g_hide.jpg";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "g_pan.jpg";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/g_pan.jpg";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/g_pan.jpg";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/g_pan.jpg";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "g_redo.jpg";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/g_redo.jpg";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/g_redo.jpg";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/g_redo.jpg";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "g_rot.jpg";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/g_rot.jpg";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/g_rot.jpg";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/g_rot.jpg";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "g_seek.jpg";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/g_seek.jpg";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/g_seek.jpg";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/g_seek.jpg";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "g_slide.jpg";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/g_slide.jpg";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/g_slide.jpg";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/g_slide.jpg";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "g_strait.jpg";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/g_strait.jpg";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/g_strait.jpg";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/g_strait.jpg";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "g_switch.jpg";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/g_switch.jpg";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/g_switch.jpg";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/g_switch.jpg";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "g_tilt.jpg";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/g_tilt.jpg";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/g_tilt.jpg";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/g_tilt.jpg";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "g_undo.jpg";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/g_undo.jpg";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/g_undo.jpg";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/g_undo.jpg";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "g_viewli.jpg";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/g_viewli.jpg";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/g_viewli.jpg";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/g_viewli.jpg";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "g_zoom.jpg";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/g_zoom.jpg";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/g_zoom.jpg";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/g_zoom.jpg";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "i_bkg01.jpg";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/i_bkg01.jpg";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/i_bkg01.jpg";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/i_bkg01.jpg";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "i_chomp.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/i_chomp.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/i_chomp.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/i_chomp.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "i_lets.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/i_lets.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/i_lets.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/i_lets.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "loading.htm";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/loading.htm";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/loading.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/loading.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "logo.htm";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/logo.htm";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/logo.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/logo.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "noend.htm";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/noend.htm";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/noend.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/noend.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "nopoint.htm";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/nopoint.htm";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/nopoint.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/nopoint.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "oops.wav";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/oops.wav";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/oops.wav";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/oops.wav";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "oops1.htm";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/oops1.htm";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/oops1.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/oops1.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "oops2.htm";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/oops2.htm";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/oops2.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/oops2.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "point.htm";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/point.htm";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/point.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/point.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "seaweed.wrl";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/seaweed.wrl";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/seaweed.wrl";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/seaweed.wrl";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "shark.mid";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/shark.mid";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/shark.mid";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/shark.mid";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "skeleton.wrl";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/skeleton.wrl";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/skeleton.wrl";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/skeleton.wrl";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "smlchomp.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/smlchomp.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/smlchomp.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/smlchomp.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "target.gif";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/target.gif";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/target.gif";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/target.gif";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "text.htm";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/text.htm";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/text.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/text.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "text1.htm";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/text1.htm";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/text1.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/text1.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "text2.htm";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/text2.htm";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/text2.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/text2.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "text3.htm";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/text3.htm";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/text3.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/text3.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "text4.htm";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/text4.htm";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/text4.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/text4.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "text5.htm";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/text5.htm";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/text5.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/text5.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "text6.htm";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/text6.htm";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/text6.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/text6.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "text7.htm";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/text7.htm";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/text7.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/text7.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "text8.htm";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/text8.htm";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/text8.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/text8.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "text9.htm";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/text9.htm";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/text9.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/text9.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "trainer.htm";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/trainer.htm";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/trainer.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/trainer.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "tube.wrl";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/tube.wrl";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/tube.wrl";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/tube.wrl";
    file[icount].fileForceStatus= this.force ;
    icount++;

    vi = new netscape.softupdate.VersionInfo(versionMaj, versionMin, versionRel, versionBld);
    file[icount].fileName       = "whoa.htm";
    file[icount].regFilePath    = "/CosmoSoftware/CosmoPlayer/examples/chomp/whoa.htm";
    file[icount].fileSourcePath = "userpick/CosmoSoftware/CosmoPlayer/examples/chomp/whoa.htm";
    file[icount].fileVersion    = vi;
    file[icount].fileDestFolder = fUserPick;
    file[icount].fileLocalPath  = "CosmoSoftware/CosmoPlayer/examples/chomp/whoa.htm";
    file[icount].fileForceStatus= this.force ;
    icount++;

    // END gen
    return err;
}

