/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CharsetMapping {
    public static final Map JAVA_TO_MYSQL_CHARSET_MAP;
    public static final Map JAVA_UC_TO_MYSQL_CHARSET_MAP;
    public static final Map MYSQL_TO_JAVA_CHARSET_MAP;
    public static final Map MULTIBYTE_CHARSETS;
    public static final String[] INDEX_TO_CHARSET;

    static final boolean isAliasForSjis(String encoding) {
        return "SJIS".equalsIgnoreCase(encoding) || "WINDOWS-31J".equalsIgnoreCase(encoding) || "MS932".equalsIgnoreCase(encoding) || "SHIFT_JIS".equalsIgnoreCase(encoding) || "CP943".equalsIgnoreCase(encoding);
    }

    static {
        HashMap<String, String> tempMap = new HashMap<String, String>();
        tempMap.put("usa7", "US-ASCII");
        tempMap.put("ascii", "US-ASCII");
        tempMap.put("big5", "Big5");
        tempMap.put("gbk", "GBK");
        tempMap.put("sjis", "SJIS");
        tempMap.put("gb2312", "EUC_CN");
        tempMap.put("ujis", "EUC_JP");
        tempMap.put("eucjpms", "EUC_JP_Solaris");
        tempMap.put("euc_kr", "EUC_KR");
        tempMap.put("euckr", "EUC_KR");
        tempMap.put("latin1", "ISO8859_1");
        tempMap.put("latin1_de", "ISO8859_1");
        tempMap.put("german1", "ISO8859_1");
        tempMap.put("danish", "ISO8859_1");
        tempMap.put("latin2", "ISO8859_2");
        tempMap.put("czech", "ISO8859_2");
        tempMap.put("hungarian", "ISO8859_2");
        tempMap.put("croat", "ISO8859_2");
        tempMap.put("greek", "ISO8859_7");
        tempMap.put("latin7", "ISO8859_7");
        tempMap.put("hebrew", "ISO8859_8");
        tempMap.put("latin5", "ISO8859_9");
        tempMap.put("latvian", "ISO8859_13");
        tempMap.put("latvian1", "ISO8859_13");
        tempMap.put("estonia", "ISO8859_13");
        tempMap.put("dos", "Cp437");
        tempMap.put("Cp850", "Cp850");
        tempMap.put("Cp852", "Cp852");
        tempMap.put("cp866", "Cp866");
        tempMap.put("koi8_ru", "KOI8_R");
        tempMap.put("koi8r", "KOI8_R");
        tempMap.put("tis620", "TIS620");
        tempMap.put("cp1250", "Cp1250");
        tempMap.put("win1250", "Cp1250");
        tempMap.put("win1251", "Cp1251");
        tempMap.put("cp1251", "Cp1251");
        tempMap.put("cp1251cias", "Cp1251");
        tempMap.put("cp1251csas", "Cp1251");
        tempMap.put("cp1256", "Cp1256");
        tempMap.put("win1251ukr", "Cp1251");
        tempMap.put("cp1257", "Cp1257");
        tempMap.put("macroman", "MacRoman");
        tempMap.put("macce", "MacCentralEurope");
        tempMap.put("utf8", "UTF-8");
        tempMap.put("ucs2", "UnicodeBig");
        tempMap.put("binary", "US-ASCII");
        MYSQL_TO_JAVA_CHARSET_MAP = Collections.unmodifiableMap(tempMap);
        HashMap javaToMysqlMap = new HashMap();
        Set keySet = MYSQL_TO_JAVA_CHARSET_MAP.keySet();
        Iterator keys = keySet.iterator();
        while (keys.hasNext()) {
            Object mysqlEncodingName = keys.next();
            Object javaEncodingName = MYSQL_TO_JAVA_CHARSET_MAP.get(mysqlEncodingName);
            if ("ISO8859_1".equals(javaEncodingName)) {
                if (!"latin1".equals(mysqlEncodingName)) continue;
                javaToMysqlMap.put(javaEncodingName, mysqlEncodingName);
                continue;
            }
            if ("ISO8859_2".equals(javaEncodingName)) {
                if (!"latin2".equals(mysqlEncodingName)) continue;
                javaToMysqlMap.put(javaEncodingName, mysqlEncodingName);
                continue;
            }
            if ("ISO8859_13".equals(javaEncodingName)) {
                if (!"latin7".equals(mysqlEncodingName)) continue;
                javaToMysqlMap.put(javaEncodingName, mysqlEncodingName);
                continue;
            }
            javaToMysqlMap.put(javaEncodingName, mysqlEncodingName);
        }
        JAVA_TO_MYSQL_CHARSET_MAP = Collections.unmodifiableMap(javaToMysqlMap);
        HashMap ucMap = new HashMap(JAVA_TO_MYSQL_CHARSET_MAP.size());
        Iterator javaNamesKeys = JAVA_TO_MYSQL_CHARSET_MAP.keySet().iterator();
        while (javaNamesKeys.hasNext()) {
            String key = (String)javaNamesKeys.next();
            ucMap.put(key.toUpperCase(), JAVA_TO_MYSQL_CHARSET_MAP.get(key));
        }
        ucMap.put("ASCII", "ascii");
        ucMap.put("LATIN5", "latin5");
        ucMap.put("LATIN7", "latin7");
        ucMap.put("HEBREW", "hebrew");
        ucMap.put("GREEK", "greek");
        ucMap.put("EUCKR", "euckr");
        ucMap.put("GB2312", "gb2312");
        ucMap.put("LATIN2", "latin2");
        ucMap.put("WINDOWS-31J", "sjis");
        ucMap.put("MS932", "sjis");
        ucMap.put("SHIFT_JIS", "sjis");
        ucMap.put("CP943", "sjis");
        ucMap.put("EUC_JP", "ujis");
        JAVA_UC_TO_MYSQL_CHARSET_MAP = Collections.unmodifiableMap(ucMap);
        HashMap<String, String> tempMapMulti = new HashMap<String, String>();
        tempMapMulti.put("big5", "big5");
        tempMapMulti.put("euc_kr", "euc_kr");
        tempMapMulti.put("euckr", "euckr");
        tempMapMulti.put("gb2312", "gb2312");
        tempMapMulti.put("gbk", "gbk");
        tempMapMulti.put("sjis", "sjis");
        tempMapMulti.put("ujis", "ujis");
        tempMapMulti.put("utf8", "utf8");
        tempMapMulti.put("ucs2", "UnicodeBig");
        tempMapMulti.put("windows-31j", "sjis");
        tempMapMulti.put("ms932", "sjis");
        tempMapMulti.put("shift_jis", "sjis");
        tempMapMulti.put("cp943", "sjis");
        tempMapMulti.put("eucjpms", "ujis");
        tempMapMulti.put("EUC_JP_Solaris", "eucjpms");
        MULTIBYTE_CHARSETS = Collections.unmodifiableMap(tempMapMulti);
        INDEX_TO_CHARSET = new String[99];
        CharsetMapping.INDEX_TO_CHARSET[1] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("big5");
        CharsetMapping.INDEX_TO_CHARSET[2] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("czech");
        CharsetMapping.INDEX_TO_CHARSET[3] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("dec8");
        CharsetMapping.INDEX_TO_CHARSET[4] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("dos");
        CharsetMapping.INDEX_TO_CHARSET[5] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("german1");
        CharsetMapping.INDEX_TO_CHARSET[6] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("hp8");
        CharsetMapping.INDEX_TO_CHARSET[7] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("koi8_ru");
        CharsetMapping.INDEX_TO_CHARSET[8] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("latin1");
        CharsetMapping.INDEX_TO_CHARSET[9] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("latin2");
        CharsetMapping.INDEX_TO_CHARSET[10] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("swe7");
        CharsetMapping.INDEX_TO_CHARSET[11] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("usa7");
        CharsetMapping.INDEX_TO_CHARSET[12] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("ujis");
        CharsetMapping.INDEX_TO_CHARSET[13] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("sjis");
        CharsetMapping.INDEX_TO_CHARSET[14] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("cp1251");
        CharsetMapping.INDEX_TO_CHARSET[15] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("danish");
        CharsetMapping.INDEX_TO_CHARSET[16] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("hebrew");
        CharsetMapping.INDEX_TO_CHARSET[18] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("tis620");
        CharsetMapping.INDEX_TO_CHARSET[19] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("euc_kr");
        CharsetMapping.INDEX_TO_CHARSET[20] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("estonia");
        CharsetMapping.INDEX_TO_CHARSET[21] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("hungarian");
        CharsetMapping.INDEX_TO_CHARSET[22] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("koi8_ukr");
        CharsetMapping.INDEX_TO_CHARSET[23] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("win1251ukr");
        CharsetMapping.INDEX_TO_CHARSET[24] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("gb2312");
        CharsetMapping.INDEX_TO_CHARSET[25] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("greek");
        CharsetMapping.INDEX_TO_CHARSET[26] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("win1250");
        CharsetMapping.INDEX_TO_CHARSET[27] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("croat");
        CharsetMapping.INDEX_TO_CHARSET[28] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("gbk");
        CharsetMapping.INDEX_TO_CHARSET[29] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("cp1257");
        CharsetMapping.INDEX_TO_CHARSET[30] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("latin5");
        CharsetMapping.INDEX_TO_CHARSET[31] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("latin1_de");
        CharsetMapping.INDEX_TO_CHARSET[32] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("armscii8");
        CharsetMapping.INDEX_TO_CHARSET[33] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("utf8");
        CharsetMapping.INDEX_TO_CHARSET[34] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("win1250ch");
        CharsetMapping.INDEX_TO_CHARSET[35] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("ucs2");
        CharsetMapping.INDEX_TO_CHARSET[36] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("cp866");
        CharsetMapping.INDEX_TO_CHARSET[37] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("keybcs2");
        CharsetMapping.INDEX_TO_CHARSET[38] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("macce");
        CharsetMapping.INDEX_TO_CHARSET[39] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("macroman");
        CharsetMapping.INDEX_TO_CHARSET[40] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("pclatin2");
        CharsetMapping.INDEX_TO_CHARSET[41] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("latvian");
        CharsetMapping.INDEX_TO_CHARSET[42] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("latvian1");
        CharsetMapping.INDEX_TO_CHARSET[43] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("maccebin");
        CharsetMapping.INDEX_TO_CHARSET[44] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("macceciai");
        CharsetMapping.INDEX_TO_CHARSET[45] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("maccecias");
        CharsetMapping.INDEX_TO_CHARSET[46] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("maccecsas");
        CharsetMapping.INDEX_TO_CHARSET[47] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("latin1bin");
        CharsetMapping.INDEX_TO_CHARSET[48] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("latin1cias");
        CharsetMapping.INDEX_TO_CHARSET[49] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("latin1csas");
        CharsetMapping.INDEX_TO_CHARSET[50] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("cp1251bin");
        CharsetMapping.INDEX_TO_CHARSET[51] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("cp1251cias");
        CharsetMapping.INDEX_TO_CHARSET[52] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("cp1251csas");
        CharsetMapping.INDEX_TO_CHARSET[53] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("macromanbin");
        CharsetMapping.INDEX_TO_CHARSET[54] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("macromancias");
        CharsetMapping.INDEX_TO_CHARSET[55] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("macromanciai");
        CharsetMapping.INDEX_TO_CHARSET[56] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("macromancsas");
        CharsetMapping.INDEX_TO_CHARSET[57] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("cp1256");
        CharsetMapping.INDEX_TO_CHARSET[63] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("binary");
        CharsetMapping.INDEX_TO_CHARSET[64] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("armscii");
        CharsetMapping.INDEX_TO_CHARSET[65] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("ascii");
        CharsetMapping.INDEX_TO_CHARSET[66] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("cp1250");
        CharsetMapping.INDEX_TO_CHARSET[67] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("cp1256");
        CharsetMapping.INDEX_TO_CHARSET[68] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("cp866");
        CharsetMapping.INDEX_TO_CHARSET[69] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("dec8");
        CharsetMapping.INDEX_TO_CHARSET[70] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("greek");
        CharsetMapping.INDEX_TO_CHARSET[71] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("hebrew");
        CharsetMapping.INDEX_TO_CHARSET[72] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("hp8");
        CharsetMapping.INDEX_TO_CHARSET[73] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("keybcs2");
        CharsetMapping.INDEX_TO_CHARSET[74] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("koi8r");
        CharsetMapping.INDEX_TO_CHARSET[75] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("koi8ukr");
        CharsetMapping.INDEX_TO_CHARSET[77] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("latin2");
        CharsetMapping.INDEX_TO_CHARSET[78] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("latin5");
        CharsetMapping.INDEX_TO_CHARSET[79] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("latin7");
        CharsetMapping.INDEX_TO_CHARSET[80] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("cp850");
        CharsetMapping.INDEX_TO_CHARSET[81] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("cp852");
        CharsetMapping.INDEX_TO_CHARSET[82] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("swe7");
        CharsetMapping.INDEX_TO_CHARSET[83] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("utf8");
        CharsetMapping.INDEX_TO_CHARSET[84] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("big5");
        CharsetMapping.INDEX_TO_CHARSET[85] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("euckr");
        CharsetMapping.INDEX_TO_CHARSET[86] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("gb2312");
        CharsetMapping.INDEX_TO_CHARSET[87] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("gbk");
        CharsetMapping.INDEX_TO_CHARSET[88] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("sjis");
        CharsetMapping.INDEX_TO_CHARSET[89] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("tis620");
        CharsetMapping.INDEX_TO_CHARSET[90] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("ucs2");
        CharsetMapping.INDEX_TO_CHARSET[91] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("ujis");
        CharsetMapping.INDEX_TO_CHARSET[92] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("geostd8");
        CharsetMapping.INDEX_TO_CHARSET[93] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("geostd8");
        CharsetMapping.INDEX_TO_CHARSET[94] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("latin1");
        CharsetMapping.INDEX_TO_CHARSET[95] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("cp932");
        CharsetMapping.INDEX_TO_CHARSET[96] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("cp932");
        CharsetMapping.INDEX_TO_CHARSET[97] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("eucjpms");
        CharsetMapping.INDEX_TO_CHARSET[98] = (String)MYSQL_TO_JAVA_CHARSET_MAP.get("eucjpms");
    }
}

