# *****************************************************************************
# *									      *
# *	   SPUNK MAKEFILE for DOS and OS/2 using the Watcom Compiler	      *
# *									      *
# * (C) 1993-95  Ullrich von Bassewitz					      *
# *		 Zwehrenbuehlstrasse 33					      *
# *		 D-72070 Tuebingen					      *
# * EMail:	 uz@ibb.schwaben.com					      *
# *									      *
# *****************************************************************************



# $Id$
#
# $Log$
#
#



# ------------------------------------------------------------------------------
# Generelle Einstellungen

.AUTODEPEND
.SUFFIXES	.ASM .C .CC .CPP
.SWAP

# ------------------------------------------------------------------------------
# Allgemeine Definitionen

# Names of executables
AS = TASM
AR = WLIB
LD = WLINK

# Files
ZIPFILE = spunk.zip

# Tools
!if $d(__OS2__)
ZIP = zip
MV = c:\os2\4os2\4os2 /C MOVE /Q
!else
ZIP = pkzip
MV = mv
!endif


!if !$d(TARGET)
!if $d(__OS2__)
TARGET = OS2
!else
TARGET = DOS
!endif
!endif

# target specific macros.
!if $(TARGET)==OS2

# --------------------- OS2 ---------------------
SYSTEM = os2v2
CC = WCL386
CCCFG  = -bm -bt=$(TARGET) -d$(TARGET) -d2 -onatx -zp4 -5 -fp3 -zq -w2 -ze

!elif $(TARGET)==DOS32

# -------------------- DOS4G --------------------
SYSTEM = dos4g
CC = WCL386
CCCFG  = -bt=$(TARGET) -d$(TARGET) -d2 -onatx -zp4 -5 -fp3 -zq -w2 -ze

!elif $(TARGET)==DOS

# --------------------- DOS ---------------------
SYSTEM = dos
CC = WCL
# Optimize for size when running under plain DOS, but use 286 code
CCCFG  = -bt=$(TARGET) -d$(TARGET) -d2 -onasx -zp2 -zc -2 -fp2 -ml -zq -w2 -ze -zt255

!else
!error
!endif

!if !$d(LIBDIR)
LIBDIR	= $(TARGET)
!endif

LIB	= $(LIBDIR)\spunk.lib
.PRECIOUS $(LIB)

# ------------------------------------------------------------------------------
# Implicit rules

.c.obj:
  $(CC) $(CCCFG) -c {$< }
  @$(MV) $*.obj $(TARGET)
  @if exist $*.mbr $(MV) $*.mbr $(TARGET)

.cc.obj:
  $(CC) $(CCCFG) -c {$< }
  @$(MV) $*.obj $(TARGET)
  @if exist $*.mbr $(MV) $*.mbr $(TARGET)

.asm.obj:
  $(AS) -Mx $*.asm,$*.obj
  @$(MV) $*.obj $(TARGET)

.path.obj	= $(TARGET)

# ------------------------------------------------------------------------------
# All SPUNK OBJ files

OBJS	=	bitset.obj	\
		charset.obj	\
		chartype.obj	\
		check.obj	\
		coll.obj	\
		cont.obj	\
		cpucvt.obj	\
		crc16.obj	\
		crcccitt.obj	\
		crcstrm.obj	\
		datetime.obj	\
		delay.obj	\
		environ.obj	\
		errlog.obj	\
		filecoll.obj	\
		filepath.obj	\
		filesel.obj	\
		filesys.obj	\
		frame.obj	\
		fviewer.obj	\
		inifile.obj	\
		itemlbl.obj	\
		itemwin.obj	\
		kbd.obj		\
		keydef.obj	\
		keymap.obj	\
		listnode.obj	\
		memcheck.obj	\
		memstrm.obj	\
		menue.obj	\
		menuedit.obj	\
		menuitem.obj	\
		msg.obj		\
		msgcoll.obj	\
		national.obj	\
		nlsinit.obj	\
		nullstrm.obj	\
		object.obj	\
		palette.obj	\
		password.obj	\
		program.obj	\
		progutil.obj	\
		rect.obj	\
		regtask.obj	\
		rescoll.obj	\
		resource.obj	\
		screen.obj	\
		sercom.obj	\
		settings.obj	\
		splitmsg.obj	\
		statline.obj	\
		stdmenue.obj	\
		stdmsg.obj	\
		str.obj		\
		strbox.obj	\
		strcoll.obj	\
		strcvt.obj	\
		stream.obj	\
		strmable.obj	\
		strparse.obj	\
		strpool.obj	\
		syserror.obj	\
		textitem.obj	\
		textstrm.obj	\
		thread.obj	\
		winattr.obj	\
		window.obj	\
		winsize.obj


#
# Additional target specific modules
#
!if $(TARGET)==DOS
XOBJS	=	_sercom.obj
!endif

!if $(TARGET)==DOS32
XOBJS	=	_sercom.obj
!endif



.PRECIOUS $(OBJS:.obj=.cc) $(LIB)



# ------------------------------------------------------------------------------
# All resedit OBJ files

RESEDITOBJS	=	resed.obj	\
			resedit.obj	\
			resfile.obj	\
			resitem.obj	\
			resprint.obj	\
			resutil.obj	\
			reswin.obj

# ------------------------------------------------------------------------------
# Dummy targets. Beware: resed must be the default target

resed:	$(TARGET)\resed.exe

all:	dos dos32 os2

libs:	doslib dos32lib os2lib

lib:	libdir $(LIB)

dos:
	$(MAKE) -DTARGET=DOS

os2:
	$(MAKE) -DTARGET=OS2

dos32:
	$(MAKE) -DTARGET=DOS32

doslib:
	$(MAKE) -DTARGET=DOS lib

os2lib:
	$(MAKE) -DTARGET=OS2 lib

dos32lib:
	$(MAKE) -DTARGET=DOS32 lib


# ------------------------------------------------------------------------------
# Make the needed directories

libdir:
	@- if not exist $(LIBDIR) mkdir $(LIBDIR) > nul

# ------------------------------------------------------------------------------
# Resource editor

$(TARGET)\resed.exe:	lib $(RESEDITOBJS)
	$(LD) system $(SYSTEM) @&&|
DEBUG all
NAME resed.exe
OPTION DOSSEG
OPTION STACK=32K
FILE $(TARGET)\resed.obj
FILE $(TARGET)\resedit.obj
FILE $(TARGET)\resfile.obj
FILE $(TARGET)\resitem.obj
FILE $(TARGET)\resprint.obj
FILE $(TARGET)\resutil.obj
FILE $(TARGET)\reswin.obj
FILE $(LIB)
|
	@$(MV) resed.exe $(TARGET)

# ------------------------------------------------------------------------------
# File-Transfer program

filetran:	$(TARGET)\filetran.exe

$(TARGET)\filetran.exe: lib filetran.obj
	$(LD) system $(SYSTEM) @&&|
DEBUG all
NAME filetran.exe
OPTION DOSSEG
OPTION STACK=32K
FILE $(TARGET)\filetran.obj
FILE $(LIB)
|
	@$(MV) filetran.exe $(TARGET)

# ------------------------------------------------------------------------------
# Library

$(LIB): $(OBJS) $(XOBJS)
	@echo Creating librarian job file
	-@if exist lib.job del /Q lib.job
	&@echo +-$? >> lib.job
	$(AR) -q -b -P=64 $(LIB) @lib.job
	-@del /Q lib.job

# ------------------------------------------------------------------------------
# OS specific modules

delay.obj:	$(TARGET)SRC\delay.cc
	$(CC) $(CCCFG) -c $**
	@$(MV) $. $(TARGET)

filesys.obj:	$(TARGET)SRC\filesys.cc
	$(CC) $(CCCFG) -c $**
	@$(MV) $. $(TARGET)

kbd.obj:	$(TARGET)SRC\kbd.cc
	$(CC) $(CCCFG) -c $**
	@$(MV) $. $(TARGET)

nlsinit.obj:	$(TARGET)SRC\nlsinit.cc
	$(CC) $(CCCFG) -c $**
	@$(MV) $. $(TARGET)

screen.obj:	$(TARGET)SRC\screen.cc
	$(CC) $(CCCFG) -c $**
	@$(MV) $. $(TARGET)

sercom.obj:	$(TARGET)SRC\sercom.cc
	$(CC) $(CCCFG) -c $**
	@$(MV) $. $(TARGET)

_sercom.obj:	$(TARGET)SRC\_sercom.asm
	$(AS) -m3 -mx -zi $**
	@$(MV)	$. $(TARGET)

user.obj:	$(TARGET)SRC\user.cc
	$(CC) $(CCCFG) -c $**
	@$(MV) $. $(TARGET)

# ------------------------------------------------------------------------------
# create a ZIP file

zip:
	-del spunk.zip
	-del /S *.bak
	$(ZIP) $(ZIPFILE) *.cc *.h bccdos.cfg bccos2.cfg baseres.res resed.res
	-copy makefile make\watcom.mak
	$(ZIP) $(ZIPFILE) spunk.chg make\*.*
	$(ZIP) $(ZIPFILE) dossrc\*.cc dossrc\*.asm
	$(ZIP) $(ZIPFILE) dos32src\*.cc dos32src\*.asm djgppsrc\*.cc
	$(ZIP) $(ZIPFILE) linuxsrc\*.cc os2src\*.cc bsdsrc\*.cc unixsrc\*.cc
	$(ZIP) $(ZIPFILE) xsrc\*.cc
	$(ZIP) $(ZIPFILE) doc\*.doc support\*.* data\*.*

# ------------------------------------------------------------------------------
# clean up

clean:
	-del /S *.bak

zap:	clean
	-del $(TARGET)\*.obj



