/*****************************************************************************/
/*                                                                           */
/*                                 CHARSET.CC                                */
/*                                                                           */
/* (C) 1995     Ullrich von Bassewitz                                        */
/*              Zwehrenbuehlstrasse 33                                       */
/*              D-72070 Tuebingen                                            */
/* EMail:       uz@ibb.schwaben.com                                          */
/*                                                                           */
/*****************************************************************************/



// $Id$
//
// $Log$
//
//



#include "streamid.h"
#include "stream.h"
#include "charset.h"



// Register class CharSet
LINK(CharSet, ID_CharSet);



/*****************************************************************************/
/*                               class CharSet                               */
/*****************************************************************************/



void CharSet::Load (Stream& S)
{
    S.Read (Buf, sizeof (Buf));
}



void CharSet::Store (Stream& S) const
{
    S.Write (Buf, sizeof (Buf));
}



u16 CharSet::StreamableID () const
{
    return ID_CharSet;
}



Streamable* CharSet::Build ()
{
    return new CharSet (Empty);
}



// Traverse through all bits that are set
int CharSet::Traverse (int Forward, int (*F) (char, void*), void* Data) const
{
    int I;

    if (Forward) {
        for (I = 0; I < 256; I++) {
            if ((Buf [I / 8] >> (I % 8)) & 0x01) {
                if (F (I, Data) != 0) {
                    return I;
                }
            }
        }
    } else {
        for (I = 255; I >= 0; I--) {
            if ((Buf [I / 8] >> (I % 8)) & 0x01) {
                if (F (I, Data) != 0) {
                    return I;
                }
            }
        }
    }

    // Not found
    return -1;
}



CharSet& CharSet::operator = (const CharSet& Set)
{
    if (this != &Set) {
        memcpy (Buf, Set.Buf, sizeof (Buf));
    }
    return *this;
}



CharSet& CharSet::operator += (const CharSet& Set)
{
    for (int I = 0; I < 256; I++) {
        Buf [I] |= Set.Buf [I];
    }
    return *this;
}



CharSet& CharSet::operator -= (const CharSet& Set)
{
    for (int I = 0; I < 256; I++) {
        Buf [I] &= ~Set.Buf [I];
    }
    return *this;
}



CharSet operator ~ (const CharSet& Set)
{
    CharSet NewSet = Set;
    return NewSet.Reverse ();
}



CharSet operator + (const CharSet& Set, unsigned char C)
{
    CharSet NewSet = Set;
    return (NewSet += C);
}



CharSet operator + (const CharSet& Set1, const CharSet& Set2)
{
    CharSet NewSet = Set1;
    return (NewSet += Set2);
}



CharSet operator - (const CharSet& Set, unsigned char C)
{
    CharSet NewSet = Set;
    return (NewSet -= C);
}



CharSet operator - (const CharSet& Set1, const CharSet& Set2)
{
    CharSet NewSet = Set1;
    return (NewSet -= Set2);
}



int CharSet::IsEmpty ()
// Return true if the charset is empty, return false otherwise
{
    for (unsigned I = 0; I < sizeof (Buf); I++) {
        if (Buf [I] != 0) {
            // Not empty
            return 0;
        }
    }

    // Empty
    return 1;
}



CharSet& CharSet::AddRange (unsigned char C1, unsigned char C2)
// Adds a complete range of characters to the character set
{
    unsigned U1 = C1;
    unsigned U2 = C2;
    while (U1 <= U2) {
        *this += (char) U1;
        U1++;
    }
    return *this;
}



CharSet& CharSet::Reverse ()
// Reverse the set
{
    for (unsigned I = 0; I < sizeof (Buf); I++) {
        Buf [I] ^= 0xFF;
    }
    return *this;
}



