# *****************************************************************************
# *									      *
# *			   ESTIC Makefile for Linux			      *
# *									      *
# * (C) 1995	 Ullrich von Bassewitz					      *
# *		 Zwehrenbuehlstrasse 33					      *
# *		 D-72070 Tuebingen					      *
# * EMail:	 uz@ibb.schwaben.de					      *
# *									      *
# *****************************************************************************



# $Id$
#
# $Log$
#
#



# ------------------------------------------------------------------------------
# Definitions

# Names of executables
AS = gas
AR = ar
LD = ld
ZIP = zip
CC = g++

LIB	= ../spunk/spunk.a
INCDIR	= ../spunk

# Use the second line for gcc version 2.6.0 and above
CFLAGS	= -DLINUX -g -O2 -Wall -I$(INCDIR) -pipe -x c++
#CFLAGS  = -DLINUX -g -O2 -Wall -I$(INCDIR) -pipe -x c++ -fno-implicit-templates -DEXPLICIT_TEMPLATES

# ------------------------------------------------------------------------------
# Implicit rules

.c.o:
	$(CC) $(CFLAGS) -c $<

.cc.o:
	$(CC) $(CFLAGS) -c $<

# ------------------------------------------------------------------------------
# All OBJ files

OBJS =		istec.o		\
		icalias.o	\
		icbaseed.o	\
		icconfig.o	\
		iccom.o		\
		iccwin.o	\
		icdevs.o	\
		icdiag.o	\
		icdlog.o	\
		icerror.o	\
		icident.o	\
		icimon.o	\
		iclog.o		\
		icwinmgr.o

ICLOADOBJS =	icalias.o	\
		iccom.o		\
		icconfig.o	\
		icdlog.o	\
		icerror.o	\
		icload.o	\
		iclog.o		\
		icdiag.o

# ------------------------------------------------------------------------------
#

ifeq (.depend,$(wildcard .depend))
all:	estic
include .depend
else
all:	depend
endif


estic:	$(LIB) $(OBJS)
	$(CC) -o estic $(OBJS) $(LIB) -ltermcap -lg -lg++

icload: $(LIB) $(ICLOADOBJS)
	$(CC) -o icload $(ICLOADOBJS) $(LIB) -ltermcap -lg -lg++

# ------------------------------------------------------------------------------
# Create a dependency file

depend dep:
	@echo "Creating dependency information"
	$(CC) -I$(INCDIR) -DLINUX -MM *.cc > .depend

# ------------------------------------------------------------------------------
# Create a ZIP file

strip:
	strip estic icload


zip:
	-rm -f estic.zip
	-rm -f *~
	cp Makefile linux.mak
	$(ZIP) -9 estic.zip *.cc *.h estic.res estic.ini *.doc *.chg *.mak alias.dat

bin-dist:	estic icload strip
	-rm -f estic.zip
	$(ZIP) -9 estic.zip estic icload estic.res estic.doc estic.chg estic.ini alias.dat

# ------------------------------------------------------------------------------
# clean up

clean:
	-rm *.bak *~

zap:	clean
	-rm *.o
	-rm .depend


