/*****************************************************************************/
/*									     */
/*				    REGTASK.CC				     */
/*									     */
/* (C) 1993-95	Ullrich von Bassewitz					     */
/*		Zwehrenbuehlstrasse 33					     */
/*		D-72070 Tuebingen					     */
/* EMail:	uz@ibb.schwaben.com					     */
/*									     */
/*****************************************************************************/



// $Id$
//
// $Log$
//
//



// Define a regular task object that is called in intervalls at idle times
// by the application. This is an abstract object, the derived class must
// override the Work() method.
// The object itself is not derived from class Streamable, so it's not
// possible to write an object derived only from class RegularTask to a
// stream. The usual way is to use multiple inheritance, with one of the base
// classes (an ItemWindow for example) derived from class Streamable, the
// other being class RegularTask. If you do this, you may call Load/Store to
// handle writing object data to a stream and the build constructor to build
// an empty object.
// This solution has been choosen to avoid problems with multiple inheritance.



#include "regtask.h"
#include "program.h"



/*****************************************************************************/
/*			       class RegularTask			     */
/*****************************************************************************/



RegularTask::RegularTask (unsigned HowToCall):
    TickCount (1),
    RTNode (this),
    How (HowToCall)
// Create a RegularTask object
{
    // Insert the node into the applications list
    App->AddRegularTask (*this);
}



RegularTask::RegularTask (StreamableInit):
    RTNode (this)
// Build constructor: create an empty object
{
}



RegularTask::~RegularTask ()
// Delete the regular task object.
{
    // Unlink the task from the applications task list
    App->RemoveRegularTask (*this);
}



void RegularTask::Load (Stream& S)
// Load an object from a stream
{
    // Load the data
    S >> TickCount >> How;

    // Link the node into the applications task list
    App->AddRegularTask (*this);
}



void RegularTask::Store (Stream& S) const
// Store an object into a stream
{
    S << TickCount << How;
}

