/*****************************************************************************/
/*                                                                           */
/*                                   CRC.H                                   */
/*                                                                           */
/* (C) 1993-95  Ullrich von Bassewitz                                        */
/*              Zwehrenbuehlstrasse 33                                       */
/*              D-72070 Tuebingen                                            */
/* EMail:       uz@ibb.schwaben.com                                          */
/*                                                                           */
/*****************************************************************************/



// $Id$
//
// $Log$
//
//



// The functions declared in this header file are contained in more than one
// .cc file. This is  because rather large tables are used and with more than
// one object file, the linker is able to sort out the needed ones.



#ifndef __CRC_H
#define __CRC_H



#include <stdlib.h>

#include "machine.h"



/*****************************************************************************/
/*                                   Code                                    */
/*****************************************************************************/



u16 CRC_CCITT (u16 StartCRC, const void* Buf, size_t BufSize);
// Calculate the crc over the data in the buffer using the CCITT polynom
// x^16 + x^12 + x^5 + 1

void CRC_CCITT (char B, u16& CRC);
// One byte version of the above

u16 CRC_16 (u16 StartCRC, const void* Buf, size_t BufSize);
// Calculate the crc over the data in the buffer using the polynom
// x^16 + x^15 + x^2 + 1

void CRC_16 (char B, u16& CRC);
// One byte version of the above



// End of CRC.H

#endif


