/*****************************************************************************/
/*									     */
/*				    ICCOM.H				     */
/*									     */
/* (C) 1995	Ullrich von Bassewitz					     */
/*		Zwehrenbuehlstrasse 33					     */
/*		D-72070 Tuebingen					     */
/* EMail:	uz@ibb.schwaben.com					     */
/*									     */
/*****************************************************************************/



// $Id$
//
// $Log$
//
//



#ifndef _ICCOM_H
#define _ICCOM_H



#include "str.h"

#include "icconfig.h"



/*****************************************************************************/
/*				     Data				     */
/*****************************************************************************/



// Port address and irq used
extern unsigned PortBase;
extern unsigned PortIRQ;

// Current ISTEC charges and a flag that is set to 1 on an update
extern IstecCharges Charges;
extern int ChargeUpdate;



/*****************************************************************************/
/*			     Com port related code			     */
/*****************************************************************************/



void CloseComPort ();
// Close the com port

int OpenComPort (const String& PortName);
// Try to open the com port. If the port is already open, it is closed and
// reopened. The function returns 0 on success and an error code on failure.

int ComPortAvail ();
// Return 1 if the com port is open, 0 if not



/*****************************************************************************/
/*			 Low level ISTEC specific code			     */
/*****************************************************************************/



void IstecPoll ();
// Poll the istec for incoming debug messages. If we get a real message, store
// it in LastIstecMsg (there should be only one outstanding real message at a
// time).



/*****************************************************************************/
/*			High level ISTEC specific code			     */
/*****************************************************************************/



// All of the following functions may return a return code as specified below:
//
//	-5 Receive buffer overlow (ESTIC error - should not happen)
//	-4 Receive buffer underflow (ESTIC error - should not happen)
//	-3 Wrong device number in reply
//	-2 Invalid reply code
//	-1 Port is not open
//	 0 Timeout
//	 1 Done
//
const int ieRecBufOverflow	= -5;
const int ieRecBufUnderflow	= -4;
const int ieWrongDevice		= -3;
const int ieInvalidReply	= -2;
const int iePortNotOpen		= -1;
const int ieTimeout		=  0;
const int ieDone		=  1;



void IstecErrorSync ();
// Try to resync the istec after an error

int IstecReady ();
// Check if the istec answers the "Ready" message.

int IstecGetBaseConfig (IstecBaseConfig& Config);
// Request the basic configuration from the istec.

int IstecGetDevConfig (DevConfig* Config, unsigned DevCount);
// Request the device configurations from the istec.

int IstecRequestCharges ();
// Request the device charges from the istec. This function is different from
// the "Get" functions as it does not wait for a reply. The charge messages
// from the ISTEC are handled by the IstecPoll function in the background.
// If new charges are available, they are copied to Charges and the
// ChargeUpdate flag is set.

int IstecGetConfig (IstecBaseConfig& BaseConfig, DevConfig* DevConfig);
// Get the complete configuration from the istec

int IstecPutCharges (const IstecCharges& Charges);
// Write the given charges to the istec and to Charges

int IstecPutDevConfig (const DevConfig* Config, unsigned Count);
// Write a set of device configuration data to the istec.

int IstecPutBaseConfig (const IstecBaseConfig& Config);
// Write a base configuration to the istec

int IstecMakePermanent ();
// Send the command to the istec to store the current configuration into the
// EEPROM.

int IstecPutConfig (IstecBaseConfig& BaseConfig,
		    DevConfig* DevConfig,
		    unsigned DevCount);
// Write the complete configuration to the istec. To make things short, the
// number of devices is given as an parameter

int IstecDiagOn ();
// Switch the istec into diag mode

int IstecDiagOff ();
// Disable diag mode



// End of ICCOM.H

#endif




